/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.redstonegames.visitingvillagers.entity.ModEntities;
import net.redstonegames.visitingvillagers.entity.custom.BabyVisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

@Mod.EventBusSubscriber(modid="visitingvillagers")
public class CustomSpawnManager {
    private static final boolean DEBUG_MODE = false;
    private static final int SPAWN_CHECK_INTERVAL = 100;
    private static final int DEBUG_MESSAGE_INTERVAL = 400;
    private static int tickCounter = 0;
    private static final int MAX_SPAWNS_PER_CYCLE = 3;
    private static final int MIN_ADULTS_FOR_BABY = 2;
    private static final int ADULTS_PER_BABY_RATIO = 2;
    private static final int BABY_POPULATION_BONUS = 3;
    private static final int MAX_WANDERING_VISITORS = 2;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (++tickCounter % 100 != 0) {
                return;
            }
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                boolean canSpawnWandering;
                ServerLevel level = player.m_284548_();
                BlockPos playerPos = player.m_20183_();
                long daytime = level.m_46468_() % 24000L;
                AABB searchBox = new AABB(playerPos).m_82400_(128.0);
                List villagers = level.m_6443_(Villager.class, searchBox, e -> true);
                List golems = level.m_6443_(IronGolem.class, searchBox, e -> true);
                List allVisitorNpcs = level.m_6443_(VisitorEntity.class, searchBox, e -> true);
                List wanderingVisitors = level.m_6443_(WanderingVisitorEntity.class, searchBox, e -> true);
                ArrayList<VisitorEntity> adultNpcs = new ArrayList<VisitorEntity>();
                ArrayList<BabyVisitorEntity> babyNpcs = new ArrayList<BabyVisitorEntity>();
                for (VisitorEntity npc : allVisitorNpcs) {
                    if (npc instanceof BabyVisitorEntity) {
                        babyNpcs.add((BabyVisitorEntity)npc);
                        continue;
                    }
                    adultNpcs.add(npc);
                }
                if (villagers.size() >= 6 && golems.size() >= 1 && adultNpcs.size() < villagers.size() && daytime > 500L && daytime < 12000L) {
                    int npcsToSpawn = Math.min(villagers.size() - adultNpcs.size(), 3);
                    for (int i = 0; i < npcsToSpawn && !villagers.isEmpty(); ++i) {
                        Villager targetVillager = (Villager)villagers.get(level.f_46441_.m_188503_(villagers.size()));
                        CustomSpawnManager.findSafeSpawnLocation(level, targetVillager.m_20183_(), 10).ifPresent(spawnPos -> ((EntityType)ModEntities.VISITOR.get()).m_262496_(level, spawnPos, MobSpawnType.EVENT));
                    }
                }
                int babyCap = adultNpcs.size() / 2 + 3;
                if (adultNpcs.size() >= 2 && babyNpcs.size() < babyCap && daytime > 500L && daytime < 12000L) {
                    if (adultNpcs.isEmpty()) break;
                    VisitorEntity targetAdult = (VisitorEntity)((Object)adultNpcs.get(level.f_46441_.m_188503_(adultNpcs.size())));
                    CustomSpawnManager.findSafeSpawnLocation(level, targetAdult.m_20183_(), 8).ifPresent(spawnPos -> ((EntityType)ModEntities.BABY_VISITOR.get()).m_262496_(level, spawnPos, MobSpawnType.EVENT));
                }
                boolean bl = canSpawnWandering = villagers.size() >= 6 && golems.size() >= 1 && daytime < 12000L;
                if (canSpawnWandering && wanderingVisitors.isEmpty() && daytime > 1500L && !golems.isEmpty()) {
                    IronGolem targetGolem = (IronGolem)golems.get(level.f_46441_.m_188503_(golems.size()));
                    CustomSpawnManager.findSafeSpawnLocation(level, targetGolem.m_20183_(), 25).ifPresent(spawnPos -> ((EntityType)ModEntities.WANDERING_VISITOR.get()).m_262496_(level, spawnPos, MobSpawnType.EVENT));
                }
                if (!canSpawnWandering || wanderingVisitors.size() != 1) continue;
                WanderingVisitorEntity firstVisitor = (WanderingVisitorEntity)((Object)wanderingVisitors.get(0));
                boolean hasLivedLongEnough = firstVisitor.f_19797_ > 600;
                if (!hasLivedLongEnough || daytime <= 4500L || golems.isEmpty()) continue;
                IronGolem targetGolem = (IronGolem)golems.get(level.f_46441_.m_188503_(golems.size()));
                CustomSpawnManager.findSafeSpawnLocation(level, targetGolem.m_20183_(), 25).ifPresent(spawnPos -> ((EntityType)ModEntities.WANDERING_VISITOR.get()).m_262496_(level, spawnPos, MobSpawnType.EVENT));
            }
        }
    }

    private static Optional<BlockPos> findSafeSpawnLocation(ServerLevel level, BlockPos center, int radius) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = center.m_123341_() + level.f_46441_.m_188503_(radius * 2) - radius;
            BlockPos topPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z = center.m_123343_() + level.f_46441_.m_188503_(radius * 2) - radius));
            if (level.m_45924_((double)topPos.m_123341_(), (double)topPos.m_123342_(), (double)topPos.m_123343_(), 24.0, false) != null || !level.m_8055_(topPos.m_7495_()).m_204336_(ModTags.Blocks.VISITORS_SPAWNABLE_ON) || !level.m_46859_(topPos) || !level.m_46859_(topPos.m_7494_())) continue;
            return Optional.of(topPos);
        }
        return Optional.empty();
    }
}

