/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.util;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class RandomRocketFactory
implements VillagerTrades.ItemListing {
    private final int baseEmeraldCost;
    private final int maxUses;
    private final int experience;

    public RandomRocketFactory(int baseEmeraldCost, int maxUses, int experience) {
        this.baseEmeraldCost = baseEmeraldCost;
        this.maxUses = maxUses;
        this.experience = experience;
    }

    @Nullable
    public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
        int finalPrice = this.baseEmeraldCost;
        ItemStack rocket = new ItemStack((ItemLike)Items.f_42688_, 1);
        CompoundTag fireworksNbt = rocket.m_41698_("Fireworks");
        int flightDuration = rand.m_188503_(3) + 1;
        fireworksNbt.m_128344_("Flight", (byte)flightDuration);
        finalPrice += flightDuration - 1;
        CompoundTag explosionNbt = new CompoundTag();
        DyeColor dyeColor = DyeColor.values()[rand.m_188503_(DyeColor.values().length)];
        explosionNbt.m_128385_("Colors", new int[]{dyeColor.m_41070_()});
        FireworkRocketItem.Shape shape = FireworkRocketItem.Shape.values()[rand.m_188503_(FireworkRocketItem.Shape.values().length)];
        explosionNbt.m_128344_("Type", (byte)shape.m_41236_());
        switch (shape) {
            case LARGE_BALL: 
            case STAR: 
            case BURST: {
                finalPrice += 2;
                break;
            }
            case CREEPER: {
                finalPrice += 3;
            }
        }
        if (rand.m_188499_()) {
            explosionNbt.m_128379_("Trail", true);
            finalPrice += 2;
        }
        if (rand.m_188499_()) {
            explosionNbt.m_128379_("Flicker", true);
            finalPrice += 2;
        }
        ListTag explosions = new ListTag();
        explosions.add((Object)explosionNbt);
        fireworksNbt.m_128365_("Explosions", (Tag)explosions);
        return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, finalPrice), rocket, this.maxUses, this.experience, 0.05f);
    }
}

