/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1439;
import net.minecraft.class_1646;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7157;
import net.redstonegames.visitingvillagers.entity.ModEntities;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

public class VisitorCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"visitors").then(class_2170.method_9247((String)"check").executes(VisitorCommands::runCheckCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)512)).executes(context -> VisitorCommands.runClearCommand((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"population").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)10, (int)500)).executes(context -> VisitorCommands.runPopulationCommand((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))));
    }

    private static int runCheckCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 world = player.method_51469();
        class_238 searchBox = new class_238(player.method_24515()).method_1014(128.0);
        List golems = world.method_8390(class_1439.class, searchBox, e -> true);
        List villagers = world.method_8390(class_1646.class, searchBox, e -> true);
        List wanderingVisitors = world.method_8390(WanderingVisitorEntity.class, searchBox, e -> true);
        List allVisitors = world.method_8390(VisitorEntity.class, searchBox, e -> true);
        ArrayList<VisitorEntity> adultVisitors = new ArrayList<VisitorEntity>();
        ArrayList<VisitorEntity> babyVisitors = new ArrayList<VisitorEntity>();
        for (VisitorEntity visitor : allVisitors) {
            if (visitor.method_6109()) {
                babyVisitors.add(visitor);
                continue;
            }
            adultVisitors.add(visitor);
        }
        class_5250 message = class_2561.method_43470((String)(" \u00a7bVisitor: \u00a7e" + adultVisitors.size() + "\u00a7f - \u00a7aVillager: \u00a7e" + villagers.size() + "\u00a7f - \u00a7bBaby: \u00a7e" + babyVisitors.size() + "\u00a7f - \u00a7aGolem: \u00a7e" + golems.size() + "\u00a7f - \u00a7bWander: \u00a7e" + wanderingVisitors.size() + "\u00a7f"));
        source.method_9226(() -> VisitorCommands.lambda$runCheckCommand$8((class_2561)message), false);
        return golems.size() + villagers.size() + allVisitors.size() + wanderingVisitors.size();
    }

    private static int runClearCommand(CommandContext<class_2168> context, int radius) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_238 searchBox = new class_238(player.method_24515()).method_1014((double)radius);
        List villageVisitors = player.method_51469().method_8390(VisitorEntity.class, searchBox, e -> true);
        List wanderingVisitors = player.method_51469().method_8390(WanderingVisitorEntity.class, searchBox, e -> true);
        int villageCount = villageVisitors.size();
        int wanderingCount = wanderingVisitors.size();
        int totalCount = villageCount + wanderingCount;
        for (VisitorEntity visitor : villageVisitors) {
            visitor.method_31472();
        }
        for (WanderingVisitorEntity wandering : wanderingVisitors) {
            wandering.removeLeashedAnimals();
            wandering.method_31472();
        }
        class_5250 message = class_2561.method_43470((String)("\u00a7c" + totalCount + "\u00a7f visitor(s) removed within a radius of \u00a7e" + radius + "\u00a7f blocks. (" + villageCount + " visitors, " + wanderingCount + " wandering)"));
        source.method_9226(() -> VisitorCommands.lambda$runClearCommand$11((class_2561)message), true);
        return totalCount;
    }

    private static int runPopulationCommand(CommandContext<class_2168> context, int amount, int radius) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 world = player.method_51469();
        class_5819 random = world.method_8409();
        int visitorsSpawned = 0;
        int maxTriesPerVisitor = 10;
        block0: for (int i = 0; i < amount; ++i) {
            for (int tryNum = 0; tryNum < maxTriesPerVisitor; ++tryNum) {
                VisitorEntity visitor;
                double z;
                double angle = random.method_43058() * 2.0 * Math.PI;
                double distance = Math.sqrt(random.method_43058()) * (double)radius;
                double x = player.method_23317() + distance * Math.cos(angle);
                class_2338 spawnPos = world.method_8598(class_2902.class_2903.field_13202, class_2338.method_49637((double)x, (double)0.0, (double)(z = player.method_23321() + distance * Math.sin(angle))));
                class_2338 groundPos = spawnPos.method_10074();
                if (!world.method_8320(groundPos).method_26164(ModTags.Blocks.VISITORS_SPAWNABLE_ON) || !VisitorEntity.canSpawn(ModEntities.VISITOR, (class_1936)world, class_3730.field_16462, spawnPos, random) || (visitor = (VisitorEntity)ModEntities.VISITOR.method_5883((class_1937)world)) == null) continue;
                visitor.method_20620((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                visitor.method_5943((class_5425)world, world.method_8404(spawnPos), class_3730.field_16462, null, null);
                world.method_8649((class_1297)visitor);
                ++visitorsSpawned;
                continue block0;
            }
        }
        class_5250 message = class_2561.method_43470((String)("\u00a7a" + visitorsSpawned + "\u00a7f visitor(s) spawned on valid blocks within a radius of \u00a7e" + radius + "\u00a7f blocks."));
        source.method_9226(() -> VisitorCommands.lambda$runPopulationCommand$12((class_2561)message), true);
        return visitorsSpawned;
    }

    private static /* synthetic */ class_2561 lambda$runPopulationCommand$12(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$runClearCommand$11(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$runCheckCommand$8(class_2561 message) {
        return message;
    }
}

