/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.custom;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1358;
import net.minecraft.class_1361;
import net.minecraft.class_1364;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1390;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3853;
import net.minecraft.class_3988;
import net.minecraft.class_4018;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtDayGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtNightGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnWhenPlayerSleepsGoal;
import net.redstonegames.visitingvillagers.entity.variant.WanderingVisitorVariant;
import net.redstonegames.visitingvillagers.util.ModTags;
import net.redstonegames.visitingvillagers.util.WanderingVisitorTrades;
import org.jetbrains.annotations.Nullable;

public class WanderingVisitorEntity
extends class_3988 {
    private int pricePenalty = 0;
    private int leashDelay = 0;
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(WanderingVisitorEntity.class, (class_2941)class_2943.field_13327);

    public WanderingVisitorEntity(class_1299<? extends class_3988> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new class_1364((class_3988)this));
        this.field_6201.method_6277(1, (class_1352)new class_1390((class_3988)this));
        this.field_6201.method_6277(1, (class_1352)new class_1338((class_1314)this, class_1642.class, 15.0f, 1.2, 1.6));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.6));
        this.field_6201.method_6277(2, (class_1352)new DespawnWhenPlayerSleepsGoal((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new GoToVillageGoal(32));
        this.field_6201.method_6277(3, (class_1352)new class_1358((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1308.class, 4.0f));
        this.field_6201.method_6277(9, (class_1352)new DespawnAtDayGoal((class_1308)this, 64.0, true));
        this.field_6201.method_6277(9, (class_1352)new DespawnAtNightGoal((class_1308)this, 24.0, true));
    }

    public static class_5132.class_5133 createWanderingVisitorAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23724, 0.5);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (!itemStack.method_31574(class_1802.field_8086) && this.method_5805() && !this.method_18009()) {
            if (hand == class_1268.field_5808) {
                player.method_7281(class_3468.field_15384);
            }
            if (this.method_8264().isEmpty()) {
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (!this.method_37908().field_9236) {
                this.method_8259(player);
                this.method_17449(player, this.method_5476(), 1);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    protected void method_7237() {
        WanderingVisitorVariant variant = this.getVariant();
        Map<Integer, class_3853.class_1652[]> tradesForVariant = WanderingVisitorTrades.VARIANT_TRADES.get((Object)variant);
        if (tradesForVariant == null) {
            tradesForVariant = WanderingVisitorTrades.VARIANT_TRADES.get((Object)WanderingVisitorVariant.DEFAULT);
        }
        if (tradesForVariant == null) {
            return;
        }
        class_3853.class_1652[] factoriesLevel1 = tradesForVariant.get(1);
        class_3853.class_1652[] factoriesLevel2 = tradesForVariant.get(2);
        if (factoriesLevel1 == null && factoriesLevel2 == null) {
            return;
        }
        class_1916 tradeOfferList = this.method_8264();
        int buysToSelect = 4;
        int sellsToSelect = 4;
        if (variant == WanderingVisitorVariant.TEXTURE7) {
            buysToSelect = 6;
            sellsToSelect = 6;
        }
        if (factoriesLevel1 != null) {
            this.method_19170(tradeOfferList, factoriesLevel1, buysToSelect);
        }
        if (factoriesLevel2 != null) {
            this.method_19170(tradeOfferList, factoriesLevel2, sellsToSelect);
        }
        if (this.pricePenalty > 0) {
            for (class_1914 offer : tradeOfferList) {
                offer.method_8245(this.pricePenalty);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.leashDelay > 0) {
            --this.leashDelay;
            if (this.leashDelay == 0) {
                this.spawnAnimals((class_3218)this.method_37908());
            }
        }
    }

    protected void method_18008(class_1914 offer) {
        if (offer.method_8256()) {
            int i = 3 + this.field_5974.method_43048(4);
            this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), i));
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean damaged = super.method_5643(source, amount);
        if (damaged && !this.method_37908().method_8608() && source.method_5529() instanceof class_1657 && this.pricePenalty < 10) {
            ++this.pricePenalty;
            this.field_17721 = null;
        }
        return damaged;
    }

    public class_2561 method_5476() {
        WanderingVisitorVariant variant = this.getVariant();
        switch (variant) {
            case DEFAULT: {
                return class_2561.method_43471((String)"entity.visitingvillagers.wandering_visitor.plains");
            }
            case TEXTURE1: {
                return class_2561.method_43471((String)"entity.visitingvillagers.wandering_visitor.forest");
            }
            case TEXTURE2: {
                return class_2561.method_43471((String)"entity.visitingvillagers.wandering_visitor.cave");
            }
            case TEXTURE3: {
                return class_2561.method_43471((String)"entity.visitingvillagers.wandering_visitor.mountain");
            }
            case TEXTURE4: {
                return class_2561.method_43471((String)"entity.visitingvillagers.wandering_visitor.snow");
            }
            case TEXTURE5: {
                return class_2561.method_43471((String)"entity.visitingvillagers.wandering_visitor.swamp");
            }
            case TEXTURE6: {
                return class_2561.method_43471((String)"entity.visitingvillagers.wandering_visitor.desert");
            }
            case TEXTURE7: {
                return class_2561.method_43471((String)"entity.visitingvillagers.wandering_visitor.plus");
            }
        }
        return super.method_5476();
    }

    public boolean method_19270() {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public boolean method_6109() {
        return false;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_18009() ? class_3417.field_17751 : class_3417.field_17747;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_17749;
    }

    protected class_3414 method_18012(boolean sold) {
        return sold ? class_3417.field_17752 : class_3417.field_17750;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_17748;
    }

    public void method_17449(class_1657 player, class_2561 name, int levelProgress) {
        super.method_17449(player, name, levelProgress);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
        nbt.method_10569("PricePenalty", this.pricePenalty);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
        this.pricePenalty = nbt.method_10550("PricePenalty");
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        WanderingVisitorVariant variant = (WanderingVisitorVariant)((Object)class_156.method_27173((Object[])WanderingVisitorVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        this.leashDelay = 10;
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private void spawnLeashedAnimal(class_3218 world, class_1266 difficulty, class_1299<? extends class_1429> type, @Nullable class_2338 existingAnimalPos) {
        class_2338 spawnPos = this.findLeashedAnimalPos((class_1936)world, this.method_24515(), 3, existingAnimalPos);
        class_1429 animal = (class_1429)type.method_5883((class_1937)world);
        if (animal != null) {
            animal.method_5725(spawnPos, 1.0f, 0.0f);
            animal.method_5943((class_5425)world, difficulty, class_3730.field_16467, null, null);
            world.method_30771((class_1297)animal);
            animal.method_5954((class_1297)this, true);
        }
    }

    private void spawnAnimals(class_3218 world) {
        class_1266 difficulty = world.method_8404(this.method_24515());
        WanderingVisitorVariant variant = this.getVariant();
        switch (variant) {
            case DEFAULT: {
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_6115, null);
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_6115, this.method_24515());
                break;
            }
            case TEXTURE1: {
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_17943, null);
                break;
            }
            case TEXTURE2: {
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_6074, null);
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_6074, this.method_24515());
                break;
            }
            case TEXTURE3: {
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_30052, null);
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_30052, this.method_24515());
                break;
            }
            case TEXTURE4: {
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_6139, null);
                break;
            }
            case TEXTURE5: {
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_37419, null);
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_37419, this.method_24515());
                break;
            }
            case TEXTURE6: {
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_40116, null);
                break;
            }
            case TEXTURE7: {
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_6139, null);
                this.spawnLeashedAnimal(world, difficulty, (class_1299<? extends class_1429>)class_1299.field_6139, this.method_24515());
            }
        }
    }

    public WanderingVisitorVariant getVariant() {
        return WanderingVisitorVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(WanderingVisitorVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private class_2338 findLeashedAnimalPos(class_1936 world, class_2338 pos, int range, @Nullable class_2338 existingAnimalPos) {
        class_2338 blockPos = pos;
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = this.field_5974.method_43048(range * 2) - range;
            class_2338 testPos = blockPos.method_10069(x, 0, z = this.field_5974.method_43048(range * 2) - range);
            if (!world.method_8320(testPos).method_26215() || existingAnimalPos != null && testPos.equals((Object)existingAnimalPos)) continue;
            return testPos;
        }
        return blockPos;
    }

    public static boolean canSpawn(class_1299<? extends WanderingVisitorEntity> type, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModTags.Blocks.VISITORS_SPAWNABLE_ON);
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public void removeLeashedAnimals() {
        if (this.method_37908().field_9236) {
            return;
        }
        class_238 searchBox = this.method_5829().method_1014(16.0);
        List nearbyAnimals = this.method_37908().method_8390(class_1308.class, searchBox, animal -> animal.method_5934() && this.equals(animal.method_5933()));
        for (class_1308 animal2 : nearbyAnimals) {
            animal2.method_31472();
        }
    }

    class GoToVillageGoal
    extends class_4018 {
        public GoToVillageGoal(int searchRange) {
            super((class_1314)WanderingVisitorEntity.this, searchRange);
        }

        public boolean method_6264() {
            return super.method_6264() && this.canGoToVillage();
        }

        public boolean method_6266() {
            return super.method_6266() && this.canGoToVillage();
        }

        private boolean canGoToVillage() {
            return !WanderingVisitorEntity.this.method_18009();
        }
    }
}

