/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1439;
import net.minecraft.class_1646;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4153;
import net.minecraft.class_7477;
import net.minecraft.server.MinecraftServer;
import net.redstonegames.visitingvillagers.entity.ModEntities;
import net.redstonegames.visitingvillagers.entity.custom.BabyVisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

public class CustomSpawnManager {
    private static final boolean DEBUG_MODE = false;
    private static final int SPAWN_CHECK_INTERVAL = 100;
    private static final int VILLAGE_SEARCH_RADIUS = 128;
    private static final int DEBUG_MESSAGE_INTERVAL = 400;
    private static int tickCounter = 0;
    private static final int MAX_SPAWNS_PER_CYCLE = 3;
    private static final int MIN_ADULTS_FOR_BABY = 2;
    private static final int ADULTS_PER_BABY_RATIO = 2;
    private static final int BABY_POPULATION_BONUS = 3;
    private static final int MAX_WANDERING_VISITORS = 2;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(CustomSpawnManager::onServerTick);
    }

    private static void onServerTick(MinecraftServer server) {
        if (++tickCounter % 100 != 0) {
            return;
        }
        HashSet<class_2338> processedVillages = new HashSet<class_2338>();
        for (class_3222 player : server.method_3760().method_14571()) {
            boolean canSpawnWandering;
            class_2338 centerOfVillage;
            class_3218 world = player.method_51469();
            long daytime = world.method_8532() % 24000L;
            Optional villageCenterOptional = world.method_19494().method_20006(poiType -> poiType.method_40225(class_7477.field_39291), player.method_24515(), 128, class_4153.class_4155.field_18489);
            if (!villageCenterOptional.isPresent() || !processedVillages.add(centerOfVillage = (class_2338)villageCenterOptional.get())) continue;
            class_238 searchBox = new class_238(centerOfVillage).method_1014(128.0);
            List villagers = world.method_8390(class_1646.class, searchBox, e -> true);
            List golems = world.method_8390(class_1439.class, searchBox, e -> true);
            List allVisitorNpcs = world.method_8390(VisitorEntity.class, searchBox, e -> true);
            List wanderingVisitors = world.method_8390(WanderingVisitorEntity.class, searchBox, e -> true);
            ArrayList<VisitorEntity> adultNpcs = new ArrayList<VisitorEntity>();
            ArrayList<BabyVisitorEntity> babyNpcs = new ArrayList<BabyVisitorEntity>();
            for (VisitorEntity npc : allVisitorNpcs) {
                if (npc instanceof BabyVisitorEntity) {
                    babyNpcs.add((BabyVisitorEntity)npc);
                    continue;
                }
                adultNpcs.add(npc);
            }
            if (villagers.size() >= 6 && golems.size() >= 1 && adultNpcs.size() < villagers.size() && daytime > 500L && daytime < 12000L) {
                int npcsToSpawn = villagers.size() - adultNpcs.size();
                int spawnsThisCycle = Math.min(npcsToSpawn, 3);
                for (int i = 0; i < spawnsThisCycle; ++i) {
                    class_1646 targetVillager = (class_1646)villagers.get(world.field_9229.method_43048(villagers.size()));
                    CustomSpawnManager.findSafeSpawnLocation(world, targetVillager.method_24515(), 10).ifPresent(spawnPos -> ModEntities.VISITOR.method_47821(world, spawnPos, class_3730.field_16467));
                }
            }
            int babyCap = adultNpcs.size() / 2 + 3;
            if (adultNpcs.size() >= 2 && babyNpcs.size() < babyCap && daytime > 500L && daytime < 12000L) {
                if (adultNpcs.isEmpty()) continue;
                VisitorEntity targetAdult = (VisitorEntity)((Object)adultNpcs.get(world.field_9229.method_43048(adultNpcs.size())));
                CustomSpawnManager.findSafeSpawnLocation(world, targetAdult.method_24515(), 8).ifPresent(spawnPos -> ModEntities.BABY_VISITOR.method_47821(world, spawnPos, class_3730.field_16467));
            }
            boolean bl = canSpawnWandering = villagers.size() >= 6 && golems.size() >= 1 && daytime < 12000L;
            if (canSpawnWandering && wanderingVisitors.isEmpty() && daytime > 1500L && !golems.isEmpty()) {
                class_1439 targetGolem = (class_1439)golems.get(world.field_9229.method_43048(golems.size()));
                CustomSpawnManager.findSafeSpawnLocation(world, targetGolem.method_24515(), 25).ifPresent(spawnPos -> ModEntities.WANDERING_VISITOR.method_47821(world, spawnPos, class_3730.field_16467));
            }
            if (!canSpawnWandering || wanderingVisitors.size() != 1) continue;
            WanderingVisitorEntity firstVisitor = (WanderingVisitorEntity)((Object)wanderingVisitors.get(0));
            boolean hasLivedLongEnough = firstVisitor.field_6012 > 600;
            if (!hasLivedLongEnough || daytime <= 4500L || golems.isEmpty()) continue;
            class_1439 targetGolem = (class_1439)golems.get(world.field_9229.method_43048(golems.size()));
            CustomSpawnManager.findSafeSpawnLocation(world, targetGolem.method_24515(), 25).ifPresent(spawnPos -> ModEntities.WANDERING_VISITOR.method_47821(world, spawnPos, class_3730.field_16467));
        }
    }

    private static Optional<class_2338> findSafeSpawnLocation(class_3218 world, class_2338 center, int radius) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = center.method_10263() + world.field_9229.method_43048(radius * 2 + 1) - radius;
            class_2338 topPos = world.method_8598(class_2902.class_2903.field_13203, new class_2338(x, 0, z = center.method_10260() + world.field_9229.method_43048(radius * 2 + 1) - radius));
            if (world.method_18459((double)topPos.method_10263(), (double)topPos.method_10264(), (double)topPos.method_10260(), 24.0, false) != null || !world.method_8320(topPos.method_10074()).method_26164(ModTags.Blocks.VISITORS_SPAWNABLE_ON) || !world.method_22347(topPos) || !world.method_22347(topPos.method_10084())) continue;
            return Optional.of(topPos);
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$onServerTick$7(class_3222 p) {
        p.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aA Baby Visitor spawned near an adult!"), false);
    }

    private static /* synthetic */ boolean lambda$onServerTick$6(class_2338 centerOfVillage, class_3222 p) {
        return p.method_24515().method_19771((class_2382)centerOfVillage, 128.0);
    }
}

