/*
 * Decompiled with CFR 0.152.
 */
package dev.radialhotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RadialMenuScreen
extends Screen {
    private double lastMouseX = -1.0;
    private double lastMouseY = -1.0;
    private float initialYaw = 0.0f;
    private float initialPitch = 0.0f;
    private static final double MAX_YAW_OFFSET = 45.0;
    private static final double MAX_PITCH_OFFSET = 30.0;
    private int hoveredIndex = -1;
    private boolean hoveredMainHand = false;
    private boolean hoveredOffHand = false;
    private final List<ItemStack> hotbarItems = new ArrayList<ItemStack>();
    private static final int HOTBAR_SIZE = 9;
    private static final int HAND_CIRCLE_RADIUS = 20;
    private static final ResourceLocation RADIAL_TEXTURE = new ResourceLocation("radialhotbar", "textures/gui/radial_menu.png");

    public RadialMenuScreen() {
        super((Component)Component.m_237113_((String)"Radial Menu"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.collectHotbarItems();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.initialYaw = this.f_96541_.f_91074_.m_146908_();
            this.initialPitch = this.f_96541_.f_91074_.m_146909_();
        }
        this.lastMouseX = (double)this.f_96543_ / 2.0;
        this.lastMouseY = (double)this.f_96544_ / 2.0;
    }

    public boolean m_7043_() {
        return false;
    }

    private void collectHotbarItems() {
        this.hotbarItems.clear();
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        Inventory inv = this.f_96541_.f_91074_.m_150109_();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.hotbarItems.add(stack);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        RadialScreenMath.Radii radii = RadialScreenMath.computeRadii(this.hotbarItems.size());
        this.hoveredIndex = RadialScreenMath.pickSector(mouseX, mouseY, cx, cy, this.hotbarItems.size(), radii);
        this.checkHandCircleHover(mouseX, mouseY, cx, cy);
        this.drawRadialTexture(graphics, cx, cy);
        RadialScreenDraw.drawRing(graphics, this.f_96547_, cx, cy, this.hotbarItems, this.hoveredIndex, radii);
        this.drawHandItems(graphics, cx, cy);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void drawRadialTexture(GuiGraphics graphics, int cx, int cy) {
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            int textureSize = 256;
            int halfSize = textureSize / 2;
            graphics.m_280163_(RADIAL_TEXTURE, cx - halfSize, cy - halfSize, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void drawHandItems(GuiGraphics graphics, int cx, int cy) {
        boolean hasOff;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        ItemStack mainHand = this.f_96541_.f_91074_.m_21205_();
        ItemStack offHand = this.f_96541_.f_91074_.m_21206_();
        boolean isLeftHanded = this.f_96541_.f_91074_.m_5737_() == HumanoidArm.LEFT;
        boolean hasMain = !mainHand.m_41619_();
        boolean bl = hasOff = !offHand.m_41619_();
        if (hasMain && hasOff) {
            int mainX = isLeftHanded ? cx - 20 : cx + 4;
            int offX = isLeftHanded ? cx + 4 : cx - 20;
            this.drawHandCircle(graphics, mainX + 8, cy, this.hoveredMainHand);
            this.drawHandCircle(graphics, offX + 8, cy, this.hoveredOffHand);
            graphics.m_280480_(mainHand, mainX, cy - 8);
            graphics.m_280480_(offHand, offX, cy - 8);
        } else if (hasMain) {
            this.drawHandCircle(graphics, cx, cy, this.hoveredMainHand);
            graphics.m_280480_(mainHand, cx - 8, cy - 8);
        } else if (hasOff) {
            this.drawHandCircle(graphics, cx, cy, this.hoveredOffHand);
            graphics.m_280480_(offHand, cx - 8, cy - 8);
        }
    }

    private void drawHandCircle(GuiGraphics graphics, int cx, int cy, boolean hovered) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int color = hovered ? 0x44FFFFFF : 0x22FFFFFF;
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        float a = (float)(color >>> 24 & 0xFF) / 255.0f;
        float r = (float)(color >>> 16 & 0xFF) / 255.0f;
        float g = (float)(color >>> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        buf.m_252986_(pose, (float)cx, (float)cy, 0.0f).m_85950_(r, g, b, a).m_5752_();
        int segments = 32;
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = (float)((double)cx + Math.cos(angle) * 20.0);
            float y = (float)((double)cy + Math.sin(angle) * 20.0);
            buf.m_252986_(pose, x, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.disableBlend();
    }

    private void checkHandCircleHover(double mouseX, double mouseY, int cx, int cy) {
        boolean hasOff;
        this.hoveredMainHand = false;
        this.hoveredOffHand = false;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        ItemStack mainHand = this.f_96541_.f_91074_.m_21205_();
        ItemStack offHand = this.f_96541_.f_91074_.m_21206_();
        boolean isLeftHanded = this.f_96541_.f_91074_.m_5737_() == HumanoidArm.LEFT;
        boolean hasMain = !mainHand.m_41619_();
        boolean bl = hasOff = !offHand.m_41619_();
        if (hasMain && hasOff) {
            int mainX = isLeftHanded ? cx - 20 : cx + 4;
            int offX = isLeftHanded ? cx + 4 : cx - 20;
            this.hoveredMainHand = this.isPointInCircle(mouseX, mouseY, mainX + 8, cy, 20);
            this.hoveredOffHand = this.isPointInCircle(mouseX, mouseY, offX + 8, cy, 20);
        } else if (hasMain) {
            this.hoveredMainHand = this.isPointInCircle(mouseX, mouseY, cx, cy, 20);
        } else if (hasOff) {
            this.hoveredOffHand = this.isPointInCircle(mouseX, mouseY, cx, cy, 20);
        }
    }

    private boolean isPointInCircle(double px, double py, int cx, int cy, int radius) {
        double dx = px - (double)cx;
        double dy = py - (double)cy;
        return dx * dx + dy * dy <= (double)(radius * radius);
    }

    public void onKeyReleased() {
        if (this.hoveredIndex >= 0 && this.hoveredIndex < this.hotbarItems.size()) {
            int realSlot;
            ItemStack stack;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && !(stack = this.hotbarItems.get(this.hoveredIndex)).m_41619_() && (realSlot = this.findRealSlotIndex(stack)) >= 0) {
                mc.f_91074_.m_150109_().f_35977_ = realSlot;
            }
        }
        this.m_7379_();
    }

    private int findRealSlotIndex(ItemStack targetStack) {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return -1;
        }
        Inventory inv = this.f_96541_.f_91074_.m_150109_();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)targetStack)) continue;
            return i;
        }
        return -1;
    }

    private void selectOffhand(int slotIndex) {
        int realSlot;
        ItemStack stack;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91072_ != null && slotIndex >= 0 && slotIndex < this.hotbarItems.size() && !(stack = this.hotbarItems.get(slotIndex)).m_41619_() && (realSlot = this.findRealSlotIndex(stack)) >= 0) {
            int offhandSlot = 45;
            mc.f_91072_.m_171799_(mc.f_91074_.f_36095_.f_38840_, realSlot < 9 ? realSlot + 36 : realSlot, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            mc.f_91072_.m_171799_(mc.f_91074_.f_36095_.f_38840_, offhandSlot, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            mc.f_91072_.m_171799_(mc.f_91074_.f_36095_.f_38840_, realSlot < 9 ? realSlot + 36 : realSlot, 0, ClickType.PICKUP, (Player)mc.f_91074_);
        }
    }

    private void selectEmptySlot() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            Inventory inv = mc.f_91074_.m_150109_();
            for (int i = 0; i < 9; ++i) {
                if (!inv.m_8020_(i).m_41619_()) continue;
                mc.f_91074_.m_150109_().f_35977_ = i;
                this.m_7379_();
                return;
            }
        }
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(null);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredOffHand) {
            this.moveOffhandToHotbar();
            return true;
        }
        if (button == 0 && this.hoveredMainHand) {
            this.moveMainHandToHotbar();
            return true;
        }
        if (this.hoveredIndex >= 0 && this.hoveredIndex < this.hotbarItems.size()) {
            if (button == 0) {
                this.onKeyReleased();
                return true;
            }
            if (button == 1) {
                this.selectOffhand(this.hoveredIndex);
                this.m_7379_();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            float yawOffset;
            if (this.lastMouseX < 0.0) {
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                return;
            }
            double deltaX = mouseX - this.lastMouseX;
            double deltaY = mouseY - this.lastMouseY;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            double sensitivity = 0.15;
            float currentYaw = this.f_96541_.f_91074_.m_146908_();
            float currentPitch = this.f_96541_.f_91074_.m_146909_();
            float newYaw = currentYaw + (float)(deltaX * sensitivity);
            float newPitch = currentPitch + (float)(deltaY * sensitivity);
            float pitchOffset = newPitch - this.initialPitch;
            for (yawOffset = newYaw - this.initialYaw; yawOffset > 180.0f; yawOffset -= 360.0f) {
            }
            while (yawOffset < -180.0f) {
                yawOffset += 360.0f;
            }
            yawOffset = (float)Math.max(-45.0, Math.min(45.0, (double)yawOffset));
            pitchOffset = (float)Math.max(-30.0, Math.min(30.0, (double)pitchOffset));
            this.f_96541_.f_91074_.m_146922_(this.initialYaw + yawOffset);
            this.f_96541_.f_91074_.m_146926_(this.initialPitch + pitchOffset);
            this.f_96541_.f_91074_.m_146926_(Math.max(-90.0f, Math.min(90.0f, this.f_96541_.f_91074_.m_146909_())));
        }
        super.m_94757_(mouseX, mouseY);
    }

    private void moveOffhandToHotbar() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91072_ == null) {
            return;
        }
        Inventory inv = mc.f_91074_.m_150109_();
        ItemStack offhand = (ItemStack)inv.f_35976_.get(0);
        if (offhand.m_41619_()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            if (!inv.m_8020_(i).m_41619_()) continue;
            int offhandSlot = 45;
            int hotbarSlot = i + 36;
            mc.f_91072_.m_171799_(mc.f_91074_.f_36095_.f_38840_, offhandSlot, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            mc.f_91072_.m_171799_(mc.f_91074_.f_36095_.f_38840_, hotbarSlot, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            this.collectHotbarItems();
            return;
        }
    }

    private void moveMainHandToHotbar() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91072_ == null) {
            return;
        }
        int selectedSlot = mc.f_91074_.m_150109_().f_35977_;
        ItemStack mainHand = mc.f_91074_.m_21205_();
        if (mainHand.m_41619_()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            if (i == selectedSlot || !mc.f_91074_.m_150109_().m_8020_(i).m_41619_()) continue;
            int currentSlot = selectedSlot + 36;
            int targetSlot = i + 36;
            mc.f_91072_.m_171799_(mc.f_91074_.f_36095_.f_38840_, currentSlot, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            mc.f_91072_.m_171799_(mc.f_91074_.f_36095_.f_38840_, targetSlot, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            this.collectHotbarItems();
            return;
        }
    }

    private static final class RadialScreenMath {
        private RadialScreenMath() {
        }

        public static Radii computeRadii(int items) {
            try {
                int n = Math.max(1, items);
                double rOuter = 80.0;
                double rInner = Math.max(30.0, rOuter - 40.0);
                int deadzone = 20;
                return new Radii(rInner, rOuter, deadzone);
            }
            catch (Throwable t) {
                return new Radii(42.0, 72.0, 18);
            }
        }

        public static int pickSector(double mouseX, double mouseY, int cx, int cy, int sectors, Radii rr) {
            try {
                double step;
                int idx;
                if (sectors <= 0) {
                    return -1;
                }
                double dx = mouseX - (double)cx;
                double dy = mouseY - (double)cy;
                double dist2 = dx * dx + dy * dy;
                if (dist2 < (double)rr.deadzone() * (double)rr.deadzone()) {
                    return -1;
                }
                double ang = Math.atan2(dy, dx);
                if ((ang += 1.5707963267948966) < 0.0) {
                    ang += Math.PI * 2;
                }
                return (idx = (int)Math.floor(ang / (step = Math.PI * 2 / (double)sectors))) < 0 || idx >= sectors ? -1 : idx;
            }
            catch (Throwable t) {
                return -1;
            }
        }

        public record Radii(double inner, double outer, int deadzone) {
        }
    }

    private static final class RadialScreenDraw {
        private RadialScreenDraw() {
        }

        public static void drawRing(GuiGraphics g, Font font, int cx, int cy, List<ItemStack> items, int hoveredIdx, RadialScreenMath.Radii rr) {
            block8: {
                try {
                    if (items == null || items.isEmpty()) {
                        g.m_280509_(cx - 1, cy - 6, cx + 1, cy + 6, -1);
                        g.m_280509_(cx - 6, cy - 1, cx + 6, cy + 1, -1);
                        return;
                    }
                    int n = Math.max(1, items.size());
                    double step = Math.PI * 2 / (double)n;
                    for (int i = 0; i < n; ++i) {
                        double a0 = -1.5707963267948966 + (double)i * step;
                        double a1 = a0 + step;
                        int color = i == hoveredIdx ? 0x22FFFFFF : 0;
                        RadialScreenDraw.fillRingSector(g, cx, cy, rr.inner(), rr.outer(), a0, a1, color);
                    }
                    double rMidBase = (rr.inner() + rr.outer()) * 0.5;
                    for (int i = 0; i < n; ++i) {
                        ItemStack stack = items.get(i);
                        double ang = -1.5707963267948966 + ((double)i + 0.5) * step;
                        int ix = cx + (int)Math.round(Math.cos(ang) * rMidBase);
                        int iy = cy + (int)Math.round(Math.sin(ang) * rMidBase);
                        g.m_280480_(stack, ix - 8, iy - 8);
                    }
                    if (hoveredIdx < 0 || hoveredIdx >= items.size()) break block8;
                    try {
                        ItemStack stack = items.get(hoveredIdx);
                        if (!stack.m_41619_()) {
                            Component comp = stack.m_41786_();
                            int tw = font.m_92852_((FormattedText)comp);
                            int textY = cy - (int)rr.outer() - 15;
                            g.m_280614_(font, comp, cx - tw / 2, textY, -1, true);
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private static void fillRingSector(GuiGraphics g, int cx, int cy, double rInner, double rOuter, double a0, double a1, int argb) {
            try {
                if (a1 <= a0) {
                    return;
                }
                int segs = Math.max(12, (int)Math.ceil((a1 - a0) * 48.0));
                float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
                float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
                float gn = (float)(argb >>> 8 & 0xFF) / 255.0f;
                float b = (float)(argb & 0xFF) / 255.0f;
                Matrix4f pose = g.m_280168_().m_85850_().m_252922_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::m_172811_);
                BufferBuilder buf = Tesselator.m_85913_().m_85915_();
                buf.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
                for (int i = 0; i <= segs; ++i) {
                    double t = (double)i / (double)segs;
                    double ang = a0 + (a1 - a0) * t;
                    float cos = (float)Math.cos(ang);
                    float sin = (float)Math.sin(ang);
                    float xOuter = (float)((double)cx + (double)cos * rOuter);
                    float yOuter = (float)((double)cy + (double)sin * rOuter);
                    float xInner = (float)((double)cx + (double)cos * rInner);
                    float yInner = (float)((double)cy + (double)sin * rInner);
                    buf.m_252986_(pose, xOuter, yOuter, 0.0f).m_85950_(r, gn, b, a).m_5752_();
                    buf.m_252986_(pose, xInner, yInner, 0.0f).m_85950_(r, gn, b, a).m_5752_();
                }
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
                RenderSystem.disableBlend();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

