/*
 * Decompiled with CFR 0.152.
 */
package dev.radialhotbar;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import dev.radialhotbar.RadialMenuScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="radialhotbar")
public class Radialhotbar {
    public static final String MODID = "radialhotbar";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final long CLOSE_DELAY_MS = 200L;
    public static KeyMapping RADIAL_KEY;
    private static boolean isButtonPressed;
    private static long releaseTime;
    private static boolean waitingToClose;

    public Radialhotbar() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("Radial Hotbar initialized!");
    }

    private void registerKeys(RegisterKeyMappingsEvent event) {
        RADIAL_KEY = new KeyMapping("key.radialhotbar.open", InputConstants.Type.MOUSE, 2, "key.categories.inventory");
        event.register(RADIAL_KEY);
    }

    static {
        isButtonPressed = false;
        releaseTime = 0L;
        waitingToClose = false;
    }

    @Mod.EventBusSubscriber(modid="radialhotbar", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void onRenderCrosshair(RenderGuiOverlayEvent.Pre event) {
            if (Minecraft.m_91087_().f_91080_ instanceof RadialMenuScreen && event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onRenderHotbar(RenderGuiOverlayEvent.Pre event) {
            if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onMouseMove(InputEvent.MouseScrollingEvent event) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof RadialMenuScreen) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onMouseInput(InputEvent.MouseButton.Pre event) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            if (event.getButton() == 2) {
                boolean released;
                boolean pressed = event.getAction() == 1;
                boolean bl = released = event.getAction() == 0;
                if (pressed && !isButtonPressed) {
                    if (mc.f_91080_ == null) {
                        mc.m_91152_((Screen)new RadialMenuScreen());
                    }
                    waitingToClose = false;
                    releaseTime = 0L;
                    isButtonPressed = true;
                    event.setCanceled(true);
                } else if (released && isButtonPressed) {
                    if (mc.f_91080_ instanceof RadialMenuScreen) {
                        waitingToClose = true;
                        releaseTime = System.currentTimeMillis();
                    }
                    isButtonPressed = false;
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            long elapsed;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            if (waitingToClose && !isButtonPressed && (elapsed = System.currentTimeMillis() - releaseTime) >= 200L) {
                Screen screen = mc.f_91080_;
                if (screen instanceof RadialMenuScreen) {
                    RadialMenuScreen radialScreen = (RadialMenuScreen)screen;
                    radialScreen.onKeyReleased();
                }
                waitingToClose = false;
            }
        }
    }
}

