/*
 * Decompiled with CFR 0.152.
 */
package com.cutexxgirl.takeit.events;

import com.cutexxgirl.takeit.TakeItConfig;
import com.cutexxgirl.takeit.network.PacketClickPickup;
import com.cutexxgirl.takeit.network.PacketHandler;
import com.cutexxgirl.takeit.network.PacketPickup;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="takeit", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    public static final KeyMapping PICKUP_KEY = new KeyMapping("key.takeit.pickup", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 71, "key.categories.takeit");

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(PICKUP_KEY);
    }

    @Mod.EventBusSubscriber(modid="takeit", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        private static boolean wasRightClickPressed = false;

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (PICKUP_KEY.m_90859_() && ((Boolean)TakeItConfig.ENABLE_MOD.get()).booleanValue() && Minecraft.m_91087_().f_91080_ == null) {
                PacketHandler.INSTANCE.sendToServer((Object)new PacketPickup());
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            EntityHitResult entityHit;
            HitResult hit;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (!((Boolean)TakeItConfig.ENABLE_MOD.get()).booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null || mc.f_91080_ != null) {
                return;
            }
            boolean isRightClickPressed = mc.f_91066_.f_92095_.m_90857_();
            if (isRightClickPressed && !wasRightClickPressed && (hit = ForgeEvents.pick((Player)mc.f_91074_, 20.0f)) != null && hit.m_6662_() == HitResult.Type.ENTITY && (entityHit = (EntityHitResult)hit).m_82443_() instanceof ItemEntity) {
                PacketHandler.INSTANCE.sendToServer((Object)new PacketClickPickup(entityHit.m_82443_().m_19879_()));
                LogUtils.getLogger().info("TakeIt: Sent click pickup packet for entity ID: {}", (Object)entityHit.m_82443_().m_19879_());
            }
            wasRightClickPressed = isRightClickPressed;
        }

        private static HitResult pick(Player player, float partialTicks) {
            double reach = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
            if (reach == 0.0) {
                reach = 4.5;
            }
            Vec3 eyePos = player.m_20299_(partialTicks);
            Vec3 viewVec = player.m_20252_(partialTicks);
            Vec3 endPos = eyePos.m_82520_(viewVec.f_82479_ * reach, viewVec.f_82480_ * reach, viewVec.f_82481_ * reach);
            AABB searchBox = player.m_20191_().m_82369_(viewVec.m_82490_(reach)).m_82377_(1.0, 1.0, 1.0);
            return ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePos, (Vec3)endPos, (AABB)searchBox, entity -> entity instanceof ItemEntity, (double)(reach * reach));
        }
    }
}

