/*
 * Decompiled with CFR 0.152.
 */
package com.cutexxgirl.takeit.network;

import com.cutexxgirl.takeit.TakeItConfig;
import com.cutexxgirl.takeit.events.CommonEvents;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketClickPickup {
    private final int entityId;

    public PacketClickPickup(int entityId) {
        this.entityId = entityId;
    }

    public PacketClickPickup(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public static PacketClickPickup decode(FriendlyByteBuf buf) {
        return new PacketClickPickup(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null && ((Boolean)TakeItConfig.ENABLE_MOD.get()).booleanValue()) {
                LogUtils.getLogger().info("TakeIt: Server received click pickup packet for entity ID: {}", (Object)this.entityId);
                Entity target = player.m_9236_().m_6815_(this.entityId);
                LogUtils.getLogger().info("TakeIt: Found entity: {}", (Object)target);
                if (target instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)target;
                    double distSq = player.m_20280_((Entity)itemEntity);
                    LogUtils.getLogger().info("TakeIt: Distance squared: {}", (Object)distSq);
                    if (distSq < 36.0) {
                        CommonEvents.isManualPickup.set(true);
                        try {
                            itemEntity.m_32010_(0);
                            itemEntity.m_6123_((Player)player);
                            LogUtils.getLogger().info("TakeIt: Successfully triggered playerTouch");
                        }
                        catch (Exception e) {
                            LogUtils.getLogger().error("TakeIt: Error during pickup", (Throwable)e);
                            e.printStackTrace();
                        }
                        finally {
                            CommonEvents.isManualPickup.set(false);
                        }
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

