/*
 * Decompiled with CFR 0.152.
 */
package com.king_tajin.block_explosion_damage;

import com.king_tajin.block_explosion_damage.BlockDamageData;
import com.king_tajin.block_explosion_damage.BlockDamageManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockDamageEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            this.clearBlockDamage(serverLevel, pos);
        }
    }

    private void clearBlockDamage(ServerLevel level, BlockPos pos) {
        BlockDamageData damageData = BlockDamageManager.getDamageData(level, pos);
        if (damageData.damage() > 0) {
            BlockDamageManager.removeDamage(level, pos);
            level.destroyBlockProgress(-1 - pos.hashCode(), pos, -1);
        }
    }
}

