/*
 * Decompiled with CFR 0.152.
 */
package com.king_tajin.block_explosion_damage;

import com.king_tajin.block_explosion_damage.BlockDamageData;
import com.king_tajin.block_explosion_damage.config.ModConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;

public class ChunkDamageData {
    public static final MapCodec<ChunkDamageData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockDamageData.CODEC.listOf().optionalFieldOf("damages", List.of()).forGetter(data -> data.damageMap.entrySet().stream().map(entry -> new BlockDamageData((BlockPos)entry.getKey(), ((BlockDamageData)entry.getValue()).damage(), ((BlockDamageData)entry.getValue()).lastDamageTime())).collect(Collectors.toList()))).apply((Applicative)instance, ChunkDamageData::new));
    private final Map<BlockPos, BlockDamageData> damageMap = new HashMap<BlockPos, BlockDamageData>();

    public ChunkDamageData() {
    }

    private ChunkDamageData(List<BlockDamageData> damages) {
        for (BlockDamageData damage : damages) {
            this.damageMap.put(damage.pos(), damage);
        }
    }

    public BlockDamageData getDamage(BlockPos pos) {
        BlockDamageData data = this.damageMap.get(pos);
        return data != null ? data : new BlockDamageData(0, 0L);
    }

    public void setDamage(BlockPos pos, int damage, long time) {
        this.damageMap.put(pos.immutable(), new BlockDamageData(pos.immutable(), damage, time));
    }

    public void removeDamage(BlockPos pos) {
        this.damageMap.remove(pos);
    }

    public boolean isEmpty() {
        return this.damageMap.isEmpty();
    }

    public void refreshVisuals(ServerLevel level) {
        for (Map.Entry<BlockPos, BlockDamageData> entry : this.damageMap.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockDamageData data = entry.getValue();
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) continue;
            int maxDamage = ModConfig.getHitsForBlock(state.getBlock());
            int damageStage = Math.min(9, (int)((float)data.damage() / (float)maxDamage * 10.0f));
            level.destroyBlockProgress(-1 - pos.hashCode(), pos, damageStage);
        }
    }

    public int clearAllDamage(ServerLevel level) {
        int count = this.damageMap.size();
        for (BlockPos pos : this.damageMap.keySet()) {
            level.destroyBlockProgress(-1 - pos.hashCode(), pos, -1);
        }
        this.damageMap.clear();
        return count;
    }

    public boolean processDecay(ServerLevel level, long currentTime, int decayTime) {
        Iterator<Map.Entry<BlockPos, BlockDamageData>> iterator = this.damageMap.entrySet().iterator();
        boolean modified = false;
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, BlockDamageData> entry = iterator.next();
            BlockPos pos = entry.getKey();
            BlockDamageData data = entry.getValue();
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) {
                iterator.remove();
                level.destroyBlockProgress(-1 - pos.hashCode(), pos, -1);
                modified = true;
                continue;
            }
            long timeSinceDamage = currentTime - data.lastDamageTime();
            if (timeSinceDamage < (long)decayTime) continue;
            int newDamage = data.damage() - 1;
            if (newDamage <= 0) {
                iterator.remove();
                level.destroyBlockProgress(-1 - pos.hashCode(), pos, -1);
            } else {
                entry.setValue(new BlockDamageData(pos, newDamage, currentTime));
                int maxDamage = ModConfig.getHitsForBlock(state.getBlock());
                int damageStage = Math.min(9, (int)((float)newDamage / (float)maxDamage * 10.0f));
                level.destroyBlockProgress(-1 - pos.hashCode(), pos, damageStage);
            }
            modified = true;
        }
        return modified;
    }
}

