/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cyberneticsystem_neoforge.network;

import java.util.function.Supplier;
import net.mcreator.cyberneticsystem_neoforge.CyberneticSystemMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class CyberneticSystemModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"cybernetic_system");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CyberneticSystemMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(CyberneticSystemModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(CyberneticSystemModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.dna_point = original.dna_point;
        clone.Gens_Body = original.Gens_Body;
        clone.Gens_Armor = original.Gens_Armor;
        clone.Gens_DNA = original.Gens_DNA;
        clone.Gens_Adrenalin = original.Gens_Adrenalin;
        clone.Gens_Swim = original.Gens_Swim;
        clone.Cybernation = original.Cybernation;
        clone.augme_ah = original.augme_ah;
        clone.augme_bs = original.augme_bs;
        clone.augme_bm = original.augme_bm;
        clone.augme_bmm = original.augme_bmm;
        clone.augme_be = original.augme_be;
        clone.Battery = original.Battery;
        clone.cd_battery = original.cd_battery;
        clone.changer_battery = original.changer_battery;
        clone.ChipBlue = original.ChipBlue;
        clone.ChipRed = original.ChipRed;
        clone.ChipGreen = original.ChipGreen;
        clone.ChipYellow = original.ChipYellow;
        clone.regen_rc = original.regen_rc;
        clone.hyper_changer = original.hyper_changer;
        clone.Cyborg_teleport = original.Cyborg_teleport;
        clone.Cyborg_electro_shield = original.Cyborg_electro_shield;
        clone.Cyborg_jump_boost = original.Cyborg_jump_boost;
        clone.CD_ability_cyborg = original.CD_ability_cyborg;
        if (!event.isWasDeath()) {
            // empty if block
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cybernetic_system", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public double dna_point = 0.0;
        public double Gens_Body = 0.0;
        public double Gens_Armor = 0.0;
        public double Gens_DNA = 0.0;
        public double Gens_Adrenalin = 0.0;
        public double Gens_Swim = 0.0;
        public boolean Cybernation = false;
        public boolean augme_ah = false;
        public boolean augme_bs = false;
        public boolean augme_bm = false;
        public boolean augme_bmm = false;
        public boolean augme_be = false;
        public double Battery = 0.0;
        public double cd_battery = 0.0;
        public double changer_battery = 0.0;
        public double ChipBlue = 0.0;
        public double ChipRed = 0.0;
        public double ChipGreen = 0.0;
        public double ChipYellow = 0.0;
        public double regen_rc = 0.0;
        public double hyper_changer = 0.0;
        public boolean Cyborg_teleport = false;
        public boolean Cyborg_electro_shield = false;
        public boolean Cyborg_jump_boost = false;
        public double CD_ability_cyborg = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("dna_point", this.dna_point);
            nbt.putDouble("Gens_Body", this.Gens_Body);
            nbt.putDouble("Gens_Armor", this.Gens_Armor);
            nbt.putDouble("Gens_DNA", this.Gens_DNA);
            nbt.putDouble("Gens_Adrenalin", this.Gens_Adrenalin);
            nbt.putDouble("Gens_Swim", this.Gens_Swim);
            nbt.putBoolean("Cybernation", this.Cybernation);
            nbt.putBoolean("augme_ah", this.augme_ah);
            nbt.putBoolean("augme_bs", this.augme_bs);
            nbt.putBoolean("augme_bm", this.augme_bm);
            nbt.putBoolean("augme_bmm", this.augme_bmm);
            nbt.putBoolean("augme_be", this.augme_be);
            nbt.putDouble("Battery", this.Battery);
            nbt.putDouble("cd_battery", this.cd_battery);
            nbt.putDouble("changer_battery", this.changer_battery);
            nbt.putDouble("ChipBlue", this.ChipBlue);
            nbt.putDouble("ChipRed", this.ChipRed);
            nbt.putDouble("ChipGreen", this.ChipGreen);
            nbt.putDouble("ChipYellow", this.ChipYellow);
            nbt.putDouble("regen_rc", this.regen_rc);
            nbt.putDouble("hyper_changer", this.hyper_changer);
            nbt.putBoolean("Cyborg_teleport", this.Cyborg_teleport);
            nbt.putBoolean("Cyborg_electro_shield", this.Cyborg_electro_shield);
            nbt.putBoolean("Cyborg_jump_boost", this.Cyborg_jump_boost);
            nbt.putDouble("CD_ability_cyborg", this.CD_ability_cyborg);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.dna_point = nbt.getDouble("dna_point");
            this.Gens_Body = nbt.getDouble("Gens_Body");
            this.Gens_Armor = nbt.getDouble("Gens_Armor");
            this.Gens_DNA = nbt.getDouble("Gens_DNA");
            this.Gens_Adrenalin = nbt.getDouble("Gens_Adrenalin");
            this.Gens_Swim = nbt.getDouble("Gens_Swim");
            this.Cybernation = nbt.getBoolean("Cybernation");
            this.augme_ah = nbt.getBoolean("augme_ah");
            this.augme_bs = nbt.getBoolean("augme_bs");
            this.augme_bm = nbt.getBoolean("augme_bm");
            this.augme_bmm = nbt.getBoolean("augme_bmm");
            this.augme_be = nbt.getBoolean("augme_be");
            this.Battery = nbt.getDouble("Battery");
            this.cd_battery = nbt.getDouble("cd_battery");
            this.changer_battery = nbt.getDouble("changer_battery");
            this.ChipBlue = nbt.getDouble("ChipBlue");
            this.ChipRed = nbt.getDouble("ChipRed");
            this.ChipGreen = nbt.getDouble("ChipGreen");
            this.ChipYellow = nbt.getDouble("ChipYellow");
            this.regen_rc = nbt.getDouble("regen_rc");
            this.hyper_changer = nbt.getDouble("hyper_changer");
            this.Cyborg_teleport = nbt.getBoolean("Cyborg_teleport");
            this.Cyborg_electro_shield = nbt.getBoolean("Cyborg_electro_shield");
            this.Cyborg_jump_boost = nbt.getBoolean("Cyborg_jump_boost");
            this.CD_ability_cyborg = nbt.getDouble("CD_ability_cyborg");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }
}

