/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cyberneticsystem_neoforge.network;

import net.mcreator.cyberneticsystem_neoforge.CyberneticSystemMod;
import net.mcreator.cyberneticsystem_neoforge.procedures.ProDeleteChipGreenProcedure;
import net.mcreator.cyberneticsystem_neoforge.procedures.ProOpenGUIChipProcedure;
import net.mcreator.cyberneticsystem_neoforge.procedures.ProSetupGreenChip1Procedure;
import net.mcreator.cyberneticsystem_neoforge.procedures.ProSetupGreenChip2Procedure;
import net.mcreator.cyberneticsystem_neoforge.procedures.ProSetupGreenChip3Procedure;
import net.mcreator.cyberneticsystem_neoforge.procedures.ProSetupGreenChip4Procedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record GUIChipGreenButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GUIChipGreenButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cybernetic_system", (String)"gui_chip_green_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GUIChipGreenButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new GUIChipGreenButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<GUIChipGreenButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(GUIChipGreenButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> GUIChipGreenButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProOpenGUIChipProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ProDeleteChipGreenProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ProSetupGreenChip1Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ProSetupGreenChip2Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ProSetupGreenChip3Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProSetupGreenChip4Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CyberneticSystemMod.addNetworkMessage(TYPE, STREAM_CODEC, GUIChipGreenButtonMessage::handleData);
    }
}

