/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.vulnerablevillages;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AntiCreeperChargeGoal
extends Goal {
    private final Mob guard;
    private Creeper target = null;
    private int inactiveTicks = 0;
    private static final int TIMEOUT = 600;
    private static final double RANGE = 16.0;
    private static final double ATTACK_RANGE = 1.6;

    public AntiCreeperChargeGoal(Mob guard) {
        this.guard = guard;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.findNewTarget() != null;
    }

    public boolean m_8045_() {
        if (this.inactiveTicks > 600) {
            return false;
        }
        return this.target != null && this.target.m_6084_() && (double)this.guard.m_20270_((Entity)this.target) <= 16.0;
    }

    public void m_8056_() {
        this.target = this.findNewTarget();
        this.inactiveTicks = 0;
    }

    public void m_8041_() {
        this.guard.m_21573_().m_26573_();
        this.target = null;
    }

    public void m_8037_() {
        ++this.inactiveTicks;
        if (this.target == null || !this.target.m_6084_()) {
            this.target = this.findNewTarget();
            return;
        }
        if (!AntiCreeperChargeGoal.isHoldingMelee(this.guard)) {
            return;
        }
        this.guard.m_21573_().m_5624_((Entity)this.target, 1.2);
        this.guard.m_21563_().m_148051_((Entity)this.target);
        double dist = this.guard.m_20270_((Entity)this.target);
        if (dist <= 1.6) {
            float damage = 8.0f + EnchantmentHelper.m_44833_((ItemStack)this.guard.m_21205_(), (MobType)this.target.m_6336_());
            this.target.m_6469_(this.guard.m_269291_().m_269333_((LivingEntity)this.guard), damage);
            this.guard.m_21011_(this.guard.m_7655_(), false);
            this.inactiveTicks = 0;
        }
    }

    private Creeper findNewTarget() {
        if (this.guard.m_9236_().m_5776_()) {
            return null;
        }
        List list = this.guard.m_9236_().m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)this.guard.m_20182_(), (double)16.0, (double)16.0, (double)16.0), e -> {
            Creeper creeper;
            return e instanceof Creeper && (creeper = (Creeper)e).m_6084_() && this.guard.m_142582_((Entity)creeper) && AntiCreeperChargeGoal.isHoldingMelee(this.guard);
        });
        return list.isEmpty() ? null : (Creeper)list.get(0);
    }

    private static boolean isHoldingMelee(Mob mob) {
        ItemStack stack = mob.m_21205_();
        return !(stack.m_41720_() instanceof BowItem) && !(stack.m_41720_() instanceof CrossbowItem);
    }
}

