/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.hunger;

import io.github.orlouge.unruffled.Packets;
import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.config.Config;
import io.github.orlouge.unruffled.interfaces.ExtendedHungerManager;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1928;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1702.class}, priority=1)
public abstract class HungerManagerMixin
implements ExtendedHungerManager {
    @Shadow
    private int field_7756;
    @Shadow
    private int field_7755;
    @Shadow
    private float field_7753;
    @Shadow
    private float field_7752;
    private int inventoryWeightTimer = 100;
    private float inventoryWeight = 1.0f;
    private float stamina = 1.0f;
    private float lastStamina = 0.0f;
    private float lastStaminaRegeneration = 1.0f;
    private float baseWeariness = 0.0f;
    private float amortizedWeariness = 0.0f;
    private float foodToConsume = 0.0f;
    private float foodCooldown = 0.0f;
    private class_243 averagePos = null;
    private class_2874 dimensionType = null;
    private boolean isUnderground = false;
    private boolean isNight = false;
    private float health = 20.0f;

    @Shadow
    public abstract void method_7585(int var1, float var2);

    /*
     * Unable to fully structure code
     */
    @Inject(method={"update"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUpdate(class_3222 player, CallbackInfo ci) {
        playerPos = player.method_73189();
        if (player.method_5854() == null) ** GOTO lbl-1000
        v0 = new class_243(player.method_18798().method_10216(), 0.0, player.method_18798().method_10215());
        if (v0.method_1033() < 0.009999999776482582) {
            this.baseWeariness *= ((Config)Config.INSTANCE.method_15332()).hungerConfig.wearinessDecreaseFactorOnStillEntities();
        } else lbl-1000:
        // 2 sources

        {
            this.baseWeariness *= ((Config)Config.INSTANCE.method_15332()).hungerConfig.wearinessDecreaseFactor();
        }
        currentDimension = player.method_51469().method_8597();
        if (currentDimension != this.dimensionType) {
            this.averagePos = playerPos;
        }
        this.dimensionType = currentDimension;
        this.health = player.method_6032();
        this.isNight = player.method_51469().method_23886();
        this.isUnderground = player.method_73189().method_10214() < (double)player.method_51469().method_8615() * 0.9 || player.method_5869() != false;
        targetWeariness = this.getTargetWeariness();
        this.amortizedWeariness = Math.min(1.0f, 0.997f * this.amortizedWeariness + 0.003f * targetWeariness);
        this.foodCooldown = Math.max(0.0f, this.foodCooldown - 0.001f);
        travelAmount = new class_243(0.0, 0.0, 0.0);
        if (this.averagePos == null) {
            this.averagePos = playerPos;
        } else {
            travelAmount = playerPos.method_1020(this.averagePos);
            this.averagePos = playerPos.method_1021(2.0E-4).method_1019(this.averagePos.method_1021(0.9998));
        }
        if (this.inventoryWeightTimer++ >= 50) {
            weight = this.calculateWeight((class_1657)player);
            this.inventoryWeight = ((Float)weight.method_15442()).floatValue();
            this.inventoryWeightTimer = 0;
            if ((double)this.inventoryWeight > 1.5 && player instanceof class_3222) {
                serverPlayer = player;
                UnruffledMod.HEAVY_INVENTORY_CRITERION.trigger(serverPlayer);
                if (((Float)weight.method_15441()).floatValue() > 0.3f) {
                    UnruffledMod.HEAVY_ENDER_CHEST_CRITERION.trigger(serverPlayer);
                }
            }
        }
        if (player.method_6059(class_1294.field_5903)) {
            hungerExhaustion = (float)player.method_6112(class_1294.field_5903).method_5578() * 0.005f;
            if (this.stamina > Math.max(this.minStaminaToAttack((class_1657)player), this.getStaminaRegenerationRate(1.0f) * 2.0f)) {
                exhaustionFraction = hungerExhaustion * this.stamina;
                this.stamina = Math.max(0.0f, this.stamina - exhaustionFraction * this.getStaminaDepletionRate());
                hungerExhaustion -= exhaustionFraction;
            }
            this.foodToConsume += hungerExhaustion;
            this.field_7752 -= hungerExhaustion;
        }
        staminaHungerMultiplier = this.getStaminaHungerMultiplier(travelAmount);
        this.foodToConsume += 1.0E-4f * Math.max(0.0f, staminaHungerMultiplier - 0.3f);
        if (this.field_7752 > 0.0f) {
            consumedStamina = this.field_7752 * this.getStaminaDepletionRate();
            this.foodToConsume += ((Config)Config.INSTANCE.method_15332()).hungerConfig.hungerDepletionRate() * Math.max(0.0f, consumedStamina - this.stamina) / this.getStaminaDepletionRate();
            this.field_7752 = 0.0f;
            this.stamina = Math.max(0.0f, this.stamina - consumedStamina);
            this.addWeariness(Math.min(0.15f, consumedStamina) * (((Config)Config.INSTANCE.method_15332()).hungerConfig.wearinessIncreaseFactor() * (0.1f + this.amortizedWeariness)));
        }
        if (this.field_7756 <= 0 && ((Config)Config.INSTANCE.method_15332()).hungerConfig.starvationRate().orElse(Float.valueOf(0.0f)).floatValue() > 0.0f) {
            ++this.field_7755;
            if (this.field_7755 >= (int)(80.0f / ((Config)Config.INSTANCE.method_15332()).hungerConfig.starvationRate().orElse(Float.valueOf(0.0f)).floatValue())) {
                difficulty = player.method_51469().method_8407();
                if (player.method_6032() > 10.0f || difficulty == class_1267.field_5807 || player.method_6032() > 1.0f && difficulty == class_1267.field_5802) {
                    player.method_64397(player.method_51469(), player.method_48923().method_48825(), 1.0f);
                }
                this.field_7755 = 0;
            }
        } else if ((double)this.stamina > 0.05 && player.method_6032() < player.method_6063() && player.method_51469().method_64395().method_8355(class_1928.field_19395)) {
            ++this.field_7755;
            if ((double)this.field_7755 >= 200.0 / Math.min((double)this.stamina, 0.4)) {
                player.method_6025(1.0f);
                this.field_7755 = 0;
            }
        }
        staminaRegeneration = this.getStaminaRegenerationRate(this.amortizedWeariness);
        if (player.method_6059(class_1294.field_5904)) {
            staminaRegeneration *= 1.5f + 0.5f * (float)player.method_6112(class_1294.field_5904).method_5578();
        }
        if (player.method_6059(class_1294.field_5909)) {
            staminaRegeneration = Math.max(this.getStaminaRegenerationRate(1.0f), staminaRegeneration / (1.5f + 0.5f * (float)player.method_6112(class_1294.field_5909).method_5578()));
        }
        if (this.stamina < 1.0f) {
            restoredStamina = Math.min(1.0f, this.stamina + staminaRegeneration);
            consumedFood = (restoredStamina - this.stamina) * staminaHungerMultiplier / (4.0f * this.getStaminaDepletionRate());
            this.stamina = restoredStamina;
            if (this.field_7753 > 0.0f) {
                this.field_7753 = Math.max(this.field_7753 - consumedFood, 0.0f);
            } else {
                this.foodToConsume += consumedFood;
            }
        }
        if (this.foodToConsume > 1.0f) {
            this.field_7756 = Math.max(this.field_7756 - (int)this.foodToConsume, 0);
            this.foodToConsume = Math.max(0.0f, this.foodToConsume - (float)((int)this.foodToConsume));
        }
        if ((this.stamina != this.lastStamina || Math.abs(staminaRegeneration - this.lastStaminaRegeneration) > 1.0E-4f) && player instanceof class_3222) {
            serverPlayer = player;
            new Packets.ExtendedHungerUpdate(this.stamina, staminaRegeneration / ((Config)Config.INSTANCE.method_15332()).hungerConfig.staminaRegenerationRate(), (staminaHungerMultiplier - 0.2f) / 3.8f).sendToPlayer(serverPlayer);
            this.lastStamina = this.stamina;
            this.lastStaminaRegeneration = staminaRegeneration;
        }
        ci.cancel();
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;addInternal(IF)V"))
    public void addFoodWithCooldown(class_1702 instance, int food, float saturationModifier) {
        food = Math.round((float)food * (1.0f - this.foodCooldown));
        this.method_7585(food, Math.round(saturationModifier * (1.0f - this.foodCooldown)));
        if (food > 0) {
            this.foodCooldown = Math.min(0.9f, this.foodCooldown + ((Config)Config.INSTANCE.method_15332()).hungerConfig.eatCooldownFactor());
        }
    }

    @Inject(method={"writeData"}, at={@At(value="RETURN")})
    public void onWriteNbt(class_11372 nbt, CallbackInfo ci) {
        nbt.method_71464("stamina", this.stamina);
        nbt.method_71464("baseWeariness", this.baseWeariness);
        nbt.method_71464("amortizedWeariness", this.amortizedWeariness);
    }

    @Inject(method={"readData"}, at={@At(value="RETURN")})
    public void onReadNbt(class_11368 nbt, CallbackInfo ci) {
        this.stamina = nbt.method_71423("stamina", 1.0f);
        this.baseWeariness = nbt.method_71423("baseWeariness", 0.0f);
        this.amortizedWeariness = nbt.method_71423("amortizedWeariness", 0.0f);
    }

    @Override
    public float getStamina() {
        return this.stamina;
    }

    @Override
    public float getWeight() {
        return this.inventoryWeight;
    }

    @Override
    public void addStamina(float diff) {
        this.stamina = Math.max(0.0f, Math.min(1.0f, this.stamina + diff));
    }

    @Override
    public class_2874 getDimension() {
        return this.dimensionType;
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public float getFoodLevel() {
        return this.field_7756;
    }

    @Override
    public float getBaseWeariness() {
        return this.baseWeariness;
    }

    @Override
    public float getAmortizedWeariness() {
        return this.amortizedWeariness;
    }

    @Override
    public void addWeariness(float diff) {
        this.baseWeariness = Math.max(0.0f, Math.min(1.0f, this.baseWeariness + diff));
    }

    @Override
    public void resetWeariness() {
        this.baseWeariness = 0.0f;
        this.amortizedWeariness = 0.0f;
    }

    @Override
    public boolean isNight() {
        return this.isNight;
    }

    @Override
    public boolean isUnderground() {
        return this.isUnderground;
    }
}

