/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.trading;

import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.config.Config;
import io.github.orlouge.unruffled.config.Trades;
import io.github.orlouge.unruffled.interfaces.NearbyPlayersTracker;
import io.github.orlouge.unruffled.interfaces.WanderingTraderManagerTracker;
import io.github.orlouge.unruffled.utils.TradedCompasses;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3853;
import net.minecraft.class_3988;
import net.minecraft.class_3989;
import net.minecraft.class_3990;
import net.minecraft.class_5268;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3989.class})
public abstract class WanderingTraderEntityMixin
extends class_3988
implements WanderingTraderManagerTracker,
NearbyPlayersTracker {
    private int unruffled_spawnChanceDiff = 0;
    private float unruffled_spawnChanceIncrease = 0.0f;
    private class_3990 unruffled_wanderingTraderManager = null;
    public List<? extends class_1657> unruffled_nearbyPlayers = null;

    public WanderingTraderEntityMixin(class_1299<? extends class_3988> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"afterUsing"}, at={@At(value="HEAD")})
    public void increaseSpawnChangeAfterTrading(class_1914 offer, CallbackInfo ci) {
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_1799 buyItem;
            class_3218 world = (class_3218)class_19372;
            if (this.unruffled_spawnChanceDiff < 30 && this.unruffled_wanderingTraderManager != null) {
                class_5268 properties = world.method_8503().method_27728().method_27859();
                this.unruffled_spawnChanceIncrease += (float)offer.method_19279() * 0.8f;
                if (this.unruffled_spawnChanceIncrease >= 1.0f) {
                    int diff = (int)this.unruffled_spawnChanceIncrease;
                    this.unruffled_spawnChanceIncrease -= (float)diff;
                    this.unruffled_spawnChanceDiff += diff;
                    this.unruffled_wanderingTraderManager.field_17730 = Math.min(99, properties.method_18039() + diff);
                    properties.method_18042(this.unruffled_wanderingTraderManager.field_17730);
                }
            }
            if ((buyItem = offer.method_8246()).method_31574(class_1802.field_8251)) {
                TradedCompasses.get(world.method_17983()).addSell(buyItem, this.method_8257(), this.unruffled_nearbyPlayers);
            }
        }
    }

    public void method_6078(class_1282 damageSource) {
        class_1937 class_19372;
        super.method_6078(damageSource);
        if (damageSource.method_5529() instanceof class_1657 && (class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (this.unruffled_wanderingTraderManager != null) {
                class_5268 properties = world.method_8503().method_27728().method_27859();
                this.unruffled_wanderingTraderManager.field_17730 = 1 + this.unruffled_spawnChanceDiff;
                properties.method_18042(this.unruffled_wanderingTraderManager.field_17730);
                this.unruffled_wanderingTraderManager.field_17729 = 96000 - this.unruffled_spawnChanceDiff * 1200;
                properties.method_18041(this.unruffled_wanderingTraderManager.field_17729);
                class_1297 class_12972 = damageSource.method_5529();
                if (class_12972 instanceof class_3222) {
                    class_3222 player = (class_3222)class_12972;
                    UnruffledMod.KILL_WANDERING_TRADER_CRITERION.trigger(player);
                }
            }
        }
    }

    @Inject(method={"fillRecipes"}, at={@At(value="HEAD")}, cancellable=true)
    public void addOffersOnFill(CallbackInfo ci) {
        if (this.field_17721 != null) {
            ((Config)Config.INSTANCE.method_15332()).tradesConfig.wanderingTraderTrades().ifPresent(trades -> {
                if (trades.enabled().orElse(true).booleanValue()) {
                    for (Trades.ConfiguredWanderingTraderPool pool : trades.pools()) {
                        this.method_19170(this.field_17721, (class_3853.class_1652[])Arrays.stream(pool.trades()).map(configuredTrade -> configuredTrade.toFactory(this.method_73183().method_30349())).toArray(class_3853.class_1652[]::new), pool.count());
                    }
                }
            });
        }
        if (!((Config)Config.INSTANCE.method_15332()).tradesConfig.wanderingTraderTrades().flatMap(Trades.ConfiguredWanderingTraderTrades::addVanilla).orElse(true).booleanValue()) {
            ci.cancel();
        }
        boolean ignoreBuy = ((Config)Config.INSTANCE.method_15332()).tradesConfig.wanderingTraderTrades().flatMap(Trades.ConfiguredWanderingTraderTrades::addVanillaIgnoreBuy).orElse(true);
        boolean ignoreSellEnchanted = ((Config)Config.INSTANCE.method_15332()).tradesConfig.wanderingTraderTrades().flatMap(Trades.ConfiguredWanderingTraderTrades::addVanillaIgnoreSellEnchanted).orElse(true);
        if (ignoreBuy || ignoreSellEnchanted) {
            class_1916 tradeOfferList = this.method_8264();
            for (Pair pair : class_3853.field_17724) {
                class_3853.class_1652[] factories = (class_3853.class_1652[])Arrays.stream((class_3853.class_1652[])pair.getLeft()).filter(f -> !(ignoreBuy && f instanceof class_3853.class_4161 || ignoreSellEnchanted && f instanceof class_3853.class_4163)).toArray(class_3853.class_1652[]::new);
                this.method_19170(tradeOfferList, factories, (Integer)pair.getRight());
            }
            ci.cancel();
        }
    }

    @Override
    public void setManager(class_3990 manager) {
        this.unruffled_wanderingTraderManager = manager;
    }

    @Override
    public class_3990 getManager() {
        return this.unruffled_wanderingTraderManager;
    }

    @Override
    public class_1657 getNearbyPlayer(int index) {
        class_1937 class_19372;
        if (this.unruffled_nearbyPlayers == null && (class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            this.unruffled_nearbyPlayers = world.method_47540(player -> player.method_73189().method_1022(this.method_73189()) < 48.0, 20);
            Collections.shuffle(this.unruffled_nearbyPlayers, new Random(this.method_59922().method_43055()));
        }
        if (this.unruffled_nearbyPlayers != null && index < this.unruffled_nearbyPlayers.size()) {
            return this.unruffled_nearbyPlayers.get(index);
        }
        return null;
    }
}

