/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.sleeping;

import com.mojang.authlib.GameProfile;
import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.config.Config;
import io.github.orlouge.unruffled.interfaces.HasBackupSpawnPoints;
import io.github.orlouge.unruffled.interfaces.HasLockedDeathPosition;
import io.github.orlouge.unruffled.utils.PeacefulChunks;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements HasBackupSpawnPoints,
HasLockedDeathPosition {
    private Optional<class_4208> unruffled_lockedDeathPos = Optional.empty();
    @Shadow
    @Nullable
    private class_3222.class_10766 field_56607;
    private LinkedList<HasBackupSpawnPoints.SpawnPoint> unruffled_backupSpawnPoints = new LinkedList();

    public ServerPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
    }

    @Shadow
    public abstract class_3218 method_51469();

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    public void updatePeacefulChunksOnWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (skipSleepTimer || updateSleepingPlayers || this.field_56607 == null || this.field_56607.comp_3684() == null || !this.method_6113()) {
            return;
        }
        PeacefulChunks.get(this.method_51469().method_17983()).add(this.method_5667(), new class_1923(this.field_56607.comp_3684()), 7);
    }

    @Inject(method={"setSpawnPoint"}, at={@At(value="HEAD")})
    public void updatePeacefulChunksOnSetSpawnPoint(class_3222.class_10766 respawn, boolean sendMessage, CallbackInfo ci) {
        if (this.field_56607 == null || this.field_56607.comp_3684() == null || this.field_56607.comp_3684().equals((Object)(respawn == null ? null : respawn.comp_3684())) && this.field_56607.comp_3683().equals(respawn.comp_3683())) {
            return;
        }
        HasBackupSpawnPoints.SpawnPoint currentSpawnPos = new HasBackupSpawnPoints.SpawnPoint(this.field_56607.comp_3684(), (class_5321<class_1937>)this.field_56607.comp_3683(), this.field_56607.comp_3685(), this.field_56607.comp_3686());
        PeacefulChunks peacefulChunks = PeacefulChunks.get(this.method_51469().method_17983());
        class_1923 centerPos = peacefulChunks.getCenterPos(this.method_5667());
        if (centerPos != null && centerPos.equals((Object)new class_1923(this.field_56607.comp_3684()))) {
            this.addBackupSpawnPoint(currentSpawnPos);
        }
        peacefulChunks.remove(this.method_5667(), new class_1923(this.field_56607.comp_3684()), 7);
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    public void copyBackupSpawnPoints(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof HasBackupSpawnPoints) {
            HasBackupSpawnPoints backupSpawnPoints = (HasBackupSpawnPoints)oldPlayer;
            this.setBackupSpawnPoints(backupSpawnPoints.getBackupSpawnPoints());
        }
        if (oldPlayer instanceof HasLockedDeathPosition) {
            HasLockedDeathPosition lockedDeathPosition = (HasLockedDeathPosition)oldPlayer;
            this.unruffled_lockedDeathPos = lockedDeathPosition.getLockedDeathPosition();
        }
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    public void readBackupSpawnPoint(class_11368 view, CallbackInfo ci) {
        this.unruffled_backupSpawnPoints = new LinkedList();
        Optional spawnList = view.method_71435("BackupSpawn", HasBackupSpawnPoints.SpawnPoint.CODEC);
        spawnList.ifPresent(spawnPoints -> this.unruffled_backupSpawnPoints.addAll(spawnPoints.method_71456().toList()));
        this.unruffled_lockedDeathPos = view.method_71426("LockedDeathLocation", class_4208.field_25066);
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    public void writeBackupSpawnPoint(class_11372 view, CallbackInfo ci) {
        if (this.unruffled_backupSpawnPoints != null) {
            class_11372.class_11373 spawnList = view.method_71467("BackupSpawn", HasBackupSpawnPoints.SpawnPoint.CODEC);
            for (HasBackupSpawnPoints.SpawnPoint point : this.unruffled_backupSpawnPoints) {
                spawnList.method_71484((Object)point);
            }
        }
        this.unruffled_lockedDeathPos.ifPresent(pos -> view.method_71468("LockedDeathLocation", class_4208.field_25066, pos));
    }

    @Override
    public HasBackupSpawnPoints.SpawnPoint getTopBackupSpawnPoint() {
        return !this.unruffled_backupSpawnPoints.isEmpty() ? this.unruffled_backupSpawnPoints.getFirst() : null;
    }

    @Override
    public void addBackupSpawnPoint(HasBackupSpawnPoints.SpawnPoint pos) {
        if (((Config)Config.INSTANCE.method_15332()).mechanicsConfig.backupSpawnPoints() == 0) {
            this.unruffled_backupSpawnPoints.clear();
            return;
        }
        this.deleteBackupSpawnPoint(pos);
        while (this.unruffled_backupSpawnPoints.size() >= ((Config)Config.INSTANCE.method_15332()).mechanicsConfig.backupSpawnPoints()) {
            this.unruffled_backupSpawnPoints.removeLast();
        }
        this.unruffled_backupSpawnPoints.addFirst(pos);
    }

    @Override
    public void deleteBackupSpawnPoint(HasBackupSpawnPoints.SpawnPoint pos) {
        this.unruffled_backupSpawnPoints.remove(pos);
    }

    @Override
    public void setBackupSpawnPoints(Collection<HasBackupSpawnPoints.SpawnPoint> spawnPoints) {
        this.unruffled_backupSpawnPoints = new LinkedList<HasBackupSpawnPoints.SpawnPoint>(spawnPoints);
    }

    @Override
    public Collection<HasBackupSpawnPoints.SpawnPoint> getBackupSpawnPoints() {
        return this.unruffled_backupSpawnPoints;
    }

    @Override
    public Optional<class_4208> getLockedDeathPosition() {
        return this.unruffled_lockedDeathPos;
    }

    @Override
    public void setLockedDeathPosition() {
        this.unruffled_lockedDeathPos = this.method_43122();
        UnruffledMod.sendLockedDeathPosition((class_3222)this, this.unruffled_lockedDeathPos);
    }
}

