/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.unruffled.config.Config;
import io.github.orlouge.unruffled.utils.ExtraCodecs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_26;
import net.minecraft.class_4844;

public class PeacefulChunks
extends class_18 {
    public static final int PEACEFUL_RANGE = 7;
    private final HashMap<class_1923, HashSet<UUID>> chunkPlayerMap;
    private final HashMap<UUID, class_1923> playerCenterMap;
    public static final Codec<PeacefulChunks> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.mapAsListOfPairs(class_1923.field_54241, Codec.list((Codec)class_4844.field_41525)).xmap(mapOfLists -> new HashMap<class_1923, HashSet>(mapOfLists.entrySet().stream().collect(Collectors.toMap(e -> (class_1923)e.getKey(), e -> new HashSet((Collection)e.getValue())))), mapOfSets -> new HashMap<class_1923, ArrayList>(mapOfSets.entrySet().stream().collect(Collectors.toMap(e -> (class_1923)e.getKey(), e -> new ArrayList((Collection)e.getValue()))))).fieldOf("chunks").forGetter(state -> state.chunkPlayerMap), (App)Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)class_1923.field_54241).fieldOf("centers").forGetter(state -> state.playerCenterMap)).apply((Applicative)instance, PeacefulChunks::new));
    private static final class_10741<PeacefulChunks> TYPE = new class_10741("unruffled_peaceful_chunks", PeacefulChunks::new, CODEC, null);

    public PeacefulChunks() {
        this.chunkPlayerMap = new HashMap();
        this.playerCenterMap = new HashMap();
    }

    public PeacefulChunks(Map<class_1923, HashSet<UUID>> chunks, Map<UUID, class_1923> centers) {
        this.chunkPlayerMap = new HashMap<class_1923, HashSet<UUID>>(chunks);
        this.playerCenterMap = new HashMap<UUID, class_1923>(centers);
    }

    public void add(UUID uuid, class_1923 pos, int range) {
        class_1923 prevPos = this.playerCenterMap.get(uuid);
        if (prevPos != null) {
            if (prevPos.equals((Object)pos)) {
                return;
            }
            this.removeFromChunkMap(uuid, pos, range);
        }
        for (int x = pos.field_9181 - ++range; x <= pos.field_9181 + range; ++x) {
            for (int z = pos.field_9180 - range; z <= pos.field_9180 + range; ++z) {
                if ((x - pos.field_9181) * (x - pos.field_9181) + (z - pos.field_9180) * (z - pos.field_9180) > range * range) continue;
                this.chunkPlayerMap.computeIfAbsent(new class_1923(x, z), ignored -> new HashSet()).add(uuid);
            }
        }
        this.playerCenterMap.put(uuid, pos);
        this.method_80();
    }

    public void remove(UUID uuid, class_1923 pos, int range) {
        this.removeFromChunkMap(uuid, pos, range);
        class_1923 prevPos = this.playerCenterMap.get(uuid);
        if (prevPos != null && !prevPos.equals((Object)pos)) {
            this.removeFromChunkMap(uuid, prevPos, range);
        }
        this.playerCenterMap.remove(uuid);
        this.method_80();
    }

    public class_1923 getCenterPos(UUID uuid) {
        return this.playerCenterMap.get(uuid);
    }

    private void removeFromChunkMap(UUID uuid, class_1923 pos, int range) {
        for (int x = pos.field_9181 - ++range; x <= pos.field_9181 + range; ++x) {
            for (int z = pos.field_9180 - range; z <= pos.field_9180 + range; ++z) {
                if ((x - pos.field_9181) * (x - pos.field_9181) + (z - pos.field_9180) * (z - pos.field_9180) > range * range) continue;
                this.chunkPlayerMap.computeIfPresent(new class_1923(x, z), (ignored, set) -> {
                    set.remove(uuid);
                    return set;
                });
            }
        }
    }

    public boolean isPeaceful(class_1923 pos) {
        return ((Config)Config.INSTANCE.method_15332()).mechanicsConfig.peacefulChunks() && !this.chunkPlayerMap.getOrDefault(pos, new HashSet()).isEmpty();
    }

    public Set<UUID> peacefulChunkBedOwners(class_1923 pos) {
        return ((Config)Config.INSTANCE.method_15332()).mechanicsConfig.peacefulChunks() ? (Set)this.chunkPlayerMap.getOrDefault(pos, new HashSet()) : Collections.emptySet();
    }

    public static PeacefulChunks get(class_26 persistentStateManager) {
        return (PeacefulChunks)persistentStateManager.method_17924(TYPE);
    }
}

