/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.unruffled.interfaces.HasAttachedLodestone;
import io.github.orlouge.unruffled.utils.ExtraCodecs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_10741;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1759;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4208;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7477;
import net.minecraft.class_7924;
import net.minecraft.class_8113;
import net.minecraft.class_8824;
import net.minecraft.class_9290;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class TradedCompasses
extends class_18 {
    public final HashMap<UUID, LinkedHashMap<class_4208, class_1799>> availableForBuy;
    public final Map<UUID, List<Compass>> availableForSell;
    public final Map<class_2561, Integer> usedNames;
    public final Map<class_2561, Integer> usedLores;
    private final Map<class_4208, Lodestone> lodestoneStatus;
    public static final Codec<TradedCompasses> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_41525, ExtraCodecs.orderedMapAsListOfPairs(class_4208.field_25066, class_1799.field_24671)).fieldOf("buy").forGetter(state -> state.availableForBuy), (App)Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Codec.list(Compass.CODEC)).fieldOf("sell").forGetter(state -> state.availableForSell), (App)ExtraCodecs.mapAsListOfPairs(class_8824.field_46597, ExtraCodecs.wrapInRecord(Codec.INT)).fieldOf("names").forGetter(state -> state.usedNames), (App)ExtraCodecs.mapAsListOfPairs(class_8824.field_46597, ExtraCodecs.wrapInRecord(Codec.INT)).fieldOf("lores").forGetter(state -> state.usedLores), (App)ExtraCodecs.mapAsListOfPairs(class_4208.field_25066, Lodestone.CODEC).fieldOf("lodestones").forGetter(state -> state.lodestoneStatus)).apply((Applicative)instance, TradedCompasses::new));
    private static final class_10741<TradedCompasses> TYPE = new class_10741("unruffled_traded_compasses", TradedCompasses::new, CODEC, null);
    public static final int MAX_BUY_PER_PLAYER = 50;
    public static final int MAX_SELL_PER_PLAYER = 30;

    public TradedCompasses() {
        this.availableForBuy = new HashMap();
        this.availableForSell = new HashMap<UUID, List<Compass>>();
        this.usedNames = new HashMap<class_2561, Integer>();
        this.usedLores = new HashMap<class_2561, Integer>();
        this.lodestoneStatus = new HashMap<class_4208, Lodestone>();
    }

    public TradedCompasses(Map<UUID, LinkedHashMap<class_4208, class_1799>> availableForBuy, Map<UUID, List<Compass>> availableForSell, Map<class_2561, Integer> usedNames, Map<class_2561, Integer> usedLores, Map<class_4208, Lodestone> lodestoneStatus) {
        this.availableForBuy = new HashMap<UUID, LinkedHashMap<class_4208, class_1799>>(availableForBuy);
        this.availableForSell = new HashMap<UUID, List<Compass>>(availableForSell);
        this.usedNames = new HashMap<class_2561, Integer>(usedNames);
        this.usedLores = new HashMap<class_2561, Integer>(usedLores);
        this.lodestoneStatus = new HashMap<class_4208, Lodestone>(lodestoneStatus);
    }

    public static TradedCompasses get(class_26 persistentStateManager) {
        return (TradedCompasses)persistentStateManager.method_17924(TYPE);
    }

    public void addBuy(class_1657 player, class_1799 compass) {
        compass = compass.method_7972();
        compass.method_7939(1);
        LinkedHashMap buy = this.availableForBuy.computeIfAbsent(player.method_5667(), k -> new LinkedHashMap());
        Optional<Compass> compassData = TradedCompasses.getCompass(compass);
        if (compassData.isEmpty()) {
            return;
        }
        class_4208 pos = new class_4208(compassData.get().dimension, compassData.get().lodestonePos());
        Lodestone status = this.lodestoneStatus.get(pos);
        if (status != null && status.sellTrades > 0 && !buy.containsKey(pos)) {
            return;
        }
        buy.remove(pos);
        while (buy.size() >= 50) {
            buy.pollFirstEntry();
        }
        buy.putLast(pos, compass);
        this.method_80();
    }

    public void addSell(class_1799 compassStack, class_1657 customer, List<? extends class_1657> possibleSellers) {
        if (customer == null) {
            return;
        }
        Optional<Compass> soldCompass = TradedCompasses.getCompass(compassStack);
        if (soldCompass.isPresent()) {
            class_4208 pos = new class_4208(soldCompass.get().dimension, soldCompass.get().lodestonePos);
            Lodestone lodestone = this.lodestoneStatus.get(pos);
            Compass compass = soldCompass.get().lore.isPresent() && lodestone.name().equals(soldCompass.get().lore()) ? new Compass(soldCompass.get().name, Optional.empty(), soldCompass.get().lodestonePos, soldCompass.get().dimension) : soldCompass.get();
            Set<UUID> keys = possibleSellers == null ? this.availableForBuy.keySet() : Stream.concat(Stream.of(customer), possibleSellers.stream()).map(class_1297::method_5667).toList();
            for (UUID uuid : keys) {
                LinkedHashMap buy = this.availableForBuy.getOrDefault(uuid, new LinkedHashMap());
                if (buy.isEmpty()) continue;
                buy.remove(pos);
            }
            List sell = this.availableForSell.computeIfAbsent(customer.method_5667(), k -> new LinkedList());
            while (sell.size() >= 30) {
                Compass removedCompass = (Compass)sell.removeFirst();
                class_4208 removedCompassPos = new class_4208(removedCompass.dimension, removedCompass.lodestonePos);
                Lodestone removedCompassLodestone = this.lodestoneStatus.get(removedCompassPos);
                if (removedCompassLodestone == null) continue;
                this.lodestoneStatus.put(removedCompassPos, new Lodestone(removedCompassLodestone.name, removedCompassLodestone.sellTrades - 1, removedCompassLodestone.displayEntityUUID));
            }
            sell.add(compass);
            this.lodestoneStatus.put(pos, lodestone == null ? new Lodestone(Optional.empty(), 1, Optional.empty()) : new Lodestone(lodestone.name, lodestone.sellTrades + 1, lodestone.displayEntityUUID));
            compass.name.ifPresent(text -> this.usedNames.merge((class_2561)text, 1, (k, v) -> v + 1));
            compass.lore.ifPresent(text -> this.usedLores.merge((class_2561)text, 1, (k, v) -> v + 1));
            this.method_80();
        }
    }

    public class_1799 getBuy(class_3218 world, class_1657 player) {
        LinkedHashMap buy = this.availableForBuy.getOrDefault(player.method_5667(), new LinkedHashMap());
        for (int attempts = 0; !buy.isEmpty() && attempts < 10; ++attempts) {
            class_1799 stack = (class_1799)buy.lastEntry().getValue();
            Optional<Compass> topCompass = TradedCompasses.getCompass(stack);
            if (topCompass.isPresent() && topCompass.get().isValid(world.method_8503())) {
                List sell = this.availableForSell.getOrDefault(player.method_5667(), Collections.emptyList());
                for (Compass soldCompass : sell) {
                    if (!soldCompass.isClone(topCompass.get())) continue;
                    stack = null;
                    break;
                }
                if (stack != null) {
                    return stack;
                }
            }
            buy.pollLastEntry();
            this.method_80();
        }
        return null;
    }

    public class_1799 getRandomSell(int attempts, class_3218 world, class_5819 random, class_243 posToAvoid) {
        ArrayList<UUID> players = new ArrayList<UUID>(this.availableForSell.keySet());
        int maxAttempts = attempts;
        for (int i = 0; i < maxAttempts; ++i) {
            Optional profile;
            Compass compass;
            if (players.isEmpty()) {
                return null;
            }
            int index = players.size() == 1 ? 0 : random.method_43051(0, players.size());
            UUID uuid = (UUID)players.get(index);
            List sell = this.availableForSell.getOrDefault(uuid, Collections.emptyList());
            if (sell.isEmpty()) {
                players.remove(index);
                if (i >= 100) continue;
                ++maxAttempts;
                continue;
            }
            if (sell.size() == 1) {
                compass = (Compass)sell.getFirst();
            } else {
                sell = new ArrayList(sell);
                Compass last = (Compass)sell.getLast();
                for (int j = 0; j < sell.size() / 4; ++j) {
                    sell.add(last);
                }
                compass = (Compass)sell.get(random.method_43051(0, sell.size()));
            }
            if (i < maxAttempts - 2 && posToAvoid.method_1022(compass.lodestonePos.method_46558()) * 0.003 + (double)random.method_43057() < 1.0) {
                if (i >= attempts) continue;
                ++maxAttempts;
                continue;
            }
            if (!compass.isValid(world.method_8503())) {
                this.invalidateCompass(uuid, compass);
                continue;
            }
            if (!(class_1802.field_8251 instanceof class_1759)) continue;
            class_1799 stack = new class_1799((class_1935)class_1802.field_8251);
            class_4208 pos = new class_4208(compass.dimension, compass.lodestonePos);
            stack.method_57379(class_9334.field_49614, (Object)new class_9291(Optional.of(pos), true));
            class_2561 name = null;
            ArrayList<Object> lore = null;
            boolean duplicateName = true;
            boolean duplicateLore = true;
            if (compass.name.isPresent()) {
                name = compass.name.get();
                duplicateName = this.usedNames.getOrDefault(name, 0) > 1;
            }
            class_2561 compassLore = null;
            if (compass.lore.isPresent()) {
                compassLore = compass.lore.get();
            } else {
                Lodestone lodestone = this.lodestoneStatus.get(pos);
                if (lodestone != null && lodestone.name.isPresent()) {
                    compassLore = lodestone.name.get();
                }
            }
            if (compassLore != null) {
                lore = new ArrayList<class_2561>(List.of(compassLore));
                boolean bl = duplicateLore = this.usedLores.getOrDefault(compassLore, 0) > 1;
            }
            if (duplicateName && duplicateLore && (profile = Optional.ofNullable(world.method_8503().method_3793()).flatMap(cache -> cache.method_14512(uuid))).isPresent()) {
                if (lore == null) {
                    lore = new ArrayList();
                }
                lore.addAll(class_2561.method_30163((String)String.format("%s / %04d", ((GameProfile)profile.get()).getName(), Math.abs(pos.hashCode()) % 10000)).method_36136(class_2583.field_24360.method_10977(class_124.field_1080)));
            }
            if (name != null) {
                stack.method_57379(class_9334.field_49631, (Object)name);
            }
            if (lore != null) {
                stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            }
            return stack;
        }
        return null;
    }

    private void invalidateCompass(UUID uuid, Compass compass) {
        Integer used;
        List sell = this.availableForSell.getOrDefault(uuid, Collections.emptyList());
        class_4208 pos = new class_4208(compass.dimension, compass.lodestonePos);
        Lodestone lodestoneStatus = this.lodestoneStatus.get(pos);
        if (lodestoneStatus != null) {
            this.lodestoneStatus.put(pos, new Lodestone(lodestoneStatus.name, lodestoneStatus.sellTrades - 1, lodestoneStatus.displayEntityUUID));
        }
        if ((sell = new ArrayList<Compass>(sell.stream().filter(other -> !other.isClone(compass)).toList())).isEmpty()) {
            this.availableForSell.remove(uuid);
        } else {
            this.availableForSell.put(uuid, sell);
        }
        if (compass.name.isPresent()) {
            class_2561 name = compass.name.get();
            used = this.usedNames.getOrDefault(name, 0);
            if (used > 1) {
                this.usedNames.put(name, used - 1);
            } else if (used == 1) {
                this.usedNames.remove(name);
            }
        }
        if (compass.lore.isPresent()) {
            class_2561 lore = compass.lore.get();
            used = this.usedLores.getOrDefault(lore, 0);
            if (used > 1) {
                this.usedLores.put(lore, used - 1);
            } else if (used == 1) {
                this.usedLores.remove(lore);
            }
        }
        this.method_80();
    }

    public static Optional<Compass> getCompass(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8251) && stack.method_57826(class_9334.field_49614)) {
            class_9291 lodestone = (class_9291)stack.method_58694(class_9334.field_49614);
            if (lodestone == null || lodestone.comp_2402().isEmpty()) {
                return Optional.empty();
            }
            class_5321 lodestoneDimension = ((class_4208)lodestone.comp_2402().get()).comp_2207();
            class_2338 lodestonePos = ((class_4208)lodestone.comp_2402().get()).comp_2208();
            return Optional.of(new Compass(stack.method_57826(class_9334.field_49631) && !((class_2561)stack.method_58694(class_9334.field_49631)).method_10858(10).isEmpty() ? Optional.of(stack.method_7964()) : Optional.empty(), stack.method_57826(class_9334.field_49632) ? Optional.of(((class_9290)stack.method_58694(class_9334.field_49632)).comp_2400()).filter(s -> !s.isEmpty()).map(s -> (class_2561)s.get(0)) : Optional.empty(), lodestonePos, (class_5321<class_1937>)lodestoneDimension));
        }
        return Optional.empty();
    }

    public void storeLodestoneName(class_4208 blockPos, class_2561 name, class_3218 world) {
        int sellTrades = 0;
        Lodestone oldStatus = this.lodestoneStatus.get(blockPos);
        if (oldStatus != null) {
            sellTrades = oldStatus.sellTrades;
            if (oldStatus.name.isPresent()) {
                Integer used = this.usedLores.getOrDefault(oldStatus.name.get(), 0);
                if (used > 1) {
                    this.usedLores.put(oldStatus.name.get(), used - 1);
                } else if (used == 1) {
                    this.usedLores.remove(oldStatus.name.get());
                }
            }
            oldStatus.displayEntityUUID.flatMap(uuid -> Optional.ofNullable(world.method_66347(uuid))).ifPresent(class_1297::method_31472);
        }
        Optional<UUID> displayUuid = Optional.empty();
        if (name != null) {
            this.usedLores.compute(name, (k, cnt) -> cnt == null ? 1 : cnt + 1);
            class_8113.class_8123 display = (class_8113.class_8123)class_1299.field_42457.method_5883((class_1937)world, class_3730.field_52444);
            if (display instanceof HasAttachedLodestone) {
                HasAttachedLodestone attachedLodestone = (HasAttachedLodestone)display;
                attachedLodestone.setAttachedLodestone(blockPos.comp_2208(), name);
                world.method_8649((class_1297)display);
                displayUuid = Optional.of(display.method_5667());
            }
        }
        this.lodestoneStatus.put(blockPos, new Lodestone(Optional.ofNullable(name), sellTrades, displayUuid));
        this.method_80();
    }

    public void deleteLodestoneName(class_4208 blockPos, class_3218 world) {
        this.storeLodestoneName(blockPos, null, world);
        this.method_80();
    }

    public class_2561 getLodestoneName(class_4208 blockPos) {
        return Optional.ofNullable(this.lodestoneStatus.get(blockPos)).flatMap(Lodestone::name).orElse(null);
    }

    public record Compass(Optional<class_2561> name, Optional<class_2561> lore, class_2338 lodestonePos, class_5321<class_1937> dimension) {
        public static final Codec<Compass> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.optionalFieldOf("name").forGetter(Compass::name), (App)class_8824.field_46597.optionalFieldOf("lore").forGetter(Compass::lore), (App)class_2338.field_25064.fieldOf("pos").forGetter(Compass::lodestonePos), (App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("dimension").forGetter(Compass::dimension)).apply((Applicative)instance, Compass::new));

        public boolean isValid(MinecraftServer server) {
            class_3218 targetWorld = server.method_3847(this.dimension);
            if (targetWorld == null) {
                return false;
            }
            return targetWorld.method_24794(this.lodestonePos) && targetWorld.method_19494().method_26339(class_7477.field_39296, this.lodestonePos);
        }

        public boolean isClone(Compass other) {
            return this.lodestonePos.equals((Object)other.lodestonePos) && this.dimension.equals(other.dimension);
        }
    }

    public record Lodestone(Optional<class_2561> name, int sellTrades, Optional<UUID> displayEntityUUID) {
        public static final Codec<Lodestone> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.optionalFieldOf("name").forGetter(Lodestone::name), (App)Codec.INT.fieldOf("trades").forGetter(Lodestone::sellTrades), (App)class_4844.field_41525.optionalFieldOf("display_entity").forGetter(Lodestone::displayEntityUUID)).apply((Applicative)instance, Lodestone::new));
    }
}

