/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.worldgen;

import com.mojang.serialization.Codec;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5689;
import net.minecraft.class_5803;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7924;
import net.minecraft.class_8174;

public class UndergroundPondFeature
extends class_3031<class_3111> {
    private static final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    public static final class_2680[] SURFACE_BLOCKS = new class_2680[]{class_2246.field_28681.method_9564(), class_2246.field_28681.method_9564(), class_2246.field_28681.method_9564(), class_2246.field_28681.method_9564(), class_2246.field_10115.method_9564(), class_2246.field_37556.method_9564()};
    public static final class_2680[] SUBMERGED_BLOCKS = new class_2680[]{class_2246.field_28681.method_9564(), class_2246.field_37576.method_9564(), class_2246.field_10255.method_9564(), class_2246.field_10255.method_9564()};
    public static final class_2680[] CEILING_BLOCKS = new class_2680[]{class_2246.field_28686.method_9564(), class_2246.field_28686.method_9564(), (class_2680)class_2246.field_28675.method_9564().method_11657((class_2769)class_5803.field_28688, (Comparable)Boolean.valueOf(true)), class_2246.field_28675.method_9564(), class_2246.field_28675.method_9564(), (class_2680)class_2246.field_28048.method_9564().method_11657((class_2769)class_5689.field_28050, (Comparable)class_2350.field_11033), (class_2680)class_2246.field_28048.method_9564().method_11657((class_2769)class_5689.field_28050, (Comparable)class_2350.field_11033), class_2246.field_28677.method_9564()};
    public static final class_2680[] WALL_BLOCKS = new class_2680[]{class_2246.field_28685.method_9564(), class_2246.field_28049.method_9564(), class_2246.field_28049.method_9564(), class_2246.field_10115.method_9564(), class_2246.field_37556.method_9564()};
    public static final class_2680[] FLOOR_BLOCKS = new class_2680[]{class_2246.field_28680.method_9564(), class_2246.field_10016.method_9564(), class_2246.field_10479.method_9564()};
    public static final class_2680[] SUBMERGED_FLOOR_BLOCKS = new class_2680[]{class_2246.field_10376.method_9564(), (class_2680)class_2246.field_28048.method_9564().method_11657((class_2769)class_5689.field_28052, (Comparable)Boolean.valueOf(true)), (class_2680)class_2246.field_10016.method_9564().method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(true))};
    public static final int WATER_DEPTH = 4;
    public static final int MIN_RADIUS = 5;
    public static final int MAX_RADIUS = 11;
    public static final int HEIGHT = 5;
    public static final int MAX_AIR_INTERSECTION = 1;

    public UndergroundPondFeature(Codec<class_3111> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        class_2338 origin = context.method_33655();
        block0: for (int tries = 0; tries < 20 && origin.method_10264() > 4; ++tries) {
            for (int axis = 0; axis <= 1; ++axis) {
                int airY;
                block44: {
                    for (int edge = -1; edge <= 1; edge += 2) {
                        for (int i = -5; i <= 5; ++i) {
                            int x = axis * (5 * edge) + (1 - axis) * i;
                            int z = (1 - axis) * (5 * edge) + axis * i;
                            airY = 1;
                            for (int y = 0; y >= -5 && y >= -origin.method_10264() - 4; --y) {
                                class_2680 state = world.method_8320(origin.method_10069(x, y, z));
                                if (!state.method_26215() && !state.method_51176()) continue;
                                airY = y;
                            }
                            if (airY > 0) {
                                continue;
                            }
                            break block44;
                        }
                    }
                    continue;
                }
                origin = origin.method_10069(0, airY - 1, 0);
                continue block0;
            }
        }
        int airBlocks = 0;
        int[] openings = new int[26];
        int maxRadius = 11;
        block5: for (int distance = 5; distance <= 12; ++distance) {
            for (int axis = 0; axis <= 1; ++axis) {
                for (int edge = -1; edge <= 1; edge += 2) {
                    for (int i = -distance; i <= distance; ++i) {
                        int x = axis * (distance * edge) + (1 - axis) * i;
                        int z = (1 - axis) * (distance * edge) + axis * i;
                        int sqRadius = x * x + z * z;
                        for (int y = -5; y <= 6; ++y) {
                            class_2680 state = world.method_8320(origin.method_10069(x, y, z));
                            if ((state.method_51176() || !this.canReplace(state)) && sqRadius <= 144) {
                                maxRadius = Math.min(maxRadius, distance - 1);
                                break block5;
                            }
                            if (!state.method_26215()) continue;
                            if (y <= 0) {
                                maxRadius = Math.min(maxRadius, distance - 1);
                                break block5;
                            }
                            ++airBlocks;
                            if (y >= 4) continue;
                            int n = (int)Math.ceil(Math.sqrt(sqRadius));
                            openings[n] = openings[n] + 1;
                        }
                    }
                }
            }
            if (airBlocks > 45 + 1 * distance * distance) {
                maxRadius = Math.min(maxRadius, distance - 1);
                break;
            }
            if (openings[distance] <= 10 || !random.method_43056()) continue;
            maxRadius = Math.min(maxRadius, distance);
            break;
        }
        if (maxRadius < 5) {
            return false;
        }
        int radius = 5;
        if (maxRadius > 5) {
            if (openings[maxRadius] > 5) {
                radius = maxRadius;
            } else {
                radius = random.method_39332(-maxRadius * 10, maxRadius);
                if (radius < 5) {
                    return false;
                }
            }
        }
        int topY = world.method_8624(class_2902.class_2903.field_13195, origin.method_10263(), origin.method_10260());
        boolean replaceOnWater = random.method_43048(2) == 0;
        class_2680 topBlock = world.method_8320(new class_2338(origin.method_10263(), topY, origin.method_10260()));
        if (topBlock.method_26215() || replaceOnWater && topBlock.method_51176()) {
            class_2586 blockEntity;
            class_2338 surfacePos = new class_2338(origin.method_10263(), topY - 1, origin.method_10260());
            class_2680 surfaceBlock = world.method_8320(surfacePos);
            boolean replace = true;
            if (surfaceBlock.method_27852(class_2246.field_10255)) {
                this.method_36998(world, surfacePos, class_2246.field_43227.method_9564(), this::canReplace);
            } else if (surfaceBlock.method_27852(class_2246.field_10102)) {
                this.method_36998(world, surfacePos, class_2246.field_42728.method_9564(), this::canReplace);
            } else {
                replace = false;
            }
            if (replace && (blockEntity = world.method_8321(surfacePos)) instanceof class_8174) {
                ((class_8174)blockEntity).method_49216(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"unruffled", (String)"archaeology/underground_pond")), random.method_43055());
            }
        }
        float[][] rawHeight = new float[radius * 2 + 3][radius * 2 + 3];
        float[][] rawDepth = new float[radius * 2 + 3][radius * 2 + 3];
        for (int x = -radius - 1; x <= radius + 1; ++x) {
            for (int z = -radius - 1; z <= radius + 1; ++z) {
                int depth;
                int height;
                int sqRadius = x * x + z * z;
                if (sqRadius > radius * radius) continue;
                for (height = 1; height <= 4; ++height) {
                    double stopChance = Math.pow((double)sqRadius / (double)(radius * radius), 1.5);
                    if (random.method_43058() < stopChance) break;
                }
                rawHeight[x + radius + 1][z + radius + 1] = height;
                for (depth = 0; depth < 4 && depth <= height; ++depth) {
                    double stopChance = 0.1 + Math.pow((double)Math.max(0, sqRadius - 4) / (double)((radius - 2) * (radius - 4)), 1.5);
                    if (random.method_43058() < stopChance) break;
                }
                rawDepth[x + radius + 1][z + radius + 1] = depth;
            }
        }
        int springs = 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int y;
                int sqRadius = x * x + z * z;
                if (sqRadius > radius * radius) continue;
                float heightSum = rawHeight[x + radius + 1][z + radius + 1] + rawHeight[x - 1 + radius + 1][z + radius + 1] + rawHeight[x + 1 + radius + 1][z + radius + 1] + rawHeight[x + radius + 1][z - 1 + radius + 1] + rawHeight[x + radius + 1][z + 1 + radius + 1];
                int height = Math.round(heightSum / 5.0f);
                float depthSum = rawDepth[x + radius + 1][z + radius + 1] + rawDepth[x - 1 + radius + 1][z + radius + 1] + rawDepth[x + 1 + radius + 1][z + radius + 1] + rawDepth[x + radius + 1][z - 1 + radius + 1] + rawDepth[x + radius + 1][z + 1 + radius + 1] + rawDepth[x + 1 + radius + 1][z + 1 + radius + 1] + rawDepth[x + 1 + radius + 1][z - 1 + radius + 1] + rawDepth[x - 1 + radius + 1][z + 1 + radius + 1] + rawDepth[x - 1 + radius + 1][z - 1 + radius + 1];
                int depth = Math.round(depthSum / 9.0f);
                if (height > 0) {
                    for (int y2 = 1; y2 < height; ++y2) {
                        this.method_36998(world, origin.method_10069(x, y2, z), CAVE_AIR, this::canReplace);
                    }
                }
                boolean lastBlockIsAir = false;
                for (y = height; y <= 5; ++y) {
                    lastBlockIsAir = world.method_8320(origin.method_10069(x, y, z)).method_26215();
                    if (lastBlockIsAir) continue;
                    this.setRandomBlock(world, random, origin.method_10069(x, y, z), WALL_BLOCKS, 1);
                    if (random.method_43048(2) == 0) break;
                }
                if (!lastBlockIsAir) {
                    if (height == 4 && depth > 1 && random.method_43048(springs * radius + openings[radius]) == 0) {
                        this.method_36998(world, origin.method_10069(x, 4, z), CAVE_AIR, this::canReplace);
                        this.method_36998(world, origin.method_10069(x, 5, z), class_2246.field_10382.method_9564(), this::canReplace);
                        world.method_39281(origin.method_10069(x, 5, z), (class_3611)class_3612.field_15910, 0);
                        springs += 2;
                    } else if (height > 2) {
                        this.setRandomBlock(world, random, origin.method_10069(x, height, z), CEILING_BLOCKS, 18);
                    }
                }
                if (depth == 0) {
                    this.setRandomBlock(world, random, origin.method_10069(x, 0, z), SURFACE_BLOCKS, 1);
                    this.setRandomBlock(world, random, origin.method_10069(x, 1, z), FLOOR_BLOCKS, 3);
                    continue;
                }
                for (y = 0; y < depth; ++y) {
                    this.method_36998(world, origin.method_10069(x, -y, z), class_2246.field_10382.method_9564(), this::canReplace);
                }
                for (y = depth; y <= 4; ++y) {
                    class_2338 floor = origin.method_10069(x, -y, z);
                    if (random.method_43048(2 + (4 - depth + 1) / 2) == 0) {
                        this.method_36998(world, floor, class_2246.field_43227.method_9564(), this::canReplace);
                        class_2586 blockEntity = world.method_8321(floor);
                        if (blockEntity instanceof class_8174) {
                            ((class_8174)blockEntity).method_49216(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"unruffled", (String)"archaeology/underground_pond")), random.method_43055());
                        }
                    } else {
                        this.setRandomBlock(world, random, floor, SUBMERGED_BLOCKS, 1);
                    }
                    if (random.method_43048(2) == 0) break;
                }
                if (depth <= 2) continue;
                this.setRandomBlock(world, random, origin.method_10069(x, -depth + 1, z), SUBMERGED_FLOOR_BLOCKS, 1);
            }
        }
        return true;
    }

    private boolean canReplace(class_2680 state) {
        return !state.method_26164(class_3481.field_33757);
    }

    protected void setRandomBlock(class_5281 world, class_5819 random, class_2338 pos, class_2680[] states, int fail) {
        int i = random.method_43048(states.length + fail);
        if (i < states.length) {
            this.method_36998(world, pos, states[i], this::canReplace);
        }
    }
}

