/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.unruffled.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_3528;
import net.minecraft.class_5699;

public class Tools {
    public static final String CONFIG_FNAME = String.valueOf(Platform.getConfigDirectory()) + "/unruffled-tools.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean loaded = false;
    public final ToolConfig toolConfig;
    public static final class_3528<Tools> INSTANCE = new class_3528(Tools::read);
    public static Codec<Tools> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ToolConfig.CODEC.optionalFieldOf("stats").forGetter(config -> Optional.ofNullable(config.toolConfig))).apply((Applicative)instance, Tools::new));

    public static boolean isLoaded() {
        return loaded;
    }

    private static Tools read() {
        File file = new File(CONFIG_FNAME);
        Tools defaultConfig = new Tools();
        if (file.isFile()) {
            Tools tools;
            FileReader in = new FileReader(file);
            try {
                tools = (Tools)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)in)).getOrThrow();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        Files.copy(Path.of(CONFIG_FNAME, new String[0]), Path.of(CONFIG_FNAME + ".old", new String[0]), new CopyOption[0]);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            in.close();
            return tools;
        }
        try (FileWriter out = new FileWriter(file);){
            Optional result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)defaultConfig).resultOrPartial(System.out::println);
            if (result.isPresent()) {
                out.write(GSON.toJson((JsonElement)result.get()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        loaded = true;
        return defaultConfig;
    }

    public Tools() {
        this(Optional.empty());
    }

    public Tools(Optional<ToolConfig> toolConfig) {
        this.toolConfig = toolConfig.orElse(new ToolConfig());
    }

    public record ToolConfig(Map<String, Integer> durability, MiningSpeedMultiplierCurve miningSpeedMultiplierCurve) {
        public static final Codec<ToolConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_5699.field_33442).fieldOf("durability").forGetter(ToolConfig::durability), (App)MiningSpeedMultiplierCurve.CODEC.fieldOf("mining_speed_multiplier_curve").forGetter(ToolConfig::miningSpeedMultiplierCurve)).apply((Applicative)instance, ToolConfig::new));

        public ToolConfig() {
            this(Map.of("wood", 118, "stone", 262, "iron", 500, "diamond", 3122, "gold", 200, "netherite", 4062), new MiningSpeedMultiplierCurve());
        }

        public record MiningSpeedMultiplierCurve(float a, float b, float c, boolean neverIncrease, boolean neverDecrease) {
            public static final Codec<MiningSpeedMultiplierCurve> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("a").forGetter(MiningSpeedMultiplierCurve::a), (App)Codec.FLOAT.fieldOf("b").forGetter(MiningSpeedMultiplierCurve::b), (App)Codec.FLOAT.fieldOf("c").forGetter(MiningSpeedMultiplierCurve::c), (App)Codec.BOOL.fieldOf("never_increase").forGetter(MiningSpeedMultiplierCurve::neverIncrease), (App)Codec.BOOL.fieldOf("never_decrease").forGetter(MiningSpeedMultiplierCurve::neverDecrease)).apply((Applicative)instance, MiningSpeedMultiplierCurve::new));

            public MiningSpeedMultiplierCurve() {
                this(0.5f, 0.0f, 0.0f, false, true);
            }

            public float compute(float mul) {
                float mul2 = this.a * mul * mul + this.b * mul + this.c;
                if (this.neverDecrease) {
                    mul2 = Math.max(mul, mul2);
                }
                if (this.neverIncrease) {
                    mul2 = Math.min(mul, mul2);
                }
                return mul2;
            }
        }
    }
}

