/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.sleeping;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.config.Config;
import io.github.orlouge.unruffled.interfaces.HasBackupSpawnPoints;
import io.github.orlouge.unruffled.interfaces.HasLockedDeathPosition;
import io.github.orlouge.unruffled.utils.PeacefulChunks;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements HasBackupSpawnPoints,
HasLockedDeathPosition {
    @Shadow
    @Nullable
    private class_2338 field_23192 = null;
    @Shadow
    private class_5321<class_1937> field_23191 = null;
    @Shadow
    private float field_26353 = 0.0f;
    @Shadow
    private boolean field_23193 = false;
    private Optional<class_4208> unruffled_lockedDeathPos = Optional.empty();
    private LinkedList<HasBackupSpawnPoints.SpawnPoint> unruffled_backupSpawnPoints = new LinkedList();

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Shadow
    public abstract class_3218 method_51469();

    @Shadow
    public abstract void method_14218(float var1, float var2, boolean var3, boolean var4);

    @Shadow
    public abstract void method_26284(class_5321<class_1937> var1, @Nullable class_2338 var2, float var3, boolean var4, boolean var5);

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    public void updatePeacefulChunksOnWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (skipSleepTimer || updateSleepingPlayers || this.field_23192 == null || !this.method_6113()) {
            return;
        }
        PeacefulChunks.get(this.method_51469().method_17983()).add(this.method_5667(), new class_1923(this.field_23192), 7);
    }

    @Inject(method={"setSpawnPoint"}, at={@At(value="HEAD")})
    public void updatePeacefulChunksOnSetSpawnPoint(class_5321<class_1937> dimension, class_2338 pos, float angle, boolean forced, boolean sendMessage, CallbackInfo ci) {
        if (this.field_23192 == null || this.field_23192.equals((Object)pos) && this.field_23191.equals(dimension)) {
            return;
        }
        HasBackupSpawnPoints.SpawnPoint currentSpawnPos = new HasBackupSpawnPoints.SpawnPoint(this.field_23192, this.field_23191, this.field_26353, this.field_23193);
        PeacefulChunks peacefulChunks = PeacefulChunks.get(this.method_51469().method_17983());
        class_1923 centerPos = peacefulChunks.getCenterPos(this.method_5667());
        if (centerPos != null && centerPos.equals((Object)new class_1923(this.field_23192))) {
            this.addBackupSpawnPoint(currentSpawnPos);
        }
        peacefulChunks.remove(this.method_5667(), new class_1923(this.field_23192), 7);
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    public void copyBackupSpawnPoints(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof HasBackupSpawnPoints) {
            HasBackupSpawnPoints backupSpawnPoints = (HasBackupSpawnPoints)oldPlayer;
            this.setBackupSpawnPoints(backupSpawnPoints.getBackupSpawnPoints());
        }
        if (oldPlayer instanceof HasLockedDeathPosition) {
            HasLockedDeathPosition lockedDeathPosition = (HasLockedDeathPosition)oldPlayer;
            this.unruffled_lockedDeathPos = lockedDeathPosition.getLockedDeathPosition();
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readBackupSpawnPoint(class_2487 nbt, CallbackInfo ci) {
        this.unruffled_backupSpawnPoints = new LinkedList();
        if (nbt.method_10573("BackupSpawn", 9)) {
            class_2499 spawnList = nbt.method_10554("BackupSpawn", 10);
            for (class_2520 spawnPointNbt : spawnList) {
                this.unruffled_backupSpawnPoints.add(HasBackupSpawnPoints.SpawnPoint.fromNbt((class_2487)spawnPointNbt));
            }
        }
        if (nbt.method_10573("LockedDeathLocation", 10)) {
            DataResult parsedPos = class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("LockedDeathLocation"));
            this.unruffled_lockedDeathPos = parsedPos.result();
        } else {
            this.unruffled_lockedDeathPos = Optional.empty();
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeBackupSpawnPoint(class_2487 nbt, CallbackInfo ci) {
        if (this.unruffled_backupSpawnPoints != null) {
            class_2499 spawnList = new class_2499();
            for (HasBackupSpawnPoints.SpawnPoint point : this.unruffled_backupSpawnPoints) {
                spawnList.add((Object)point.toNbt());
            }
            nbt.method_10566("BackupSpawn", (class_2520)spawnList);
        }
        this.unruffled_lockedDeathPos.flatMap(pos -> class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, pos).result()).ifPresent(encoded -> nbt.method_10566("LockedDeathLocation", encoded));
    }

    @Override
    public HasBackupSpawnPoints.SpawnPoint getTopBackupSpawnPoint() {
        return !this.unruffled_backupSpawnPoints.isEmpty() ? this.unruffled_backupSpawnPoints.getFirst() : null;
    }

    @Override
    public void addBackupSpawnPoint(HasBackupSpawnPoints.SpawnPoint pos) {
        if (((Config)Config.INSTANCE.method_15332()).mechanicsConfig.backupSpawnPoints() == 0) {
            this.unruffled_backupSpawnPoints.clear();
            return;
        }
        this.deleteBackupSpawnPoint(pos);
        while (this.unruffled_backupSpawnPoints.size() >= ((Config)Config.INSTANCE.method_15332()).mechanicsConfig.backupSpawnPoints()) {
            this.unruffled_backupSpawnPoints.removeLast();
        }
        this.unruffled_backupSpawnPoints.addFirst(pos);
    }

    @Override
    public void deleteBackupSpawnPoint(HasBackupSpawnPoints.SpawnPoint pos) {
        this.unruffled_backupSpawnPoints.remove(pos);
    }

    @Override
    public void setBackupSpawnPoints(Collection<HasBackupSpawnPoints.SpawnPoint> spawnPoints) {
        this.unruffled_backupSpawnPoints = new LinkedList<HasBackupSpawnPoints.SpawnPoint>(spawnPoints);
    }

    @Override
    public Collection<HasBackupSpawnPoints.SpawnPoint> getBackupSpawnPoints() {
        return this.unruffled_backupSpawnPoints;
    }

    @Override
    public Optional<class_4208> getLockedDeathPosition() {
        return this.unruffled_lockedDeathPos;
    }

    @Override
    public void setLockedDeathPosition() {
        this.unruffled_lockedDeathPos = this.method_43122();
        UnruffledMod.sendLockedDeathPosition((class_3222)this, this.unruffled_lockedDeathPos);
    }
}

