/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.unruffled.Platform;
import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.config.Trades;
import io.github.orlouge.unruffled.potions.BrewingPotionRecipe;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_3528;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

public class Config {
    public final HungerConfig hungerConfig;
    public final EnchantmentsConfig enchantmentsConfig;
    public final ElytraConfig elytraConfig;
    public final MechanicsConfig mechanicsConfig;
    public final WorldgenConfig worldgenConfig;
    public final LootConfig lootConfig;
    public final Trades.TradesConfig tradesConfig;
    public final StackSizeConfig stackSizeConfig;
    public final NavigationConfig navigationConfig;
    public final PotionsConfig potionsConfig;
    public static final String CONFIG_FNAME = String.valueOf(Platform.getConfigDirectory()) + "/unruffled.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean loaded = false;
    public static Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HungerConfig.CODEC.fieldOf("hunger").forGetter(config -> config.hungerConfig), (App)EnchantmentsConfig.CODEC.fieldOf("enchantments").forGetter(config -> config.enchantmentsConfig), (App)ElytraConfig.CODEC.fieldOf("elytra").forGetter(config -> config.elytraConfig), (App)MechanicsConfig.CODEC.fieldOf("mechanics").forGetter(config -> config.mechanicsConfig), (App)WorldgenConfig.CODEC.fieldOf("worldgen").forGetter(config -> config.worldgenConfig), (App)LootConfig.CODEC.fieldOf("loot").forGetter(config -> config.lootConfig), (App)Trades.TradesConfig.CODEC.fieldOf("trades").forGetter(config -> config.tradesConfig), (App)StackSizeConfig.CODEC.fieldOf("stack_size").forGetter(config -> config.stackSizeConfig), (App)NavigationConfig.CODEC.optionalFieldOf("navigation").forGetter(config -> Optional.ofNullable(config.navigationConfig)), (App)PotionsConfig.CODEC.optionalFieldOf("potions").forGetter(config -> Optional.ofNullable(config.potionsConfig))).apply((Applicative)instance, Config::new));
    public static final class_3528<Config> INSTANCE = new class_3528(Config::read);

    public static boolean isLoaded() {
        return loaded;
    }

    private static Config read() {
        File file = new File(CONFIG_FNAME);
        Config defaultConfig = new Config();
        if (file.isFile()) {
            Config config;
            FileReader in = new FileReader(file);
            try {
                config = (Config)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)in)).getOrThrow(false, System.out::println);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        Files.copy(Path.of(CONFIG_FNAME, new String[0]), Path.of(CONFIG_FNAME + ".old", new String[0]), new CopyOption[0]);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            in.close();
            return config;
        }
        try (FileWriter out = new FileWriter(file);){
            Optional result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)defaultConfig).resultOrPartial(System.out::println);
            if (result.isPresent()) {
                out.write(GSON.toJson((JsonElement)result.get()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        loaded = true;
        return defaultConfig;
    }

    public Config() {
        this(new HungerConfig(), new EnchantmentsConfig(), new ElytraConfig(), new MechanicsConfig(), new WorldgenConfig(), new LootConfig(), Trades.DEFAULT_CONFIG, new StackSizeConfig(), Optional.empty(), Optional.empty());
    }

    public Config(HungerConfig hungerConfig, EnchantmentsConfig enchantmentsConfig, ElytraConfig elytraConfig, MechanicsConfig mechanicsConfig, WorldgenConfig worldgenConfig, LootConfig lootConfig, Trades.TradesConfig tradesConfig, StackSizeConfig stackSizeConfig, Optional<NavigationConfig> navigationConfig, Optional<PotionsConfig> potionsConfig) {
        this.hungerConfig = hungerConfig;
        this.tradesConfig = tradesConfig;
        this.worldgenConfig = worldgenConfig;
        this.elytraConfig = elytraConfig;
        this.mechanicsConfig = mechanicsConfig;
        this.enchantmentsConfig = enchantmentsConfig;
        this.lootConfig = lootConfig;
        this.stackSizeConfig = stackSizeConfig;
        this.navigationConfig = navigationConfig.orElse(new NavigationConfig());
        this.potionsConfig = potionsConfig.orElse(new PotionsConfig());
    }

    public record HungerConfig(float staminaDepletionRate, float travelPenaltyFactor, float maxTravelPenalty, float hungerDepletionRate, float staminaRegenerationRate, float inventoryWeightPenaltyFactor, float attackExhaustionFactor, boolean attackAlwaysAllowInTime, float eatCooldownFactor, float wearinessIncreaseFactor, float wearinessDecreaseFactor, float wearinessDecreaseFactorOnStillEntities, boolean steadyBlockBlacklist) {
        public static Codec<HungerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("stamina_depletion_rate").forGetter(HungerConfig::staminaDepletionRate), (App)Codec.FLOAT.fieldOf("travel_penalty_factor").forGetter(HungerConfig::travelPenaltyFactor), (App)Codec.FLOAT.fieldOf("travel_penalty_max").forGetter(HungerConfig::maxTravelPenalty), (App)Codec.FLOAT.fieldOf("hunger_depletion_rate").forGetter(HungerConfig::hungerDepletionRate), (App)Codec.FLOAT.fieldOf("stamina_regeneration_factor").forGetter(HungerConfig::staminaRegenerationRate), (App)Codec.FLOAT.fieldOf("inventory_weight_penalty_factor").forGetter(HungerConfig::inventoryWeightPenaltyFactor), (App)Codec.FLOAT.fieldOf("attack_exhaustion_factor").forGetter(HungerConfig::attackExhaustionFactor), (App)Codec.BOOL.fieldOf("attack_always_allow_in_time").forGetter(HungerConfig::attackAlwaysAllowInTime), (App)Codec.FLOAT.fieldOf("eat_cooldown_factor").forGetter(HungerConfig::eatCooldownFactor), (App)Codec.FLOAT.fieldOf("weariness_increase_factor").forGetter(HungerConfig::wearinessIncreaseFactor), (App)Codec.FLOAT.fieldOf("weariness_decrease_factor").forGetter(HungerConfig::wearinessDecreaseFactor), (App)Codec.FLOAT.fieldOf("weariness_decrease_factor_riding_still_entities").forGetter(HungerConfig::wearinessDecreaseFactorOnStillEntities), (App)Codec.BOOL.optionalFieldOf("steady_block_blacklist", (Object)false).forGetter(HungerConfig::steadyBlockBlacklist)).apply((Applicative)instance, HungerConfig::new));

        public HungerConfig() {
            this(0.2f, 0.003f, 2.8f, 0.2f, 0.0028f, 1.0f, 2.0f, true, 0.2f, 0.1f, 0.99975f, 0.9993f, true);
        }
    }

    public record EnchantmentsConfig(boolean disableEnchantingTable, boolean disableGrindstone, boolean disableRepairXpCost, boolean disableGlint, boolean showLevelNumber, Optional<Boolean> disenchantChiseledBookshelfBooks, Optional<Boolean> filterStructureChiseledBookshelves, Set<class_1887> unobtainableEnchantments, Set<class_1887> disabledEnchantments, Map<class_1792, Map<class_1887, Integer>> itemEnchantments) {
        public static Codec<Set<class_1887>> ENCHANTMENT_SET_CODEC = new ListCodec(class_7923.field_41176.method_39673()).xmap(HashSet::new, LinkedList::new);
        public static Codec<Map<class_1887, Integer>> ENCHANTMENT_MAP_CODEC = Codec.unboundedMap((Codec)class_7923.field_41176.method_39673(), (Codec)class_5699.field_33442);
        public static final Codec<EnchantmentsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("disable_enchanting_table").forGetter(EnchantmentsConfig::disableEnchantingTable), (App)Codec.BOOL.fieldOf("disable_grindstone").forGetter(EnchantmentsConfig::disableGrindstone), (App)Codec.BOOL.fieldOf("disable_repair_xp_cost").forGetter(EnchantmentsConfig::disableRepairXpCost), (App)Codec.BOOL.fieldOf("disable_glint").forGetter(EnchantmentsConfig::disableGlint), (App)Codec.BOOL.fieldOf("display_xp_level_over_bar").forGetter(EnchantmentsConfig::showLevelNumber), (App)Codec.BOOL.optionalFieldOf("disenchant_chiseled_bookshelf_books").forGetter(EnchantmentsConfig::disenchantChiseledBookshelfBooks), (App)Codec.BOOL.optionalFieldOf("filter_structure_chiseled_bookshelves").forGetter(EnchantmentsConfig::filterStructureChiseledBookshelves), (App)ENCHANTMENT_SET_CODEC.fieldOf("unselectable_enchantments").forGetter(config -> config.unobtainableEnchantments), (App)ENCHANTMENT_SET_CODEC.fieldOf("disabled_enchantments").forGetter(config -> config.disabledEnchantments), (App)Codec.unboundedMap((Codec)class_7923.field_41178.method_39673(), ENCHANTMENT_MAP_CODEC).fieldOf("intrinsic_enchantments").forGetter(config -> config.itemEnchantments)).apply((Applicative)instance, EnchantmentsConfig::new));

        public EnchantmentsConfig() {
            this(true, true, true, true, false, Optional.of(false), Optional.of(true), UnruffledMod.DEFAULT_UNOBTAINABLE_ENCHANTMENTS, UnruffledMod.DEFAULT_DISABLED_ENCHANTMENTS, UnruffledMod.DEFAULT_ITEM_ENCHANTMENTS);
        }
    }

    public record ElytraConfig(double horizontalGlidingSpeedFactor, double verticalGlidingSpeedFactor, boolean disableRocketSpeedChanges, double minRocketSpeed, double horizontalRocketSpeedReduction) {
        public static final Codec<ElytraConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("gliding_speed_horizontal_factor").forGetter(ElytraConfig::horizontalGlidingSpeedFactor), (App)Codec.DOUBLE.fieldOf("gliding_speed_vertical_factor").forGetter(ElytraConfig::verticalGlidingSpeedFactor), (App)Codec.BOOL.fieldOf("rocket_speed_disable_changes").forGetter(ElytraConfig::disableRocketSpeedChanges), (App)Codec.DOUBLE.fieldOf("rocket_speed_minimum_factor").forGetter(ElytraConfig::minRocketSpeed), (App)Codec.DOUBLE.fieldOf("rocket_speed_horizontal_reduction").forGetter(ElytraConfig::horizontalRocketSpeedReduction)).apply((Applicative)instance, ElytraConfig::new));

        public ElytraConfig() {
            this(0.97, 0.96, false, 0.04, 5.0);
        }
    }

    public record MechanicsConfig(boolean peacefulChunks, int sleepTime, int backupSpawnPoints, float dropSpreadFactor, boolean disableTotemOfUndying, boolean evokerDropsEvilTotem, boolean badOmenFromEvilTotem, boolean badOmenFromCaptain, boolean evilTotemBinding, int bundleSize, int wanderingSpawnFrequency, boolean zombiesDontTargetVillagers) {
        public static final Codec<MechanicsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("no_hostile_mobs_around_spawn_beds").forGetter(config -> config.peacefulChunks), (App)Codec.INT.fieldOf("sleep_time___set_to_negative_to_disable").forGetter(config -> config.sleepTime), (App)Codec.INT.optionalFieldOf("backup_spawn_points", (Object)3).forGetter(config -> config.backupSpawnPoints), (App)Codec.FLOAT.fieldOf("drop_spread_factor").forGetter(config -> Float.valueOf(config.dropSpreadFactor)), (App)Codec.BOOL.fieldOf("disable_totem_of_undying").forGetter(config -> config.disableTotemOfUndying), (App)Codec.BOOL.fieldOf("evil_totem_dropped_by_evoker").forGetter(config -> config.evokerDropsEvilTotem), (App)Codec.BOOL.fieldOf("evil_totem_bad_omen").forGetter(config -> config.badOmenFromEvilTotem), (App)Codec.BOOL.fieldOf("illager_captain_gives_bad_omen").forGetter(config -> config.badOmenFromCaptain), (App)Codec.BOOL.fieldOf("evil_totem_binding").forGetter(config -> config.evilTotemBinding), (App)Codec.INT.fieldOf("bundle_size").forGetter(config -> config.bundleSize), (App)Codec.INT.fieldOf("wandering_trader_spawn_frequency").forGetter(config -> config.wanderingSpawnFrequency), (App)Codec.BOOL.fieldOf("disable_zombie_targeting_villagers").forGetter(config -> config.zombiesDontTargetVillagers)).apply((Applicative)instance, MechanicsConfig::new));

        public MechanicsConfig() {
            this(true, 16000, 10, 0.2f, true, true, true, false, true, 256, 3, true);
        }
    }

    public record WorldgenConfig(float structureSpreadFactor, float structureSpreadCorrection, boolean disableOreVeins) {
        public static final Codec<WorldgenConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("structure_spread_factor").forGetter(config -> Float.valueOf(config.structureSpreadFactor)), (App)Codec.FLOAT.fieldOf("structure_spread_correction").forGetter(config -> Float.valueOf(config.structureSpreadCorrection)), (App)Codec.BOOL.fieldOf("disable_large_ore_veins").forGetter(config -> config.disableOreVeins)).apply((Applicative)instance, WorldgenConfig::new));

        public WorldgenConfig() {
            this(3.0f, 64.0f, true);
        }
    }

    public record LootConfig(Map<class_2960, List<Integer>> lootCodicesAdd, Map<class_2960, List<Integer>> lootCodicesModify, Map<class_2960, List<Integer>> assortedPotionsAdd) {
        public static final Codec<LootConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)new ListCodec(class_5699.method_48766((int)1, (int)50))).fieldOf("ancient_codices_numbers_chest").forGetter(config -> config.lootCodicesAdd), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)new ListCodec(class_5699.method_48766((int)1, (int)50))).fieldOf("ancient_codices_numbers_archaeology").forGetter(config -> config.lootCodicesModify), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)new ListCodec(class_5699.field_33441)).fieldOf("assorted_potions_chest").forGetter(config -> config.assortedPotionsAdd)).apply((Applicative)instance, LootConfig::new));

        public LootConfig() {
            this(UnruffledMod.DEFAULT_LOOT_CODICES_ADD, UnruffledMod.DEFAULT_LOOT_CODICES_MODIFY, UnruffledMod.DEFAULT_ASSORTED_POTIONS_ADD);
        }
    }

    public record StackSizeConfig(int foodStackSize, Map<class_1792, Integer> itemStackSize) {
        public static final Codec<StackSizeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("food").forGetter(config -> config.foodStackSize), (App)Codec.unboundedMap((Codec)class_7923.field_41178.method_39673(), (Codec)Codec.INT).fieldOf("items").forGetter(config -> config.itemStackSize)).apply((Applicative)instance, StackSizeConfig::new));

        public StackSizeConfig() {
            this(16, Map.of(class_1802.field_8511, 64, class_1802.field_8680, 64, class_1802.field_8323, 64, class_1802.field_8233, 64, class_1802.field_8551, 64, class_1802.field_8574, 16));
        }
    }

    public record NavigationConfig(boolean forceReducedDebugInfo, boolean reducedDebugFacing, boolean reducedDebugBiome, int maxMapSize, boolean recoveryCompassLocking, boolean compassPointsNorth, boolean compassToggleSpawn) {
        public static final Codec<NavigationConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("force_reduced_debug_info_in_survival").forGetter(config -> config.forceReducedDebugInfo), (App)Codec.BOOL.fieldOf("show_facing_when_force_reduce_debug").forGetter(config -> config.reducedDebugFacing), (App)Codec.BOOL.fieldOf("show_biome_when_force_reduce_debug").forGetter(config -> config.reducedDebugBiome), (App)Codec.INT.fieldOf("max_map_size").forGetter(config -> config.maxMapSize), (App)Codec.BOOL.fieldOf("recovery_compass_locking").forGetter(config -> config.recoveryCompassLocking), (App)Codec.BOOL.fieldOf("compass_points_north").forGetter(config -> config.compassPointsNorth), (App)Codec.BOOL.fieldOf("compass_points_north_toggle_spawn").forGetter(config -> config.compassToggleSpawn)).apply((Applicative)instance, NavigationConfig::new));

        public NavigationConfig() {
            this(false, true, true, 4, true, false, true);
        }
    }

    public record PotionsConfig(boolean canTeleportMobs, float potionDurationFactor, List<BrewingPotionRecipe> recipes) {
        public static final Codec<PotionsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("can_teleport_mobs").forGetter(config -> config.canTeleportMobs), (App)Codec.FLOAT.fieldOf("duration_multiplier").forGetter(config -> Float.valueOf(config.potionDurationFactor)), (App)BrewingPotionRecipe.CODEC.listOf().fieldOf("added_recipes").forGetter(config -> config.recipes)).apply((Applicative)instance, PotionsConfig::new));

        public PotionsConfig() {
            this(true, 2.0f, UnruffledMod.POTION_RECIPES);
        }
    }
}

