/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.interfaces;

import io.github.orlouge.unruffled.config.Config;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2874;
import net.minecraft.class_3545;
import net.minecraft.class_5134;

public interface ExtendedHungerManager {
    default public float getAttackExhaustion(class_1657 player, float cooldownProgress) {
        double attackSpeed = player.method_26825(class_5134.field_23723);
        cooldownProgress = (float)Math.pow(cooldownProgress, 2.5);
        return (float)Math.min(6.0, Math.max(0.02, (double)(((Config)Config.INSTANCE.method_15332()).hungerConfig.attackExhaustionFactor() * 20.0f * this.getStaminaRegenerationRate(0.0f)) / ((double)cooldownProgress * attackSpeed * (double)this.getStaminaDepletionRate())));
    }

    public static boolean canAttack(class_1657 player, float stamina) {
        class_1702 class_17022 = player.method_7344();
        if (class_17022 instanceof ExtendedHungerManager) {
            ExtendedHungerManager ext = (ExtendedHungerManager)class_17022;
            float cooldown = player.method_7261(0.5f);
            return cooldown >= 1.0f && ((Config)Config.INSTANCE.method_15332()).hungerConfig.attackAlwaysAllowInTime() || stamina > ext.getAttackExhaustion(player, cooldown) * ext.getStaminaDepletionRate();
        }
        return true;
    }

    default public float getStaminaRegenerationRate(float weariness) {
        return (1.0f - (float)Math.tanh((double)weariness * 1.8) * 0.9f) * ((Config)Config.INSTANCE.method_15332()).hungerConfig.staminaRegenerationRate();
    }

    default public float getTargetWeariness() {
        float malus = this.getWearinessMalus();
        return Math.max(0.0f, Math.min(1.0f, (float)Math.tanh(2.0f * this.getBaseWeariness() * (1.0f + 0.5f * malus)) + 0.4f * malus));
    }

    default public float getWearinessMalus() {
        return Math.max(0.0f, Math.min(1.0f, 1.0f - 1.0f / this.getWeight() + 1.0f - Math.min(Math.min(this.getHealth(), this.getFoodLevel()) + 1.0f, 10.0f) / 10.0f + (this.getDimension() != null && !this.getDimension().comp_648() || this.isNight() || this.isUnderground() ? 0.4f : 0.0f)));
    }

    public class_2874 getDimension();

    public float getHealth();

    public float getFoodLevel();

    public float getBaseWeariness();

    public float getAmortizedWeariness();

    public float getStamina();

    public boolean isNight();

    public boolean isUnderground();

    default public float getStaminaDepletionRate() {
        return ((Config)Config.INSTANCE.method_15332()).hungerConfig.staminaDepletionRate();
    }

    default public float getStaminaHungerMultiplier(class_243 travelAmount) {
        float travelPenalty = Math.min((float)travelAmount.method_1033() * ((Config)Config.INSTANCE.method_15332()).hungerConfig.travelPenaltyFactor(), ((Config)Config.INSTANCE.method_15332()).hungerConfig.maxTravelPenalty());
        return ((Config)Config.INSTANCE.method_15332()).hungerConfig.hungerDepletionRate() + Math.max(travelPenalty, this.getAmortizedWeariness());
    }

    public void addStamina(float var1);

    public void addWeariness(float var1);

    public void resetWeariness();

    default public void addStaminaIfCanAttack(float diff, class_1657 player) {
        if (diff >= 0.0f) {
            this.addStamina(diff);
            return;
        }
        float allowedSubtraction = Math.min(0.0f, this.minStaminaToAttack(player) - this.getStamina());
        this.addStamina(Math.max(diff, allowedSubtraction));
    }

    default public float minStaminaToAttack(class_1657 player) {
        return this.getAttackExhaustion(player, 1.0f) * this.getStaminaDepletionRate();
    }

    public float getWeight();

    default public class_3545<Float, Float> calculateWeight(class_1657 player) {
        class_1661 inv = player.method_31548();
        class_3545<Float, Boolean> inventoryWeight = ExtendedHungerManager.getInventoryWeight((class_1263)inv, false);
        float weight = ((Float)inventoryWeight.method_15442()).floatValue() / (float)inv.method_5439();
        float echestWeight = 0.0f;
        if (((Boolean)inventoryWeight.method_15441()).booleanValue()) {
            class_1730 inv2 = player.method_7274();
            echestWeight = ((Float)ExtendedHungerManager.getInventoryWeight((class_1263)inv2, true).method_15442()).floatValue() / (float)inv2.method_5439();
            weight += echestWeight;
        }
        return new class_3545((Object)Float.valueOf(Math.max(1.0f, weight * weight * ((Config)Config.INSTANCE.method_15332()).hungerConfig.inventoryWeightPenaltyFactor())), (Object)Float.valueOf(echestWeight / weight));
    }

    private static class_3545<Float, Boolean> getInventoryWeight(class_1263 inventory, boolean isEnderChest) {
        float weight = 0.0f;
        boolean hasContainers = false;
        boolean hasEnderChest = false;
        for (int j = 0; j < inventory.method_5439(); ++j) {
            class_1799 item = inventory.method_5438(j);
            class_3545<Float, Boolean> itemWeight = ExtendedHungerManager.getItemWeight(item);
            weight += ((Float)itemWeight.method_15442()).floatValue();
            if (((Float)itemWeight.method_15442()).floatValue() > 1.0f) {
                hasContainers = true;
            }
            hasEnderChest |= ((Boolean)itemWeight.method_15441()).booleanValue();
        }
        return new class_3545((Object)Float.valueOf(hasContainers || hasEnderChest || isEnderChest ? weight : 0.0f), (Object)hasEnderChest);
    }

    private static class_3545<Float, Boolean> getNbtWeight(class_2487 nbt) {
        float weight = 0.0f;
        boolean hasEnderChest = false;
        for (String key : nbt.method_10541()) {
            if (key.equals("Items") && nbt.method_10540("Items") == 9) {
                class_2499 itemList = nbt.method_10554("Items", 10);
                for (class_2520 el : itemList) {
                    class_1799 itemStack;
                    if (el.method_10711() != 10 || (itemStack = class_1799.method_7915((class_2487)((class_2487)el))) == null) continue;
                    class_3545<Float, Boolean> subWeight = ExtendedHungerManager.getItemWeight(itemStack);
                    weight += ((Float)subWeight.method_15442()).floatValue();
                    hasEnderChest |= ((Boolean)subWeight.method_15441()).booleanValue();
                }
                continue;
            }
            class_2520 sub = nbt.method_10580(key);
            if (sub == null || sub.method_10711() != 10) continue;
            class_3545<Float, Boolean> subWeight = ExtendedHungerManager.getNbtWeight((class_2487)sub);
            weight += ((Float)subWeight.method_15442()).floatValue();
            hasEnderChest |= ((Boolean)subWeight.method_15441()).booleanValue();
        }
        return new class_3545((Object)Float.valueOf(weight), (Object)hasEnderChest);
    }

    private static class_3545<Float, Boolean> getItemWeight(class_1799 itemStack) {
        boolean hasEnderChest = itemStack.method_31574(class_1802.field_8466);
        float weight = (float)itemStack.method_7947() / (float)itemStack.method_7914();
        if (itemStack.method_7985()) {
            class_3545<Float, Boolean> containerWeight = ExtendedHungerManager.getNbtWeight(itemStack.method_7969());
            if (((Float)containerWeight.method_15442()).floatValue() > 0.0f) {
                weight += ((Float)containerWeight.method_15442()).floatValue() + 1.0f;
            }
            hasEnderChest |= ((Boolean)containerWeight.method_15441()).booleanValue();
        }
        return new class_3545((Object)Float.valueOf(weight), (Object)hasEnderChest);
    }
}

