/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.block.entity.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mebahel.antiquebeasts.block.screenhandlers.DraugrChestScreenHandler;
import net.mebahel.antiquebeasts.util.packet.ChestOpenSync;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public abstract class BaseChestBlockEntity
extends class_2595
implements GeoBlockEntity,
ExtendedScreenHandlerFactory {
    protected final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean spawnAnimationPlaying = false;
    public boolean isOpened = false;
    public boolean hasBeenOpened = false;
    public boolean shouldDoSpawnAnimation = false;
    public int closeCooldown = 0;
    public int age = 0;
    protected int viewerCount = 0;
    protected int viewers = 0;
    public final Map<UUID, class_2371<class_1799>> personalLoots = new HashMap<UUID, class_2371<class_1799>>();
    protected final Set<UUID> generatedLootPlayers = new HashSet<UUID>();
    @Nullable
    protected class_2960 baseLootTableId;
    @Nullable
    protected class_2960 customLootTableId = null;
    private final int chestSize;

    protected BaseChestBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int chestSize) {
        super(type, pos, state);
        this.chestSize = chestSize;
        this.method_11281(class_2371.method_10213((int)chestSize, (Object)class_1799.field_8037));
    }

    protected abstract class_2561 getChestTitle();

    protected abstract String getLogPrefix();

    public boolean isSharedChest() {
        return this.baseLootTableId == null && this.field_12037 == null;
    }

    public void handlePlayerLoot(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        UUID id = player.method_5667();
        if (this.baseLootTableId == null && this.field_12037 == null) {
            this.personalLoots.put(id, (class_2371<class_1799>)this.method_11282());
            return;
        }
        if (!this.generatedLootPlayers.contains(id)) {
            this.generateLootFor(player);
            this.generatedLootPlayers.add(id);
            this.method_5431();
        }
        class_2371<class_1799> loot = this.personalLoots.get(id);
    }

    private void generateLootFor(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (this.baseLootTableId == null) {
            if (this.field_12037 == null) {
                return;
            }
            this.baseLootTableId = this.field_12037;
            this.field_12037 = null;
            this.method_5431();
        }
        class_52 lootTable = serverWorld.method_8503().method_3857().getLootTable(this.baseLootTableId);
        long seed = this.field_11863.method_8510() ^ player.method_5667().getMostSignificantBits() ^ this.field_11867.method_10063() ^ this.field_11863.field_9229.method_43055();
        class_8567.class_8568 paramBuilder = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_51874(class_181.field_1226, (Object)player);
        class_8567 lootContext = paramBuilder.method_51875(class_173.field_1179);
        class_1277 tempInventory = new class_1277(this.method_5439());
        lootTable.method_329((class_1263)tempInventory, lootContext, seed);
        class_2371 loot = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = tempInventory.method_5438(i);
            if (stack.method_7960()) continue;
            loot.set(i, (Object)stack.method_7972());
        }
        this.personalLoots.put(player.method_5667(), (class_2371<class_1799>)loot);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "openController", 0, this::openPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spawnController", 0, this::spawnPredicate)});
    }

    private <T extends GeoAnimatable> PlayState openPredicate(AnimationState<T> event) {
        AnimationController controller = event.getController();
        if (this.shouldDoSpawnAnimation) {
            return PlayState.STOP;
        }
        if (this.isOpened) {
            controller.setAnimation(RawAnimation.begin().then("open", Animation.LoopType.PLAY_ONCE).then("isOpened", Animation.LoopType.LOOP));
        } else if (this.hasBeenOpened) {
            controller.setAnimation(RawAnimation.begin().then("close", Animation.LoopType.PLAY_ONCE).then("isClosed", Animation.LoopType.LOOP));
        } else {
            controller.setAnimation(RawAnimation.begin().then("isClosed", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState spawnPredicate(AnimationState<T> event) {
        AnimationController controller = event.getController();
        if (this.shouldDoSpawnAnimation && !this.spawnAnimationPlaying) {
            this.spawnAnimationPlaying = true;
            controller.forceAnimationReset();
            controller.setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE));
        }
        if (this.spawnAnimationPlaying) {
            if (controller.getAnimationState() != AnimationController.State.STOPPED) {
                this.spawnChestParticles();
            }
            if (controller.hasAnimationFinished()) {
                this.spawnAnimationPlaying = false;
                this.shouldDoSpawnAnimation = false;
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void serverTick() {
        if (this.viewerCount <= 0 && this.isOpened) {
            --this.closeCooldown;
            if (this.closeCooldown <= 0) {
                this.isOpened = false;
                this.hasBeenOpened = false;
                this.method_5431();
            }
        }
        if (this.shouldDoSpawnAnimation) {
            this.shouldDoSpawnAnimation = false;
            this.method_5431();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void clientTick() {
        ++this.age;
        if (this.age < 10) {
            this.hasBeenOpened = false;
        }
        if (this.closeCooldown > 0) {
            --this.closeCooldown;
        }
    }

    public void sync() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    protected class_2561 method_17823() {
        return this.getChestTitle();
    }

    public int method_5439() {
        return this.chestSize;
    }

    @Environment(value=EnvType.CLIENT)
    public int countViewers() {
        return this.viewerCount;
    }

    public void method_5435(class_1657 player) {
        int oldViewers;
        if (this.field_11863.field_9236) {
            return;
        }
        if (player.method_7325()) {
            return;
        }
        if ((oldViewers = this.viewers++) == 0) {
            this.isOpened = true;
            this.hasBeenOpened = true;
            this.method_5431();
            ChestOpenSync.sendToAll((class_3218)this.field_11863, this.field_11867, true);
        }
    }

    public void method_5432(class_1657 player) {
        int oldViewers;
        if (this.field_11863.field_9236) {
            return;
        }
        if (player.method_7325()) {
            return;
        }
        if ((oldViewers = this.viewers--) == 1) {
            this.isOpened = false;
            this.method_5431();
            ChestOpenSync.sendToAll((class_3218)this.field_11863, this.field_11867, false);
        }
        if (this.viewers < 0) {
            this.viewers = 0;
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("LootTable", 8) && !tag.method_10558("LootTable").isEmpty()) {
            class_2960 vanillaLoot = new class_2960(tag.method_10558("LootTable"));
            if (this.customLootTableId == null) {
                this.customLootTableId = vanillaLoot;
            }
        }
        if (tag.method_10573("CustomLootTable", 8)) {
            this.customLootTableId = new class_2960(tag.method_10558("CustomLootTable"));
        }
        this.isOpened = tag.method_10577("isOpened");
        this.hasBeenOpened = tag.method_10577("hasBeenOpened");
        this.shouldDoSpawnAnimation = tag.method_10577("shouldDoSpawnAnimation");
        this.closeCooldown = tag.method_10550("closeCooldown");
        this.viewerCount = tag.method_10550("viewers");
        this.generatedLootPlayers.clear();
        class_2499 list = tag.method_10554("GeneratedLootPlayers", 8);
        for (int i = 0; i < list.size(); ++i) {
            this.generatedLootPlayers.add(UUID.fromString(list.method_10608(i)));
        }
        if (tag.method_10573("BaseLootTable", 8)) {
            this.baseLootTableId = new class_2960(tag.method_10558("BaseLootTable"));
        }
        if (tag.method_10573("PersonalLoots", 9)) {
            class_2499 lootsList = tag.method_10554("PersonalLoots", 10);
            for (int i = 0; i < lootsList.size(); ++i) {
                class_2487 playerLootTag = lootsList.method_10602(i);
                UUID playerId = UUID.fromString(playerLootTag.method_10558("Player"));
                class_2371 items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
                if (playerLootTag.method_10573("Items", 10)) {
                    class_1262.method_5429((class_2487)playerLootTag.method_10562("Items"), (class_2371)items);
                }
                this.personalLoots.put(playerId, (class_2371<class_1799>)items);
            }
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.customLootTableId != null) {
            tag.method_10582("CustomLootTable", this.customLootTableId.toString());
        }
        tag.method_10556("isOpened", this.isOpened);
        tag.method_10556("hasBeenOpened", this.hasBeenOpened);
        tag.method_10556("shouldDoSpawnAnimation", this.shouldDoSpawnAnimation);
        tag.method_10569("closeCooldown", this.closeCooldown);
        tag.method_10569("viewers", this.viewerCount);
        class_2499 list = new class_2499();
        for (UUID id : this.generatedLootPlayers) {
            list.add((Object)class_2519.method_23256((String)id.toString()));
        }
        tag.method_10566("GeneratedLootPlayers", (class_2520)list);
        if (this.baseLootTableId != null) {
            tag.method_10582("BaseLootTable", this.baseLootTableId.toString());
        }
        class_2499 lootsList = new class_2499();
        for (Map.Entry<UUID, class_2371<class_1799>> entry : this.personalLoots.entrySet()) {
            class_2487 playerLootTag = new class_2487();
            playerLootTag.method_10582("Player", entry.getKey().toString());
            class_2487 itemsTag = new class_2487();
            class_1262.method_5426((class_2487)itemsTag, entry.getValue());
            playerLootTag.method_10566("Items", (class_2520)itemsTag);
            lootsList.add((Object)playerLootTag);
        }
        tag.method_10566("PersonalLoots", (class_2520)lootsList);
    }

    public void setShouldDoSpawnAnimation(boolean value) {
        this.shouldDoSpawnAnimation = value;
        this.method_5431();
        this.sync();
    }

    public class_2371<class_1799> getInternalInventory() {
        return this.method_11282();
    }

    @Environment(value=EnvType.CLIENT)
    public void playChestSound(class_3414 soundEvent) {
        if (this.field_11863 == null) {
            return;
        }
        double x = (double)this.field_11867.method_10263() + 0.5;
        double y = (double)this.field_11867.method_10264() + 0.5;
        double z = (double)this.field_11867.method_10260() + 0.5;
        this.field_11863.method_8486(x, y, z, soundEvent, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f, false);
    }

    @Environment(value=EnvType.CLIENT)
    public void playOpenSound() {
        this.playChestSound(class_3417.field_14982);
    }

    @Environment(value=EnvType.CLIENT)
    public void playCloseSound() {
        this.playChestSound(class_3417.field_14823);
    }

    public void spawnChestParticles() {
        double posX = (double)this.field_11867.method_10263() + 0.5;
        double posY = this.field_11867.method_10264();
        double posZ = (double)this.field_11867.method_10260() + 0.5;
        class_2338 blockPos = this.field_11867.method_10074();
        class_2680 blockState = this.field_11863.method_8320(blockPos);
        if (!blockState.method_26215()) {
            for (int i = 0; i < 6; ++i) {
                double offsetX = (this.field_11863.field_9229.method_43058() - 0.5) * 0.3;
                double offsetZ = (this.field_11863.field_9229.method_43058() - 0.5) * 0.3;
                double velocityY = 0.15;
                this.field_11863.method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), posX + offsetX, posY, posZ + offsetZ, 0.0, velocityY, 0.0);
            }
        }
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    public class_2561 method_5476() {
        return this.getChestTitle();
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        class_2371 loot = this.personalLoots.get(player.method_5667());
        if (loot == null) {
            loot = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
            this.personalLoots.put(player.method_5667(), (class_2371<class_1799>)loot);
        }
        return new DraugrChestScreenHandler(syncId, playerInventory, (class_2371<class_1799>)loot, this.field_11867);
    }

    public ExtendedScreenHandlerFactory createPersonalScreenHandlerFactory(final class_1657 player) {
        return new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 serverPlayer, class_2540 buf) {
                buf.method_10807(BaseChestBlockEntity.this.method_11016());
            }

            public class_2561 method_5476() {
                return BaseChestBlockEntity.this.getChestTitle();
            }

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
                if (BaseChestBlockEntity.this.isSharedChest()) {
                    return new DraugrChestScreenHandler(syncId, playerInventory, (class_2586)BaseChestBlockEntity.this);
                }
                class_2371 loot = BaseChestBlockEntity.this.personalLoots.get(player.method_5667());
                if (loot == null) {
                    loot = class_2371.method_10213((int)BaseChestBlockEntity.this.method_5439(), (Object)class_1799.field_8037);
                    BaseChestBlockEntity.this.personalLoots.put(player.method_5667(), (class_2371<class_1799>)loot);
                }
                return new DraugrChestScreenHandler(syncId, playerInventory, (class_2371<class_1799>)loot, BaseChestBlockEntity.this.method_11016());
            }
        };
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_39026((class_2586)this, class_2586::method_16887);
    }

    public void method_5431() {
        super.method_5431();
    }

    public boolean hasLootTable() {
        return this.baseLootTableId != null || this.field_12037 != null;
    }

    @Nullable
    public class_2960 getBaseLootTableId() {
        if (this.baseLootTableId != null) {
            return this.baseLootTableId;
        }
        return this.field_12037;
    }
}

