/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.ai.dwarven.dwarven_spider;

import java.util.Arrays;
import java.util.List;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerSpiderEntity;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class MineOreGoal
extends class_1352 {
    private final DwemerSpiderEntity spider;
    private class_2338 targetOre = null;
    private int miningTime = 0;
    private boolean miningFished = false;
    private static final int MINING_DURATION = 180;
    private static final int MINING_COOLDOWN = 800;
    private static final List<class_2248> ORES = Arrays.asList(class_2246.field_10212, class_2246.field_10571, class_2246.field_10442, class_2246.field_10013, class_2246.field_10090, class_2246.field_10080, class_2246.field_29027, class_2246.field_29026, class_2246.field_29029, class_2246.field_29220, class_2246.field_29028, class_2246.field_29030, class_2246.field_27120, class_2246.field_29221, class_2246.field_10213, class_2246.field_23077, class_2246.field_10418, class_2246.field_29219);

    public MineOreGoal(DwemerSpiderEntity spider) {
        this.spider = spider;
    }

    public boolean method_6264() {
        if (((Boolean)this.spider.method_5841().method_12789(DwemerSpiderEntity.IS_MINING)).booleanValue() || (Integer)this.spider.method_5841().method_12789(DwemerSpiderEntity.MINING_COOLDOWN) > 0) {
            return false;
        }
        if (this.spider.method_5968() != null) {
            return false;
        }
        this.targetOre = this.findNearbyOre();
        return this.targetOre != null;
    }

    public void method_6269() {
        if (this.targetOre != null) {
            class_2338 bestPosition = this.findBestMiningPosition(this.targetOre);
            this.spider.method_5942().method_6337((double)bestPosition.method_10263(), (double)bestPosition.method_10264(), (double)bestPosition.method_10260(), 1.0);
            this.miningTime = 0;
        }
    }

    public boolean method_6266() {
        return this.miningTime <= 180 && this.spider.method_5968() == null && !this.miningFished;
    }

    public void method_6268() {
        if (this.targetOre == null || !this.isStillOre(this.targetOre)) {
            this.miningFished = true;
            return;
        }
        class_2338 bestPosition = this.findBestMiningPosition(this.targetOre);
        double distance = this.spider.method_19538().method_1022(bestPosition.method_46558());
        if (!this.spider.method_5942().method_6357()) {
            return;
        }
        if (distance < 1.5) {
            this.spider.method_5988().method_20248((double)this.targetOre.method_10263() + 0.5, (double)this.targetOre.method_10264() + 0.5, (double)this.targetOre.method_10260() + 0.5);
            if (!((Boolean)this.spider.method_5841().method_12789(DwemerSpiderEntity.IS_MINING)).booleanValue()) {
                this.spider.method_5841().method_12778(DwemerSpiderEntity.IS_MINING, (Object)true);
                this.miningTime = 0;
            }
            ++this.miningTime;
            if (this.miningTime % 7 == 0) {
                this.spawnMiningParticles(this.targetOre);
                this.spider.method_37908().method_8396(null, this.targetOre, class_3417.field_15026, class_3419.field_15245, 0.5f, 1.0f);
            }
            int breakProgress = (int)((float)this.miningTime / 180.0f * 10.0f);
            this.spider.method_37908().method_8517(this.spider.method_5628(), this.targetOre, breakProgress);
            if (this.miningTime >= 180) {
                this.spider.collectDroppedItems(this.targetOre);
                this.spider.method_37908().method_22352(this.targetOre, false);
                this.miningFished = true;
            }
        }
    }

    private boolean isStillOre(class_2338 pos) {
        class_1937 world = this.spider.method_37908();
        class_2248 block = world.method_8320(pos).method_26204();
        return ORES.contains(block);
    }

    public void method_6270() {
        this.spider.method_5841().method_12778(DwemerSpiderEntity.IS_MINING, (Object)false);
        this.spider.method_5841().method_12778(DwemerSpiderEntity.MINING_COOLDOWN, (Object)800);
        this.miningFished = false;
        this.targetOre = null;
        this.miningTime = 0;
    }

    private class_2338 findNearbyOre() {
        class_2338 spiderPos = this.spider.method_24515();
        class_1937 world = this.spider.method_37908();
        for (class_2338 pos : class_2338.method_25996((class_2338)spiderPos, (int)10, (int)3, (int)10)) {
            if (!this.isOreExposed(world, pos)) continue;
            return pos;
        }
        return null;
    }

    private boolean isOreExposed(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        if (!ORES.contains(block)) {
            return false;
        }
        for (class_2338 neighbor : new class_2338[]{pos.method_10084(), pos.method_10074(), pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067()}) {
            if (!world.method_8320(neighbor).method_26215()) continue;
            return true;
        }
        return false;
    }

    private void spawnMiningParticles(class_2338 pos) {
        class_1937 world = this.spider.method_37908();
        if (world.field_9236) {
            return;
        }
        class_2680 blockState = world.method_8320(pos);
        for (int i = 0; i < 5; ++i) {
            double offsetX = (Math.random() - 0.5) * 0.6;
            double offsetY = (Math.random() - 0.5) * 0.6;
            double offsetZ = (Math.random() - 0.5) * 0.6;
            ((class_3218)world).method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), (double)pos.method_10263() + 0.5 + offsetX, (double)pos.method_10264() + 0.5 + offsetY, (double)pos.method_10260() + 0.5 + offsetZ, 5, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private class_2338 findBestMiningPosition(class_2338 orePos) {
        class_1937 world = this.spider.method_37908();
        class_2338 bestPos = null;
        double bestDistance = Double.MAX_VALUE;
        for (class_2338 neighbor : new class_2338[]{orePos.method_10095(), orePos.method_10072(), orePos.method_10078(), orePos.method_10067(), orePos.method_10095().method_10084(), orePos.method_10072().method_10084(), orePos.method_10078().method_10084(), orePos.method_10067().method_10084(), orePos.method_10095().method_10074(), orePos.method_10072().method_10074(), orePos.method_10078().method_10074(), orePos.method_10067().method_10074()}) {
            double distance;
            if (!world.method_8320(neighbor.method_10074()).method_26212((class_1922)world, neighbor.method_10074()) || !world.method_8320(neighbor).method_26215() || !((distance = neighbor.method_19770((class_2374)this.spider.method_19538())) < bestDistance)) continue;
            bestPos = neighbor;
            bestDistance = distance;
        }
        return bestPos != null ? bestPos : orePos.method_10084();
    }
}

