/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.ai.other;

import java.util.EnumSet;
import java.util.Objects;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrOverlordEntity;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class DraugrOverlordMeleeAttackGoal
extends class_1352 {
    protected final DraugrOverlordEntity mob;
    private final double speed;
    private int cooldown;
    private boolean hasDashed = false;
    private final double originalSpeed = 0.3;
    private AttackType currentAttack = AttackType.NONE;
    private AttackType nextAttack = AttackType.NONE;
    private static final int ATTACK_RANGE = 12;
    private static final int RUSH_DURATION = 50;
    private static final int DOUBLE_DURATION = 70;
    private static final int TRIPLE_DURATION = 80;
    private static final int RUSH_DASH_TICK = 22;
    private static final int DOUBLE_HIT_T1 = 20;
    private static final int DOUBLE_HIT_T2 = 40;
    private static final int TRIPLE_HIT_T1 = 16;
    private static final int TRIPLE_HIT_T2 = 41;
    private static final int TRIPLE_HIT_T3 = 60;
    private int distanceTickCounter = 0;
    private static final int RUSH_TRIGGER_TICKS = 90;
    private static final double RUSH_MIN_RANGE = 5.0;
    private static final double RUSH_MAX_RANGE = 16.0;

    public DraugrOverlordMeleeAttackGoal(DraugrOverlordEntity mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1657 player;
        if (this.mob.getSpecial() || this.mob.getSpecialCooldown() < 35) {
            return false;
        }
        class_1309 target = this.mob.method_5968();
        if (target instanceof class_1657 && ((player = (class_1657)target).method_7337() || player.method_7325())) {
            return false;
        }
        return target != null && target.method_5805();
    }

    public boolean method_6266() {
        class_1657 player;
        if (this.mob.getSpecial() || this.mob.getSpecialCooldown() < 35) {
            return false;
        }
        class_1309 target = this.mob.method_5968();
        if (target instanceof class_1657 && ((player = (class_1657)target).method_7337() || player.method_7325())) {
            return false;
        }
        return target != null && target.method_5805();
    }

    public void method_6269() {
        this.mob.method_19540(true);
        this.hasDashed = false;
        this.cooldown = 0;
        this.mob.method_5942().method_6335((class_1297)this.mob.method_5968(), this.speed);
    }

    public void method_6270() {
        this.mob.method_19540(false);
        this.mob.setSwinging(false);
        this.hasDashed = false;
        this.currentAttack = AttackType.NONE;
        this.nextAttack = AttackType.NONE;
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.3);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 target = this.mob.method_5968();
        if (target != null && target.method_5805()) {
            this.mob.method_5988().method_6226((class_1297)target, 20.0f, 20.0f);
            this.handleAttack(target);
        } else {
            this.method_6270();
        }
    }

    private void handleAttack(class_1309 target) {
        this.cooldown = Math.max(this.cooldown - 1, 0);
        double distSq = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        double dist = Math.sqrt(distSq);
        if (dist > 5.0 && dist < 16.0) {
            ++this.distanceTickCounter;
            this.mob.method_37908().method_8421((class_1297)this.mob, (byte)14);
            if (this.distanceTickCounter >= 90 && !this.mob.isSwinging() && this.cooldown == 0) {
                this.currentAttack = AttackType.RUSH;
                this.startAttackAnimation();
                this.distanceTickCounter = 0;
                return;
            }
        } else {
            this.distanceTickCounter = 0;
        }
        if (!this.mob.isSwinging()) {
            if (distSq < 10.0 && this.cooldown == 0) {
                this.currentAttack = this.nextAttack != AttackType.NONE ? this.nextAttack : this.pickRandomAttack();
                this.startAttackAnimation();
            } else {
                this.mob.method_5942().method_6335((class_1297)target, this.speed);
            }
        } else {
            switch (this.currentAttack.ordinal()) {
                case 1: {
                    this.attackRush(target);
                    break;
                }
                case 2: 
                case 3: {
                    this.attackDouble(target);
                    break;
                }
                case 4: {
                    this.attackTriple(target);
                }
            }
        }
    }

    private void attackRush(class_1309 target) {
        int tick = this.mob.incrementAttackTick();
        this.freezeMovement();
        if (tick == 22 && !this.hasDashed) {
            this.dashToward(target, 3.0);
            int randomType = 1 + this.mob.method_6051().method_43048(2);
            this.playSwingSound(randomType);
            this.hasDashed = true;
        }
        if (tick == 27 && this.mob.method_5858((class_1297)target) <= 12.0) {
            target.method_6092(new class_1293(class_1294.field_5909, 80, 1));
            this.mob.method_6121((class_1297)target);
            this.performAoeAttack(target, 2.0, 0.7f);
        }
        if (tick >= 50) {
            this.endAttack();
        }
    }

    private void attackDouble(class_1309 target) {
        int tick = this.mob.incrementAttackTick();
        this.freezeMovement();
        if (tick == 16 || tick == 36) {
            this.dashToward(target, 1.4);
            int randomType = 1 + this.mob.method_6051().method_43048(2);
            this.playSwingSound(randomType);
        }
        if ((tick == 20 || tick == 40) && this.mob.method_5858((class_1297)target) <= 12.0) {
            this.mob.method_6121((class_1297)target);
            this.performAoeAttack(target, 2.0, 0.7f);
        }
        if (tick >= 70) {
            this.endAttack();
        }
    }

    private void attackTriple(class_1309 target) {
        int tick = this.mob.incrementAttackTick();
        this.freezeMovement();
        if (tick == 14 || tick == 39) {
            this.playSwingSound(3);
        } else if (tick == 58) {
            int randomType = 1 + this.mob.method_6051().method_43048(2);
            this.playSwingSound(randomType);
        }
        if (tick == 12 || tick == 37 || tick == 56) {
            this.dashToward(target, 1.4);
        }
        if ((tick == 16 || tick == 41 || tick == 60) && this.mob.method_5858((class_1297)target) <= 12.0) {
            this.mob.method_6121((class_1297)target);
            this.performAoeAttack(target, 2.0, 0.7f);
        }
        if (tick >= 80) {
            this.endAttack();
        }
    }

    private AttackType pickRandomAttack() {
        double r = Math.random();
        if (r < 0.3) {
            return AttackType.DOUBLE1;
        }
        if (r < 0.6) {
            return AttackType.DOUBLE2;
        }
        return AttackType.TRIPLE;
    }

    private void startAttackAnimation() {
        this.mob.resetAttackTick();
        this.mob.setSwinging(true);
        this.hasDashed = false;
        this.freezeMovement();
        this.nextAttack = this.pickRandomAttack();
        if (this.mob.method_6051().method_43048(4) == 0) {
            if (this.mob.method_6051().method_43056()) {
                this.mob.method_5783(ModSounds.DRAUGR_TAUNT_1, 1.0f, 1.0f);
            } else {
                this.mob.method_5783(ModSounds.DRAUGR_TAUNT_2, 1.0f, 1.0f);
            }
        }
        switch (this.currentAttack.ordinal()) {
            case 1: {
                this.mob.setAttackName("sl_attack_rush");
                this.mob.triggerAnim("attacking", this.mob.getAttackName());
                break;
            }
            case 2: {
                this.mob.setAttackName("sl_attack_double1");
                this.mob.triggerAnim("attacking", this.mob.getAttackName());
                break;
            }
            case 3: {
                this.mob.setAttackName("sl_attack_double2");
                this.mob.triggerAnim("attacking", this.mob.getAttackName());
                break;
            }
            case 4: {
                this.mob.setAttackName("sl_attack_triple");
                this.mob.triggerAnim("attacking", this.mob.getAttackName());
            }
        }
    }

    private void freezeMovement() {
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.0);
        this.mob.method_5942().method_6340();
    }

    private void endAttack() {
        this.mob.setSwinging(false);
        this.hasDashed = false;
        this.mob.resetAttackTick();
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.3);
        if (this.nextAttack == AttackType.NONE) {
            this.nextAttack = this.pickRandomAttack();
        }
        this.cooldown = 20;
        this.currentAttack = AttackType.NONE;
    }

    private void dashToward(class_1309 target, double basePower) {
        class_243 dir = target.method_19538().method_1020(this.mob.method_19538()).method_1029();
        float yaw = (float)(class_3532.method_15349((double)dir.field_1350, (double)dir.field_1352) * 57.29577951308232) - 90.0f;
        this.mob.method_36456(yaw);
        this.mob.method_5847(yaw);
        this.mob.method_5636(yaw);
        this.mob.field_5982 = yaw;
        this.mob.field_6220 = yaw;
        double dist = this.mob.method_5739((class_1297)target);
        double minDist = 6.0;
        double maxDist = 14.0;
        double minPower = basePower * 0.7;
        double maxPower = basePower * 2.2;
        double clamped = class_3532.method_15350((double)((dist - minDist) / (maxDist - minDist)), (double)0.0, (double)1.0);
        double scaledPower = class_3532.method_16436((double)clamped, (double)minPower, (double)maxPower);
        class_243 dash = new class_243((double)(-class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180)))) * scaledPower, 0.05, (double)class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180))) * scaledPower);
        this.mob.method_5762(dash.field_1352, dash.field_1351, dash.field_1350);
        this.mob.field_6007 = true;
        if (this.mob.method_37908().method_8608()) {
            this.mob.method_37908().method_8406((class_2394)class_2398.field_11205, this.mob.method_23317(), this.mob.method_23318() + 1.5, this.mob.method_23321(), 0.0, 0.2, 0.0);
        }
    }

    private void performAoeAttack(class_1309 mainTarget, double radius, float damageMultiplier) {
        class_1937 world = this.mob.method_37908();
        if (world.method_8608()) {
            return;
        }
        double baseDamage = this.mob.method_26825(class_5134.field_23721);
        float aoeDamage = (float)(baseDamage * (double)damageMultiplier);
        world.method_8333((class_1297)this.mob, mainTarget.method_5829().method_1014(radius), e -> {
            class_1309 le;
            return e instanceof class_1309 && (le = (class_1309)e).method_5805() && le != this.mob && le != mainTarget && !(e instanceof DraugrEntity);
        }).forEach(entity -> {
            class_1309 nearby = (class_1309)entity;
            nearby.method_5643(world.method_48963().method_48812((class_1309)this.mob), aoeDamage);
            class_243 push = nearby.method_19538().method_1020(this.mob.method_19538()).method_1029().method_1021(0.35);
            nearby.method_5762(push.field_1352, 0.15, push.field_1350);
            world.method_8406((class_2394)class_2398.field_11227, nearby.method_23317(), nearby.method_23323(0.5), nearby.method_23321(), 0.0, 0.05, 0.0);
        });
    }

    private void playSwingSound(int soundType) {
        class_3414 soundEvent = switch (soundType) {
            case 2 -> ModSounds.WEAPON_SWORD_SLASH_RING;
            case 3 -> ModSounds.WEAPON_SWORD_SLASH;
            default -> ModSounds.WEAPON_SWORD_IMPACT;
        };
        float pitch = 0.8f + this.mob.method_6051().method_43057() * 0.4f;
        float volume = 0.75f + this.mob.method_6051().method_43057() * 0.2f;
        this.mob.method_37908().method_43128(null, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), soundEvent, this.mob.method_5634(), volume, pitch);
    }

    private static enum AttackType {
        NONE,
        RUSH,
        DOUBLE1,
        DOUBLE2,
        TRIPLE;

    }
}

