/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.ai.other;

import java.util.EnumSet;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_5819;

public class HarpyFlyGoal
extends class_1352 {
    private final class_1314 harpy;
    private final double speed;
    private final int minAltitude;
    private final int maxAltitude;
    private class_243 targetPos;
    private final double targetThreshold = 1.5;
    private int idleTime = 0;
    private final int minIdleTime = 20;
    private final int maxIdleTime = 60;
    private boolean isIdle = false;

    public HarpyFlyGoal(class_1314 harpy, double speed, int minAltitude, int maxAltitude) {
        this.harpy = harpy;
        this.speed = speed;
        this.minAltitude = minAltitude;
        this.maxAltitude = maxAltitude;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        return this.harpy.method_5942().method_6357() && !this.isIdle;
    }

    public void method_6269() {
        if (this.isIdle) {
            return;
        }
        if (this.targetPos == null || this.harpy.method_19538().method_1022(this.targetPos) < this.targetThreshold) {
            this.targetPos = this.getRandomAirPosition();
            if (this.targetPos == null || (double)this.harpy.method_6051().method_43057() < 0.4) {
                this.enterIdleMode();
                return;
            }
        }
        if (this.targetPos != null) {
            class_243 direction = this.targetPos.method_1020(this.harpy.method_19538()).method_1029().method_1021(this.speed);
            this.harpy.method_18799(direction);
            this.harpy.method_5988().method_20248(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350);
            this.rotateTowardsTarget();
        }
    }

    public boolean method_6266() {
        if (this.isIdle) {
            return this.idleTime > 0;
        }
        return !this.harpy.method_5942().method_6357() && (this.targetPos == null || this.harpy.method_19538().method_1022(this.targetPos) >= this.targetThreshold);
    }

    public void method_6268() {
        super.method_6268();
        if (this.isIdle) {
            --this.idleTime;
            this.harpy.method_18799(class_243.field_1353);
            this.harpy.method_5988().method_20248(this.harpy.method_23317(), this.harpy.method_23318(), this.harpy.method_23321());
            if (this.idleTime <= 0) {
                this.isIdle = false;
            }
        } else {
            if (this.harpy.field_5976) {
                this.targetPos = this.getRandomAirPosition();
            }
            if (this.targetPos == null || this.harpy.method_19538().method_1022(this.targetPos) < this.targetThreshold) {
                this.targetPos = this.getRandomAirPosition();
            }
            if (this.targetPos != null) {
                class_243 direction = this.targetPos.method_1020(this.harpy.method_19538()).method_1029().method_1021(this.speed);
                this.harpy.method_18799(direction);
                this.harpy.method_5988().method_20248(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350);
                this.rotateTowardsTarget();
            }
        }
    }

    private void enterIdleMode() {
        class_5819 random = this.harpy.method_6051();
        this.idleTime = random.method_43048(41) + 20;
        this.isIdle = true;
        this.harpy.method_18799(class_243.field_1353);
    }

    private class_243 getRandomAirPosition() {
        class_5819 random = this.harpy.method_6051();
        class_1937 world = this.harpy.method_37908();
        class_2338 currentPos = this.harpy.method_24515();
        int currentGroundHeight = world.method_8624(class_2902.class_2903.field_13203, currentPos.method_10263(), currentPos.method_10260());
        int altitudeRange = this.maxAltitude - this.minAltitude;
        for (int i = 0; i < 10; ++i) {
            double z;
            double newY = (double)(currentGroundHeight + this.minAltitude) + random.method_43058() * (double)altitudeRange;
            double x = this.harpy.method_23317() + (random.method_43058() * 20.0 - 10.0);
            class_243 targetPos = new class_243(x, newY, z = this.harpy.method_23321() + (random.method_43058() * 20.0 - 10.0));
            class_2338 targetBlockPos = class_2338.method_49638((class_2374)targetPos);
            if (!this.isValidFlyPosition(world, targetBlockPos)) continue;
            return targetPos;
        }
        return null;
    }

    private boolean isValidFlyPosition(class_1937 world, class_2338 pos) {
        if (!world.method_22347(pos) || !world.method_22347(pos.method_10084())) {
            return false;
        }
        class_2338 belowPos = pos.method_10074();
        if (world.method_8320(belowPos).method_26204().method_9539().contains("leaves")) {
            return false;
        }
        for (class_2338 adjacentPos : class_2338.method_10097((class_2338)pos.method_10069(-1, -1, -1), (class_2338)pos.method_10069(1, 1, 1))) {
            if (!world.method_8320(adjacentPos).method_26204().method_9539().contains("leaves")) continue;
            return false;
        }
        return true;
    }

    private void rotateTowardsTarget() {
        class_243 currentPosition = this.harpy.method_19538();
        class_243 directionToTarget = this.targetPos.method_1020(currentPosition).method_1029();
        double yaw = Math.toDegrees(Math.atan2(directionToTarget.field_1350, directionToTarget.field_1352)) - 90.0;
        double pitch = -Math.toDegrees(Math.atan2(directionToTarget.field_1351, Math.sqrt(directionToTarget.field_1352 * directionToTarget.field_1352 + directionToTarget.field_1350 * directionToTarget.field_1350)));
        this.harpy.method_36456((float)yaw);
        this.harpy.method_36457((float)pitch);
    }
}

