/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.ai.util;

import java.util.EnumSet;
import java.util.List;
import net.mebahel.antiquebeasts.entity.custom.patrol.ModPatrolEntity;
import net.minecraft.class_11;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class ModPatrolGoal
extends class_1352 {
    private final ModPatrolEntity entity;
    private final double leaderSpeed;
    private final double followSpeed;
    private ModPatrolEntity assignedLeader;

    public ModPatrolGoal(ModPatrolEntity entity, double leaderSpeed, double followSpeed) {
        this.entity = entity;
        this.leaderSpeed = leaderSpeed;
        this.followSpeed = followSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.assignedLeader = null;
    }

    public boolean method_6264() {
        if (!this.entity.isPatrolling()) {
            return false;
        }
        if (this.assignedLeader == null || this.assignedLeader.method_29504()) {
            this.assignedLeader = this.findNewLeader();
        }
        return this.assignedLeader != null && !this.assignedLeader.method_29504();
    }

    public void method_6268() {
        class_1408 entityNavigation = this.entity.method_5942();
        if (entityNavigation.method_6357()) {
            if (this.entity.isPatrolLeader()) {
                class_2338 targetPos;
                class_2338 class_23382 = targetPos = this.assignedLeader != null ? this.assignedLeader.getPatrolTarget() : null;
                if (targetPos != null) {
                    class_11 path = entityNavigation.method_6348(targetPos, 0);
                    if (path != null) {
                        entityNavigation.method_6334(path, this.entity.isPatrolLeader() ? this.leaderSpeed : this.followSpeed);
                    } else if (this.entity.isPatrolLeader()) {
                        class_2338 newTarget = ModPatrolGoal.setRandomPatrolTarget((class_3218)this.entity.method_37908(), this.entity.method_24515());
                        this.entity.setPatrolTarget(newTarget);
                    }
                } else {
                    this.wander();
                }
            } else if (this.assignedLeader != null && !this.assignedLeader.method_29504()) {
                class_243 leaderPos = this.assignedLeader.method_19538();
                class_243 direction = this.entity.method_19538().method_1020(leaderPos).method_1029();
                class_243 offsetPosition = leaderPos.method_1019(direction.method_1021(2.0));
                entityNavigation.method_6337(offsetPosition.field_1352, offsetPosition.field_1351, offsetPosition.field_1350, this.followSpeed);
            } else {
                this.wander();
            }
        }
    }

    private ModPatrolEntity findNewLeader() {
        List patrolMembers = this.entity.method_37908().method_8390(ModPatrolEntity.class, this.entity.method_5829().method_1014(32.0), e -> e.isPartOfSamePatrol(this.entity));
        for (ModPatrolEntity member : patrolMembers) {
            if (member.method_29504() || !member.isPatrolLeader()) continue;
            return member;
        }
        for (ModPatrolEntity member : patrolMembers) {
            if (member.method_29504() || member.isPatrolLeader()) continue;
            member.setPatrolLeader(true);
            return member;
        }
        return null;
    }

    private void wander() {
        class_5819 random = this.entity.method_6051();
        class_2338 blockPos = this.entity.method_37908().method_8598(class_2902.class_2903.field_13203, this.entity.method_24515().method_10069(-8 + random.method_43048(16), 0, -8 + random.method_43048(16)));
        this.entity.method_5942().method_6337((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), this.leaderSpeed);
    }

    public static class_2338 setRandomPatrolTarget(class_3218 world, class_2338 pos) {
        class_2338 roughTargetPos;
        class_2338 finalTargetPos;
        int x = 150 + world.field_9229.method_43048(150);
        int z = 150 + world.field_9229.method_43048(150);
        if (world.field_9229.method_43056()) {
            x = -x;
        }
        if (world.field_9229.method_43056()) {
            z = -z;
        }
        if ((finalTargetPos = ModPatrolGoal.findTopSolidBlock(world, roughTargetPos = new class_2338(pos.method_10263() + x, world.method_31605(), pos.method_10260() + z))).method_10264() < world.method_31607() || finalTargetPos.method_10264() > world.method_31600()) {
            finalTargetPos = world.method_8598(class_2902.class_2903.field_13203, pos);
        }
        return finalTargetPos;
    }

    private static class_2338 findTopSolidBlock(class_3218 world, class_2338 pos) {
        return world.method_8598(class_2902.class_2903.field_13203, pos);
    }
}

