/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.client.custom;

import com.google.common.collect.Maps;
import java.util.Map;
import net.mebahel.antiquebeasts.entity.custom.norse.HuskarlEntity;
import net.mebahel.antiquebeasts.entity.variant.HersirVariant;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class HuskarlModel
extends GeoModel<HuskarlEntity> {
    public static final Map<HersirVariant, class_2960> LOCATION_BY_VARIANT = (Map)class_156.method_654((Object)Maps.newEnumMap(HersirVariant.class), map -> {
        map.put(HersirVariant.DEFAULT, new class_2960("antiquebeasts", "textures/entity/huskarl1_texture.png"));
        map.put(HersirVariant.CLOAK, new class_2960("antiquebeasts", "textures/entity/huskarl2_texture.png"));
    });

    public class_2960 getModelResource(HuskarlEntity object) {
        return new class_2960("antiquebeasts", "geo/huskarl.geo.json");
    }

    public class_2960 getTextureResource(HuskarlEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public class_2960 getAnimationResource(HuskarlEntity animatable) {
        return new class_2960("antiquebeasts", "animations/huskarl.animation.json");
    }

    public void setCustomAnimations(HuskarlEntity entity, long uniqueID, AnimationState<HuskarlEntity> customPredicate) {
        CoreGeoBone head = this.getBone("head").orElse(null);
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.125f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = 0.125f * extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.6f) {
            yawAngle = 0.0f;
        }
        if (head != null) {
            head.setRotY(7.0f * yawAngle);
            head.setRotX(7.0f * pitchAngle);
        }
    }
}

