/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.client.custom.draugr_scourge;

import com.google.common.collect.Maps;
import java.util.Map;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrScourgeEntity;
import net.mebahel.antiquebeasts.entity.variant.DraugrScourgeVariant;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class DraugrScourgeModel
extends GeoModel<DraugrScourgeEntity> {
    public static final Map<DraugrScourgeVariant, class_2960> LOCATION_BY_VARIANT = (Map)class_156.method_654((Object)Maps.newEnumMap(DraugrScourgeVariant.class), map -> {
        map.put(DraugrScourgeVariant.TEMPERATE, new class_2960("antiquebeasts", "textures/entity/draugr_scourge/draugr_scourge_temperate.png"));
        map.put(DraugrScourgeVariant.COLD, new class_2960("antiquebeasts", "textures/entity/draugr_scourge/draugr_scourge_cold.png"));
        map.put(DraugrScourgeVariant.HOT, new class_2960("antiquebeasts", "textures/entity/draugr_scourge/draugr_scourge_hot.png"));
    });

    public class_2960 getModelResource(DraugrScourgeEntity object) {
        return new class_2960("antiquebeasts", "geo/draugr_scourge.geo.json");
    }

    public class_2960 getTextureResource(DraugrScourgeEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getScourgeVariant());
    }

    public class_2960 getAnimationResource(DraugrScourgeEntity animatable) {
        return new class_2960("antiquebeasts", "animations/draugr.animation.json");
    }

    public void setCustomAnimations(DraugrScourgeEntity entity, long uniqueID, AnimationState<DraugrScourgeEntity> customPredicate) {
        CoreGeoBone head = this.getBone("Head").orElse(null);
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.125f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = 0.125f * extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.6f) {
            yawAngle = 0.0f;
        }
        if (head != null) {
            head.setRotY(7.0f * yawAngle);
            head.setRotX(7.0f * pitchAngle);
        }
    }
}

