/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.client.custom.draugr_wight;

import com.google.common.collect.Maps;
import java.util.Map;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrWightEntity;
import net.mebahel.antiquebeasts.entity.variant.DraugrWightVariant;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class DraugrWightModel
extends GeoModel<DraugrWightEntity> {
    public static final Map<DraugrWightVariant, class_2960> LOCATION_BY_VARIANT = (Map)class_156.method_654((Object)Maps.newEnumMap(DraugrWightVariant.class), map -> {
        map.put(DraugrWightVariant.TEMPERATE, new class_2960("antiquebeasts", "textures/entity/draugr/draugr_wight_temperate.png"));
        map.put(DraugrWightVariant.COLD, new class_2960("antiquebeasts", "textures/entity/draugr/draugr_wight_cold.png"));
        map.put(DraugrWightVariant.HOT, new class_2960("antiquebeasts", "textures/entity/draugr/draugr_wight_hot.png"));
        map.put(DraugrWightVariant.TEMPERATE_AXE, new class_2960("antiquebeasts", "textures/entity/draugr/draugr_wight_temperate_axe.png"));
        map.put(DraugrWightVariant.COLD_AXE, new class_2960("antiquebeasts", "textures/entity/draugr/draugr_wight_cold_axe.png"));
        map.put(DraugrWightVariant.HOT_AXE, new class_2960("antiquebeasts", "textures/entity/draugr/draugr_wight_hot_axe.png"));
    });

    public class_2960 getModelResource(DraugrWightEntity object) {
        return new class_2960("antiquebeasts", "geo/draugr_wight.geo.json");
    }

    public class_2960 getTextureResource(DraugrWightEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getWightVariant());
    }

    public class_2960 getAnimationResource(DraugrWightEntity animatable) {
        return new class_2960("antiquebeasts", "animations/draugr.animation.json");
    }

    public void setCustomAnimations(DraugrWightEntity entity, long uniqueID, AnimationState<DraugrWightEntity> customPredicate) {
        CoreGeoBone head = this.getBone("Head").orElse(null);
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.125f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = 0.125f * extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.6f) {
            yawAngle = 0.0f;
        }
        if (head != null) {
            head.setRotY(7.0f * yawAngle);
            head.setRotX(7.0f * pitchAngle);
        }
    }
}

