/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom;

import java.util.Objects;
import net.mebahel.antiquebeasts.entity.ModEntities;
import net.mebahel.antiquebeasts.entity.variant.PegasusVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1387;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3675;
import net.minecraft.class_3730;
import net.minecraft.class_408;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7688;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class PegasusEntity
extends class_1498
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean isGliding = false;
    private boolean jumping = false;
    private boolean wasJumpPressed = false;
    private int ticksSinceJump = 0;
    private int transitionTicks = 0;
    private int transitionFromGroundTicks = 0;
    private boolean transitioningToGround = false;
    private boolean transitioningToFly = false;
    private int transition = 0;
    private float entityScale = 1.0f;
    public static final class_2940<Float> SCALE_TRACKER = class_2945.method_12791(PegasusEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(PegasusEntity.class, (class_2941)class_2943.field_13327);

    public float getScale() {
        return this.entityScale;
    }

    public void setScale(float scale) {
        this.entityScale = scale;
    }

    public PegasusEntity(class_1299<? extends class_1498> entityType, class_1937 world) {
        super(entityType, world);
        this.setVariant(PegasusVariant.DEFAULT);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(1, (class_1352)new class_1387((class_1496)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0, class_1496.class));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        if (this.method_45349()) {
            this.field_6201.method_6277(9, (class_1352)new class_7688((class_1496)this));
        }
        this.method_6764();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(SCALE_TRACKER, (Object)Float.valueOf(1.0f));
    }

    public static class_5132.class_5133 setAttributes() {
        class_5819 random = class_5819.method_43047();
        double baseSpeed = 0.22;
        double baseHealth = 40.0;
        double baseJumpStrength = 1.0;
        double minMultiplier = 1.25;
        double maxMultiplier = 1.5;
        double multiplier = minMultiplier + (maxMultiplier - minMultiplier) * random.method_43058();
        double finalSpeed = baseSpeed * multiplier;
        double finalHealth = baseHealth * multiplier;
        double finalJumpStrength = baseJumpStrength * multiplier;
        return class_1498.method_26828().method_26868(class_5134.field_23720, 0.8).method_26868(class_5134.field_23719, finalSpeed).method_26868(class_5134.field_23728, finalJumpStrength).method_26868(class_5134.field_23716, finalHealth + (double)ModBonusHealthConfig.pegasusBonusHealth).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23721, 7.5).method_26868(class_5134.field_23718, (double)0.6f).method_26868(class_5134.field_23722, (double)0.65f);
    }

    private PlayState predicate(AnimationState animationState) {
        if (this.transitioningToGround) {
            animationState.getController().setAnimation(RawAnimation.begin().then("fly_to_ground", Animation.LoopType.PLAY_ONCE));
            if (++this.transitionTicks > 20) {
                this.transitioningToGround = false;
                this.transitionTicks = 0;
            }
            return PlayState.CONTINUE;
        }
        if (this.transitioningToFly) {
            animationState.getController().setAnimation(RawAnimation.begin().then("fly_from_ground", Animation.LoopType.PLAY_ONCE));
            if (++this.transitionFromGroundTicks > 10) {
                this.transitioningToFly = false;
                this.transitionFromGroundTicks = 0;
            }
            return PlayState.CONTINUE;
        }
        if (animationState.isMoving() && !this.isGliding) {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle_to_walk", Animation.LoopType.PLAY_ONCE).then("walk2", Animation.LoopType.LOOP));
        } else if (animationState.isMoving() && this.isGliding && !this.transitioningToFly) {
            animationState.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        } else if (this.isGliding && !this.transitioningToFly) {
            animationState.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        } else {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "predicate", 0, this::predicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null && this.isGliding) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.PEGASUS_FLAP_1, this.method_5634(), 0.15f, 2.0f);
            }
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean method_5810() {
        return false;
    }

    public class_1924 method_48926() {
        return null;
    }

    protected void method_45343(float strength, class_243 movementInput) {
        boolean isGroundClose;
        class_1297 passenger = this.method_31483();
        class_1657 player = passenger instanceof class_1657 ? (class_1657)passenger : null;
        class_310 client = class_310.method_1551();
        class_2338 pos = this.method_24515();
        class_2338 belowPos = pos.method_10087(1);
        boolean bl = isGroundClose = !this.method_37908().method_8320(belowPos).method_26215();
        if (this.jumping && player != null && !(client.field_1755 instanceof class_408)) {
            class_243 vec3d = this.method_18798();
            this.method_18800(vec3d.field_1352, 1.0, vec3d.field_1350);
            this.method_5875(true);
            this.isGliding = true;
            this.ticksSinceJump = 0;
            this.jumping = false;
            if (this.method_24828() || isGroundClose) {
                this.transitioningToFly = true;
            }
        }
    }

    protected void method_6723() {
        this.method_5783(ModSounds.PEGASUS_FLAP_1, 0.15f, 2.0f);
    }

    public void method_5773() {
        class_1799 armorStack;
        class_1792 armorItem;
        class_1297 passenger;
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.method_6109()) {
                float age = this.method_5618();
                float progress = Math.max(0.0f, Math.min(1.0f, 1.0f - age / -24000.0f));
                float growthFactor = 0.5f + progress * 0.5f;
                this.setScale(growthFactor);
                this.method_5841().method_12778(SCALE_TRACKER, (Object)Float.valueOf(growthFactor));
            } else {
                this.setScale(1.0f);
            }
        }
        class_1657 player = (passenger = this.method_31483()) instanceof class_1657 ? (class_1657)passenger : null;
        class_2338 pos = this.method_24515();
        class_2338 belowPos = pos.method_10087(1);
        class_243 vec3d = this.method_18798();
        boolean isGroundClose = !this.method_37908().method_8320(belowPos).method_26215();
        boolean isJumpPressed = false;
        if (this.isClientSide() && player != null) {
            isJumpPressed = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)32);
            if (class_310.method_1551().field_1755 instanceof class_408) {
                isJumpPressed = false;
            }
        }
        if ((armorItem = (armorStack = this.method_6118(class_1304.field_6174)).method_7909()) != null && this.method_6725() && player != null) {
            if (armorItem == class_1802.field_18138) {
                this.setVariant(PegasusVariant.LEATHER_SADDLED_MOUNTED);
            } else if (armorItem == class_1802.field_8578) {
                this.setVariant(PegasusVariant.IRON_SADDLED_MOUNTED);
            } else if (armorItem == class_1802.field_8560) {
                this.setVariant(PegasusVariant.GOLD_SADDLED_MOUNTED);
            } else if (armorItem == class_1802.field_8807) {
                this.setVariant(PegasusVariant.DIAMOND_SADDLED_MOUNTED);
            }
        } else if (armorItem != null && this.method_6725() && player == null) {
            if (armorItem == class_1802.field_18138) {
                this.setVariant(PegasusVariant.LEATHER_SADDLED_UNMOUNTED);
            } else if (armorItem == class_1802.field_8578) {
                this.setVariant(PegasusVariant.IRON_SADDLED_UNMOUNTED);
            } else if (armorItem == class_1802.field_8560) {
                this.setVariant(PegasusVariant.GOLD_SADDLED_UNMOUNTED);
            } else if (armorItem == class_1802.field_8807) {
                this.setVariant(PegasusVariant.DIAMOND_SADDLED_UNMOUNTED);
            }
        } else if (armorItem != null && !this.method_6725()) {
            if (armorItem == class_1802.field_18138) {
                this.setVariant(PegasusVariant.LEATHER_UNMOUNT);
            } else if (armorItem == class_1802.field_8578) {
                this.setVariant(PegasusVariant.IRON_UNMOUNT);
            } else if (armorItem == class_1802.field_8560) {
                this.setVariant(PegasusVariant.GOLD_UNMOUNT);
            } else if (armorItem == class_1802.field_8807) {
                this.setVariant(PegasusVariant.DIAMOND_UNMOUNT);
            }
        }
        assert (armorItem != null);
        if (Objects.equals(armorItem.toString(), "air") && this.method_6725()) {
            if (player != null) {
                this.setVariant(PegasusVariant.CLOAK);
            } else {
                this.setVariant(PegasusVariant.UNMOUNT);
            }
        } else if (Objects.equals(armorItem.toString(), "air") && !this.method_6725()) {
            this.setVariant(PegasusVariant.DEFAULT);
        }
        if (player != null && this.method_6725()) {
            if (!(this.method_24828() || isGroundClose || this.isGliding)) {
                ++this.transition;
            } else if (this.isGliding && (this.method_24828() || isGroundClose) && !this.transitioningToFly) {
                this.isGliding = false;
                this.transitioningToGround = true;
                this.method_5875(false);
            } else if (this.field_6012 <= 2 && (this.method_24828() || isGroundClose)) {
                this.isGliding = false;
                this.method_5875(false);
                this.jumping = false;
            }
            if (this.method_24828() && isGroundClose && this.transition != 0) {
                this.transition = 0;
            }
            if (this.transition == 20) {
                this.transitioningToFly = true;
                this.isGliding = true;
                this.transition = 0;
            }
            if (this.wasJumpPressed && !isJumpPressed) {
                this.jumping = true;
                this.method_45343(0.0f, class_243.field_1353);
            }
            if (this.isGliding && this.ticksSinceJump > 20) {
                double forward = player.field_6250;
                double sideways = player.field_6212;
                class_243 lookVector = player.method_5720();
                if (forward != 0.0 || sideways != 0.0) {
                    double speed = 0.4;
                    double yVec = lookVector.field_1351;
                    if (lookVector.field_1351 > 0.0) {
                        yVec = 0.0;
                    }
                    class_243 moveVec = new class_243(lookVector.field_1352, yVec, lookVector.field_1350).method_1029().method_1021(speed);
                    class_243 strafeVec = new class_243(lookVector.field_1350, 0.0, -lookVector.field_1352).method_1029().method_1021(speed);
                    if (forward < 0.0) {
                        moveVec = moveVec.method_1021(0.3333333333333333);
                    }
                    class_243 finalMoveVec = moveVec.method_1021(forward).method_1019(strafeVec.method_1021(sideways * 0.5));
                    this.method_18799(finalMoveVec);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                } else {
                    this.method_18800(0.0, -0.05, 0.0);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                }
            } else if (this.ticksSinceJump <= 20 && this.isGliding) {
                this.method_18800(vec3d.field_1352, 0.6, vec3d.field_1350);
            }
            ++this.ticksSinceJump;
        } else if (this.isGliding) {
            this.method_5875(false);
            this.isGliding = false;
        }
        if (this.field_6012 < 3) {
            this.method_18800(vec3d.field_1352, -0.01, vec3d.field_1350);
            this.transitioningToGround = false;
            this.transitioningToFly = false;
        }
        this.wasJumpPressed = isJumpPressed;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42345)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 pos) {
        class_1297 passenger = this.method_31483();
        if (passenger instanceof class_1657) {
            return;
        }
        super.method_5623(heightDifference, onGround, state, pos);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
    }

    public PegasusVariant getPegasusVariant() {
        return PegasusVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(PegasusVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private boolean isClientSide() {
        return this.method_37908().field_9236;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        if (this.method_6109()) {
            this.setScale(0.5f);
        }
        return entityData;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        PegasusEntity horseEntity2 = (PegasusEntity)ModEntities.PEGASUS.method_5883((class_1937)world);
        this.method_6743(entity, (class_1496)horseEntity2);
        return horseEntity2;
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1429> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        long time = world.method_8401().method_217();
        if (time % 24000L >= 13000L) {
            return false;
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockBelow = world.method_8320(blockPos);
        boolean isGrassyGround = blockBelow.method_27852(class_2246.field_10479);
        if (!isGrassyGround) {
            return false;
        }
        if (world.method_22339(pos) < 9) {
            return false;
        }
        if (!world.method_8311(pos)) {
            return false;
        }
        int randomValue = random.method_43048(10);
        return randomValue < ModSpawnRateConfig.pegasusSpawnRate;
    }
}

