/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.dwemer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.mebahel.antiquebeasts.entity.ai.CustomRevengeGoal;
import net.mebahel.antiquebeasts.entity.ai.dwarven.dwarven_centurion.DwarvenCenturionMeleeAttackGoal;
import net.mebahel.antiquebeasts.entity.ai.dwarven.dwarven_centurion.DwarvenCenturionShootingGoal;
import net.mebahel.antiquebeasts.entity.custom.ChimeraEntity;
import net.mebahel.antiquebeasts.entity.custom.CyclopsEntity;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.variant.CyclopsVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.LargeEntityPathNodeMaker;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class DwemerCenturionEntity
extends DwemerEntity
implements GeoEntity {
    double last_step = 0.0;
    private int idleCondition = 0;
    private final List<class_1799> minedResources = new ArrayList<class_1799>();
    private boolean shouldRandomIdle = true;
    double rand;
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(DwemerCenturionEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SWINGING = class_2945.method_12791(DwemerCenturionEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> COOLDOWN = class_2945.method_12791(DwemerCenturionEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<String> ATTACK_NAME = class_2945.method_12791(DwemerCenturionEntity.class, (class_2941)class_2943.field_13326);
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final class_2940<String> CURRENT_ANIMATION = class_2945.method_12791(DwemerCenturionEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(DwemerCenturionEntity.class, (class_2941)class_2943.field_13327);

    public DwemerCenturionEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    @Override
    public float getCooldown() {
        return ((Float)this.field_6011.method_12789(COOLDOWN)).floatValue();
    }

    @Override
    public void setCooldown(float cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    @Override
    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    @Override
    public void setSwinging(boolean swinging) {
        this.field_6011.method_12778(SWINGING, (Object)swinging);
    }

    @Override
    public boolean isSwinging() {
        return (Boolean)this.field_6011.method_12789(SWINGING);
    }

    @Override
    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    @Override
    public void setAttackName(String attackName) {
        this.field_6011.method_12778(ATTACK_NAME, (Object)attackName);
    }

    @Override
    public String getAttackName() {
        return (String)this.field_6011.method_12789(ATTACK_NAME);
    }

    @Override
    public boolean shouldDespawnInPeaceful() {
        return this.method_37908().method_8407() == class_1267.field_5801;
    }

    @Override
    public String getCurrentAnimation() {
        return (String)this.field_6011.method_12789(CURRENT_ANIMATION);
    }

    @Override
    public void setCurrentAnimation(String animation) {
        this.field_6011.method_12778(CURRENT_ANIMATION, (Object)animation);
    }

    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.isShooting()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
        } else if (Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6194() == 0.0 && !this.isShooting()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.3);
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(COOLDOWN, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack2");
        this.field_6011.method_12784(CURRENT_ANIMATION, (Object)"idle");
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23716, (double)(84 + ModBonusHealthConfig.cyclopsBonusHealth)).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23724, 8.0).method_26868(class_5134.field_23721, 9.0).method_26868(class_5134.field_23718, (double)0.8f).method_26868(class_5134.field_23722, 0.25);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DwarvenCenturionShootingGoal(this, 3.0f));
        this.field_6201.method_6277(3, (class_1352)new DwarvenCenturionMeleeAttackGoal(this, 1.0, 39, 2));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.85f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new CustomRevengeGoal((class_1314)this, DwemerEntity.class));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DraugrEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, ChimeraEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, CyclopsEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, EgyptianEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
    }

    @Override
    public void method_6078(class_1282 source) {
        super.method_6078(source);
        if (!this.method_37908().field_9236) {
            int xpAmount;
            for (int xpToDrop = 60 + this.field_5974.method_43048(30); xpToDrop > 0; xpToDrop -= xpAmount) {
                xpAmount = class_1303.method_5918((int)xpToDrop);
                this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), xpAmount));
            }
        }
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            this.setCurrentAnimation("walk");
            if (this.shouldRandomIdle) {
                this.idleCondition = Math.random() < 0.5 ? 1 : 2;
                this.shouldRandomIdle = false;
            }
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.method_5841().method_12789(IS_MINING)).booleanValue()) {
            this.setCurrentAnimation("mine");
            event.getController().setAnimation(RawAnimation.begin().then("mine", Animation.LoopType.LOOP));
        } else {
            if (this.idleCondition == 1) {
                this.setCurrentAnimation("idle");
                event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            } else {
                this.setCurrentAnimation("idle2");
                event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
            this.shouldRandomIdle = true;
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.isSwinging() && !this.isShooting() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(this.getAttackName(), Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState shootingPredicate(AnimationState state) {
        if (this.isShooting() && !this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("shooting", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.DWARVEN_SPIDER_MINING, this.method_5634(), 0.5f, 0.6f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shooting", 0, this::shootingPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.SWING, this.method_5634(), 0.5f, 0.6f);
            }
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected class_1408 method_5965(class_1937 world) {
        return new class_1409((class_1308)this, world){

            protected class_13 method_6336(int range) {
                this.field_6678 = new LargeEntityPathNodeMaker();
                this.field_6678.method_15(true);
                return new class_13(this.field_6678, range);
            }
        };
    }

    public float method_49476() {
        return 1.1f;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        CyclopsVariant variant = (CyclopsVariant)((Object)class_156.method_27173((Object[])CyclopsVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public CyclopsVariant getVariant() {
        return CyclopsVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(CyclopsVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        if (this.last_step == 0.0) {
            this.method_5783(ModSounds.DWARVEN_CENTURION_WALK, 0.25f, 1.0f);
            this.last_step = this.field_6012;
        }
        if (this.last_step + 12.0 <= (double)this.field_6012) {
            this.method_5783(ModSounds.DWARVEN_CENTURION_WALK, 0.25f, 1.0f);
            this.last_step = this.field_6012;
        }
    }

    @Override
    public int method_5970() {
        return 360;
    }

    @Override
    protected class_3414 method_5994() {
        return ModSounds.DWARVEN_CENTURION_AMBIENT_1;
    }

    @Override
    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, 0.35f, 1.0f);
        }
    }

    @Override
    protected class_3414 method_6002() {
        return ModSounds.DWARVEN_CENTURION_DEATH_1;
    }

    @Override
    protected void method_6013(class_1282 source) {
        class_3414 hurtSound = this.method_6011(source);
        if (hurtSound != null) {
            this.method_5783(hurtSound, 0.45f, 1.0f);
        }
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.DWARVEN_CENTURION_INJURED_1;
        }
        return ModSounds.DWARVEN_CENTURION_INJURED_2;
    }
}

