/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.egyptian;

import net.mebahel.antiquebeasts.entity.ModEntities;
import net.mebahel.antiquebeasts.entity.ai.CaravanEscapeDangerGoal;
import net.mebahel.antiquebeasts.entity.ai.util.ModPatrolGoal;
import net.mebahel.antiquebeasts.entity.custom.egyptian.AxemanEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.CamelryEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.ElephantRiderEntity;
import net.mebahel.antiquebeasts.entity.custom.patrol.ModPatrolEntity;
import net.mebahel.antiquebeasts.entity.variant.EgyptiantVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EgyptianCaravanEntity
extends EgyptianEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public EgyptianCaravanEntity(class_1299<? extends ModPatrolEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack");
        this.field_6011.method_12784(IS_IN_CARAVAN, (Object)false);
        this.field_6011.method_12784(PATROL_UUID, (Object)"");
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23719, (double)0.78f).method_26868(class_5134.field_23716, 20.0 + (double)ModBonusHealthConfig.egyptianCaravanBonusHealth).method_26868(class_5134.field_23724, 0.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23718, (double)0.3f).method_26868(class_5134.field_23722, 0.5);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new CaravanEscapeDangerGoal((class_1314)this, 0.45f));
        this.field_6201.method_6277(3, (class_1352)new ModPatrolGoal(this, 0.37f, 0.4f));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, (double)0.35f, 1.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.CAMELRY_HURT_1;
        }
        return ModSounds.CAMELRY_HURT_2;
    }

    protected class_3414 method_6002() {
        return ModSounds.CAMELRY_DEATH_1;
    }

    protected class_3414 method_5994() {
        class_1309 target = this.method_5968();
        this.rand = Math.random();
        if (target != null) {
            if (this.rand < 0.3) {
                return ModSounds.EGYPTIAN_ATTACK_1;
            }
            if (this.rand > 0.3 && this.rand < 0.6) {
                return ModSounds.EGYPTIAN_ATTACK_2;
            }
            return ModSounds.EGYPTIAN_ATTACK_3;
        }
        if (this.rand < 0.3) {
            return ModSounds.EGYPTIAN_AMBIENT_1;
        }
        if (this.rand > 0.3 && this.rand < 0.6) {
            return ModSounds.EGYPTIAN_AMBIENT_2;
        }
        return ModSounds.EGYPTIAN_AMBIENT_3;
    }

    public void method_16078() {
        super.method_16078();
        if (!this.method_37908().field_9236) {
            class_2338 pos = this.method_24515();
            while (this.method_37908().method_22347(pos.method_10074()) && pos.method_10264() > 0) {
                pos = pos.method_10074();
            }
            this.method_37908().method_8501(pos, class_2246.field_10034.method_9564());
            class_2586 blockEntity = this.method_37908().method_8321(pos);
            if (blockEntity instanceof class_2595) {
                ((class_2595)blockEntity).method_11285(new class_2960("antiquebeasts", "chests/egyptian/egyptian_caravan"), this.field_5974.method_43055());
            }
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_243 offsetPosition;
        int numAxemen = 2 + this.field_5974.method_43048(2);
        EgyptiantVariant variant = (EgyptiantVariant)((Object)class_156.method_27173((Object[])EgyptiantVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        for (int i = 0; i < numAxemen; ++i) {
            AxemanEntity newAxeman = new AxemanEntity(ModEntities.AXEMAN, this.method_37908(), true, (class_1309)this);
            class_243 offsetPosition2 = this.getOffsetPosition(4.0 * this.field_5974.method_43058(), 4.0 * this.field_5974.method_43058());
            newAxeman.method_5808(offsetPosition2.field_1352, offsetPosition2.field_1351, offsetPosition2.field_1350, this.method_36454(), this.method_36455());
            this.method_37908().method_8649((class_1297)newAxeman);
        }
        if (this.field_5974.method_43048(3) == 0) {
            ElephantRiderEntity newElephantRider = new ElephantRiderEntity(ModEntities.ELEPHANT_RIDER, this.method_37908(), true, (class_1309)this);
            offsetPosition = this.getOffsetPosition(4.0 * this.field_5974.method_43058(), 4.0 * this.field_5974.method_43058());
            newElephantRider.method_5808(offsetPosition.field_1352, offsetPosition.field_1351, offsetPosition.field_1350, this.method_36454(), this.method_36455());
            this.method_37908().method_8649((class_1297)newElephantRider);
        }
        if (this.field_5974.method_43048(2) == 0) {
            CamelryEntity newCamelryRider = new CamelryEntity(ModEntities.CAMELRY, this.method_37908(), true, (class_1309)this);
            offsetPosition = this.getOffsetPosition(4.0 * this.field_5974.method_43058(), 4.0 * this.field_5974.method_43058());
            newCamelryRider.method_5808(offsetPosition.field_1352, offsetPosition.field_1351, offsetPosition.field_1350, this.method_36454(), this.method_36455());
            this.method_37908().method_8649((class_1297)newCamelryRider);
        }
        return entityData;
    }

    private class_243 getOffsetPosition(double offsetX, double offsetZ) {
        double x = this.method_23317() + offsetX;
        double y = this.method_23318();
        double z = this.method_23321() + offsetZ;
        return new class_243(x, y, z);
    }

    public EgyptiantVariant getVariant() {
        return EgyptiantVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(EgyptiantVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (state.method_26231() == class_2498.field_11526) {
            this.method_5783(class_3417.field_40082, 1.0f, 1.0f);
        } else {
            this.method_5783(class_3417.field_40081, 1.0f, 1.0f);
        }
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1429> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        boolean isSandyGround;
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        long time = world.method_8401().method_217();
        if (time % 24000L >= 13000L) {
            return false;
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockBelow = world.method_8320(blockPos);
        boolean bl = isSandyGround = blockBelow.method_27852(class_2246.field_10102) || blockBelow.method_27852(class_2246.field_10534);
        if (!isSandyGround) {
            return false;
        }
        if (world.method_22339(pos) < 9) {
            return false;
        }
        if (!world.method_8311(pos)) {
            return false;
        }
        int randomValue = random.method_43048(10);
        return randomValue < ModSpawnRateConfig.egyptianCaravanSpawnRate;
    }
}

