/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.egyptian;

import java.util.List;
import net.mebahel.antiquebeasts.entity.ai.BigEgyptianMeleeAttackGoal;
import net.mebahel.antiquebeasts.entity.ai.DefendLeadEntityGoal;
import net.mebahel.antiquebeasts.entity.ai.ElephantRiderShootingGoal;
import net.mebahel.antiquebeasts.entity.ai.FollowEntityGoal;
import net.mebahel.antiquebeasts.entity.ai.util.GroupRevengeGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianCaravanEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.custom.patrol.ModPatrolEntity;
import net.mebahel.antiquebeasts.entity.variant.EgyptiantVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class ElephantRiderEntity
extends EgyptianEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final class_2940<Integer> COOLDOWN = class_2945.method_12791(ElephantRiderEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(ElephantRiderEntity.class, (class_2941)class_2943.field_13323);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    public int getCooldown() {
        return (Integer)this.field_6011.method_12789(COOLDOWN);
    }

    public void setCooldown(int cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)cooldown);
    }

    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    public ElephantRiderEntity(class_1299<? extends ModPatrolEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
    }

    public ElephantRiderEntity(class_1299<? extends ModPatrolEntity> entityType, class_1937 world, boolean isInCaravan, class_1309 leadEntity) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
        this.setInCaravan(isInCaravan);
        List caravanEntities = this.method_37908().method_8390(EgyptianCaravanEntity.class, this.method_5829().method_1014(48.0), e -> true);
        EgyptianCaravanEntity closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (EgyptianCaravanEntity camelry : caravanEntities) {
            double distance = this.method_5858((class_1297)camelry);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closest = camelry;
        }
        this.setLeadEntity((class_1309)closest);
    }

    public static ElephantRiderEntity create(class_1299<? extends ModPatrolEntity> entityType, class_1937 world) {
        return new ElephantRiderEntity(entityType, world);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack");
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(COOLDOWN, (Object)0);
        this.field_6011.method_12784(IS_IN_CARAVAN, (Object)false);
        this.field_6011.method_12784(PATROL_UUID, (Object)"");
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.78f).method_26868(class_5134.field_23716, 48.0 + (double)ModBonusHealthConfig.elephantRiderBonusHealth).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23718, (double)0.7f).method_26868(class_5134.field_23722, 3.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DefendLeadEntityGoal(this));
        this.field_6201.method_6277(3, (class_1352)new ElephantRiderShootingGoal(this, 0.51f));
        this.field_6201.method_6277(4, (class_1352)new BigEgyptianMeleeAttackGoal(this, 0.5, 12.0, 3, 6));
        this.field_6201.method_6277(5, (class_1352)new FollowEntityGoal(this, 0.35f));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.35f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new GroupRevengeGoal((class_1314)this, EgyptianEntity.class).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DraugrEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(this.getAttackName(), Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState shootingPredicate(AnimationState state) {
        if (this.isShooting() && !this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("shoot", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.SWING, this.method_5634(), 0.5f, 1.5f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shooting", 0, this::shootingPredicate)});
    }

    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.3) {
            return ModSounds.ELEPHANT_HURT_1;
        }
        if (this.rand > 0.3 && this.rand < 0.6) {
            return ModSounds.ELEPHANT_HURT_2;
        }
        return ModSounds.HOPLITE_HURT1;
    }

    protected class_3414 method_6002() {
        return ModSounds.ELEPHANT_DEATH_1;
    }

    protected class_3414 method_5994() {
        class_1309 target = this.method_5968();
        this.rand = Math.random();
        if (target != null) {
            if (this.rand < 0.3) {
                return ModSounds.EGYPTIAN_ATTACK_1;
            }
            if (this.rand > 0.3 && this.rand < 0.6) {
                return ModSounds.EGYPTIAN_ATTACK_2;
            }
            return ModSounds.EGYPTIAN_ATTACK_3;
        }
        if (this.rand < 0.3) {
            return ModSounds.ELEPHANT_AMBIENT_1;
        }
        if (this.rand > 0.3 && this.rand < 0.6) {
            return ModSounds.EGYPTIAN_AMBIENT_2;
        }
        return ModSounds.EGYPTIAN_AMBIENT_3;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        EgyptiantVariant variant = (EgyptiantVariant)((Object)class_156.method_27173((Object[])EgyptiantVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public EgyptiantVariant getVariant() {
        return EgyptiantVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(EgyptiantVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (state.method_26231() == class_2498.field_11526) {
            this.method_5783(class_3417.field_40082, 1.0f, 0.8f);
        } else {
            this.method_5783(class_3417.field_40081, 1.0f, 0.8f);
        }
    }
}

