/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.egyptian;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.mebahel.antiquebeasts.entity.ai.mummy_boss.MummyBossMeleeAttackGoal;
import net.mebahel.antiquebeasts.entity.ai.mummy_boss.MummyBossShootingGoal;
import net.mebahel.antiquebeasts.entity.ai.mummy_boss.MummyBossSummonGoal;
import net.mebahel.antiquebeasts.entity.ai.util.GroupRevengeGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.projectiles.MummyProjectileEntity;
import net.mebahel.antiquebeasts.entity.variant.EgyptiantVariant;
import net.mebahel.antiquebeasts.particle.ModParticles;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class MummyBossEntity
extends EgyptianEntity
implements GeoEntity {
    private final class_3213 bossBar;
    public boolean secondPhase = false;
    public boolean thirdPhase = false;
    private boolean playedTransitionAnimation = false;
    public boolean inTransitionPhase = false;
    private int secondPhaseTransitionDelay = -1;
    private int thirdPhaseTransitionDelay = -1;
    private String bossBarName;
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final class_2940<Integer> SPAWN_CD = class_2945.method_12791(MummyBossEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SPAWN = class_2945.method_12791(MummyBossEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HAS_SPAWNED = class_2945.method_12791(MummyBossEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> COOLDOWN = class_2945.method_12791(MummyBossEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(MummyBossEntity.class, (class_2941)class_2943.field_13323);

    public MummyBossEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.bossBar = new class_3213(class_2561.method_30163((String)"Mummy"), class_1259.class_1260.field_5782, class_1259.class_1261.field_5795);
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        this.field_6191 = -this.method_5970();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    public int getCooldown() {
        return (Integer)this.field_6011.method_12789(COOLDOWN);
    }

    public void setCooldown(int cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)cooldown);
    }

    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    public int getSpawnCooldown() {
        return (Integer)this.field_6011.method_12789(SPAWN_CD);
    }

    public void setSpawnCooldown(int cooldown) {
        this.field_6011.method_12778(SPAWN_CD, (Object)cooldown);
    }

    public boolean getSpawn() {
        return (Boolean)this.field_6011.method_12789(SPAWN);
    }

    public void setSpawn(boolean bool) {
        this.field_6011.method_12778(SPAWN, (Object)bool);
    }

    public boolean getHasSpawned() {
        return (Boolean)this.field_6011.method_12789(HAS_SPAWNED);
    }

    public void setHasSpawned(boolean bool) {
        this.field_6011.method_12778(HAS_SPAWNED, (Object)bool);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(COOLDOWN, (Object)0);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(IS_IN_CARAVAN, (Object)false);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack");
        this.field_6011.method_12784(SPAWN_CD, (Object)120);
        this.field_6011.method_12784(SPAWN, (Object)false);
        this.field_6011.method_12784(HAS_SPAWNED, (Object)false);
        this.field_6011.method_12784(PATROL_UUID, (Object)"");
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23716, 300.0 + (double)ModBonusHealthConfig.mummifiedPharaohBonusHealth).method_26868(class_5134.field_23724, 8.0).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23718, (double)0.2f).method_26868(class_5134.field_23722, 0.5);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new MummyBossSummonGoal(this, 0.51f));
        this.field_6201.method_6277(3, (class_1352)new MummyBossShootingGoal(this, 0.51f));
        this.field_6201.method_6277(4, (class_1352)new MummyBossMeleeAttackGoal(this, 0.51f, 6.0, 1, 10));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, (double)0.45f, 1.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new GroupRevengeGoal((class_1314)this, EgyptianEntity.class).method_6318(new Class[]{EgyptianEntity.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DraugrEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    private PlayState predicate(AnimationState animationState) {
        String walkAnimation = "walk";
        String idleAnimation = "idle";
        if (this.secondPhase) {
            walkAnimation = "second_phase_walk";
            idleAnimation = "second_phase_walk";
        }
        if (this.thirdPhase) {
            walkAnimation = "second_phase_walk";
            idleAnimation = "second_phase_walk";
        }
        if (this.secondPhase && !this.playedTransitionAnimation) {
            animationState.getController().forceAnimationReset();
            animationState.getController().setAnimation(RawAnimation.begin().then("transition_second_phase", Animation.LoopType.PLAY_ONCE));
            this.playedTransitionAnimation = true;
            this.inTransitionPhase = true;
            return PlayState.CONTINUE;
        }
        if (this.thirdPhase && !this.playedTransitionAnimation) {
            animationState.getController().forceAnimationReset();
            animationState.getController().setAnimation(RawAnimation.begin().then("transition_third_phase", Animation.LoopType.PLAY_ONCE));
            this.playedTransitionAnimation = true;
            this.inTransitionPhase = true;
            return PlayState.CONTINUE;
        }
        if (this.inTransitionPhase && animationState.getController().getAnimationState() != AnimationController.State.STOPPED) {
            return PlayState.CONTINUE;
        }
        if (this.inTransitionPhase && animationState.getController().getAnimationState() == AnimationController.State.STOPPED) {
            this.inTransitionPhase = false;
        }
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then(walkAnimation, Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then(idleAnimation, Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        String attackAnimation = "attack";
        if (this.secondPhase || this.thirdPhase) {
            attackAnimation = "second_phase_attack";
        }
        if (this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(attackAnimation, Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState raisePredicate(AnimationState state) {
        String raiseAnimation = "raise";
        if (this.secondPhase || this.thirdPhase) {
            raiseAnimation = "second_phase_raise";
        }
        if (this.getSpawn() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(raiseAnimation, Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState spawnPredicate(AnimationState state) {
        if (!this.getHasSpawned()) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE));
            this.setHasSpawned(true);
        }
        return PlayState.CONTINUE;
    }

    private PlayState shootingPredicate(AnimationState state) {
        String shootAnimation = "shoot";
        if (this.secondPhase) {
            shootAnimation = "second_phase_shoot";
        }
        if (this.isShooting() && !this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(shootAnimation, Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.SWING, this.method_5634(), 0.5f, 0.85f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spawning", 0, this::spawnPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_SPAWN, this.method_5634(), 0.65f, 1.0f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "raise", 0, this::raisePredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_RAISE, this.method_5634(), 0.65f, 1.0f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shooting", 0, this::shootingPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_SHOOT, this.method_5634(), 0.65f, 1.0f);
            }
        })});
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        if (this.field_6012 % 100 == 0) {
            this.applyMiningFatigue();
        }
        if (!this.method_37908().method_8608()) {
            this.updateBossBar();
            this.checkPlayerDeaths();
        }
        if (!this.secondPhase && (double)this.bossBar.method_5412() <= 0.66 && this.secondPhaseTransitionDelay == -1) {
            this.secondPhaseTransitionDelay = 20;
            this.secondPhase = true;
            this.playedTransitionAnimation = false;
        }
        if (this.secondPhaseTransitionDelay > 0) {
            --this.secondPhaseTransitionDelay;
            if (this.secondPhaseTransitionDelay == 0) {
                this.enterSecondPhase();
            }
        }
        if (!this.thirdPhase && (double)this.bossBar.method_5412() <= 0.31 && this.thirdPhaseTransitionDelay == -1) {
            this.thirdPhaseTransitionDelay = 20;
            this.thirdPhase = true;
            this.playedTransitionAnimation = false;
        }
        if (this.thirdPhaseTransitionDelay > 0) {
            --this.thirdPhaseTransitionDelay;
            if (this.thirdPhaseTransitionDelay == 0) {
                this.enterThirdPhase();
            }
        }
        if (this.secondPhase && this.method_37908().method_8608()) {
            this.spawnHoveringParticles(0.7, 2.2);
        }
        if (this.thirdPhase && this.method_37908().method_8608()) {
            this.spawnHoveringParticles(0.5, 2.0);
            this.spawnHoveringParticles(1.0, 2.5);
            this.spawnHoveringParticles(1.5, 3.0);
            this.spawnHoveringParticles(2.0, 3.5);
            this.spawnHoveringParticles(2.5, 3.5);
            this.spawnHoveringParticles(3.0, 3.5);
            this.spawnHoveringParticles(3.5, 3.0);
            this.spawnHoveringParticles(4.0, 2.5);
            this.spawnHoveringParticles(4.5, 2.0);
        }
        if (this.thirdPhase) {
            this.reflectProjectiles();
        }
        if (this.thirdPhase && this.field_6012 % 20 == 0) {
            this.applySlownessEffectToNearbyEntities();
        }
        if (this.field_6012 < 40 || this.getSpawn() || this.isShooting()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
        } else if (Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6194() == 0.0 && !this.getSpawn() && !this.isShooting()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)0.57f);
        }
    }

    private void enterThirdPhase() {
        class_1657 player;
        this.secondPhase = false;
        this.method_6092(new class_1293(class_1294.field_5910, 1600, 1, false, false, true));
        this.method_6092(new class_1293(class_1294.field_5907, 3200, 2, false, false, true));
        this.method_6092(new class_1293(class_1294.field_5918, 4800, 0, false, false, true));
        if (this.method_37908().field_9236 && (player = ClientUtils.getClientPlayer()) != null) {
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_BOSS_SECOND_PHASE, this.method_5634(), 0.85f, 1.0f);
        }
        this.repelNearbyEntities(1.8);
    }

    private void applySlownessEffectToNearbyEntities() {
        class_238 area = new class_238(this.method_24515()).method_1014(4.0);
        List nearbyEntities = this.method_37908().method_8390(class_1309.class, area, entity -> entity != this);
        for (class_1309 entity2 : nearbyEntities) {
            entity2.method_6092(new class_1293(class_1294.field_5909, 40, 1, false, false, false));
        }
    }

    private void reflectProjectiles() {
        class_238 detectionBox = new class_238(this.method_24515()).method_1014(4.0);
        List projectiles = this.method_37908().method_8390(class_1676.class, detectionBox, projectile -> projectile != null && !projectile.method_31481());
        for (class_1676 projectile2 : projectiles) {
            if (projectile2 instanceof MummyProjectileEntity) continue;
            this.reflectProjectile(projectile2);
        }
    }

    private void reflectProjectile(class_1676 projectile) {
        class_243 mummyPosition = this.method_19538();
        class_243 projectilePosition = projectile.method_19538();
        class_243 direction = projectilePosition.method_1020(mummyPosition).method_1029();
        projectile.method_18800(direction.field_1352, direction.field_1351 / 2.0, direction.field_1350);
    }

    private void spawnHoveringParticles(double high, double dispersion) {
        double posX = this.method_23317();
        double posY = this.method_23318() + high;
        double posZ = this.method_23321();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (this.field_5974.method_43058() - 0.5) * dispersion;
            double offsetZ = (this.field_5974.method_43058() - 0.5) * dispersion;
            this.method_37908().method_8406((class_2394)ModParticles.MUMMY_HOVERING_PARTICLE, posX + offsetX, posY, posZ + offsetZ, 0.0, -0.02, 0.0);
        }
    }

    private void applyMiningFatigue() {
        class_238 area = new class_238(this.method_24515()).method_1014(150.0);
        for (class_1657 player : this.method_37908().method_8390(class_1657.class, area, playerEntity -> true)) {
            player.method_6092(new class_1293(class_1294.field_5901, 600, 2, false, false, false));
        }
    }

    private void enterSecondPhase() {
        class_1657 player;
        this.method_6092(new class_1293(class_1294.field_5910, 1200, 0));
        this.method_6092(new class_1293(class_1294.field_5907, 2400, 1));
        this.method_6092(new class_1293(class_1294.field_5918, 3600));
        if (this.method_37908().field_9236 && (player = ClientUtils.getClientPlayer()) != null) {
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_BOSS_SECOND_PHASE, this.method_5634(), 0.85f, 1.0f);
        }
        this.repelNearbyEntities(1.5);
    }

    private void repelNearbyEntities(double force) {
        class_238 area = new class_238(this.method_24515()).method_1014(10.0);
        for (class_1309 entity : this.method_37908().method_8390(class_1309.class, area, e -> e != this)) {
            double dx = entity.method_23317() - this.method_23317();
            double dz = entity.method_23321() - this.method_23321();
            double distance = Math.sqrt(dx * dx + dz * dz);
            entity.method_5762(dx / distance * force, 0.5, dz / distance * force);
            entity.field_6037 = true;
        }
    }

    private void checkPlayerDeaths() {
        for (class_1657 player : this.method_37908().method_18456()) {
            class_3222 serverPlayer;
            if (!(player instanceof class_3222) || !(serverPlayer = (class_3222)player).method_29504()) continue;
            this.bossBar.method_14089(serverPlayer);
        }
    }

    public void method_36209() {
        super.method_36209();
        this.bossBar.method_14094();
    }

    private void updateBossBar() {
        class_238 detectionBox = new class_238(this.method_24515()).method_1014(50.0);
        for (class_1657 player : this.method_37908().method_18456()) {
            if (!(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            if (detectionBox.method_1006(player.method_19538())) {
                if (this.bossBar.method_14092().contains(serverPlayer)) continue;
                this.bossBar.method_14088(serverPlayer);
                continue;
            }
            if (!this.bossBar.method_14092().contains(serverPlayer)) continue;
            this.bossBar.method_14089(serverPlayer);
        }
    }

    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.MUMMY_HURT_1;
        }
        return ModSounds.MUMMY_HURT_2;
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.bossBar.method_14091(false);
        this.bossBar.method_14094();
        if (!this.method_37908().field_9236) {
            int xpAmount;
            for (int xpToDrop = 240 + this.field_5974.method_43048(61); xpToDrop > 0; xpToDrop -= xpAmount) {
                xpAmount = class_1303.method_5918((int)xpToDrop);
                this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), xpAmount));
            }
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337) || source.method_49708(class_8111.field_42338)) {
            amount *= 2.0f;
        }
        return super.method_5643(source, amount);
    }

    protected class_3414 method_6002() {
        return ModSounds.MUMMY_DEATH;
    }

    protected class_3414 method_5994() {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.MUMMY_AMBIENT_1;
        }
        return ModSounds.MUMMY_AMBIENT_2;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        EgyptiantVariant variant = (EgyptiantVariant)((Object)class_156.method_27173((Object[])EgyptiantVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        if (this.bossBarName == null || this.bossBarName.isEmpty()) {
            this.bossBarName = this.generateRandomBossName();
            this.bossBar.method_5413(class_2561.method_30163((String)this.bossBarName));
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public EgyptiantVariant getVariant() {
        return EgyptiantVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(EgyptiantVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSpawned", true);
        nbt.method_10582("BossBarName", this.bossBarName);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSpawned(nbt.method_10577("HasSpawned"));
        if (nbt.method_10545("BossBarName")) {
            this.bossBarName = nbt.method_10558("BossBarName");
            this.bossBar.method_5413(class_2561.method_30163((String)this.bossBarName));
        } else {
            this.bossBarName = this.generateRandomBossName();
            this.bossBar.method_5413(class_2561.method_30163((String)this.bossBarName));
        }
    }

    private String generateRandomBossName() {
        String[] names = new String[]{"Khendjer", "Djedkare", "Seti", "Raneferef", "Hatshepsut", "Taharka", "Sheshonq", "Sobekhotep", "Hakor", "Menes", "Thoutmosis"};
        String[] suffixes = new String[]{"", "II", "III", "IV", "V"};
        Random random = new Random();
        String randomName = names[random.nextInt(names.length)];
        String randomSuffix = suffixes[random.nextInt(suffixes.length)];
        return randomName + " " + randomSuffix;
    }
}

