/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.egyptian;

import java.util.Objects;
import net.mebahel.antiquebeasts.entity.ai.WadjetLookAtTargetGoal;
import net.mebahel.antiquebeasts.entity.ai.WadjetShootingGoal;
import net.mebahel.antiquebeasts.entity.ai.util.GroupRevengeGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.variant.WadjetVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class WadjetEntity
extends EgyptianEntity
implements GeoEntity {
    double rand;
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final class_2940<Float> COOLDOWN = class_2945.method_12791(WadjetEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(WadjetEntity.class, (class_2941)class_2943.field_13323);

    public WadjetEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    public float getCooldown() {
        return ((Float)this.field_6011.method_12789(COOLDOWN)).floatValue();
    }

    public void setCooldown(float cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(COOLDOWN, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(IS_IN_CARAVAN, (Object)false);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(PATROL_UUID, (Object)"");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving() && !this.isShooting()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("walk2", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!this.isShooting() && !animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.isShooting()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
        } else {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)0.63f);
        }
    }

    private PlayState shootingPredicate(AnimationState state) {
        if (this.isShooting() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack2", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shooting", 0, this::shootingPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.WADJET_SPIT_1, this.method_5634(), 0.8f, 1.25f);
            }
        })});
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.63f).method_26868(class_5134.field_23716, 40.0 + (double)ModBonusHealthConfig.wadjetBonusHealth).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23718, (double)0.1f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new WadjetShootingGoal(this, 128.0f));
        this.field_6201.method_6277(3, (class_1352)new WadjetLookAtTargetGoal(this));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.35f, 1.0f));
        this.field_6185.method_6277(1, (class_1352)new GroupRevengeGoal((class_1314)this, EgyptianEntity.class).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DraugrEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    protected class_3414 method_5994() {
        this.rand = Math.random();
        if (this.rand < 0.3) {
            return ModSounds.WADJET_AMBIENT_1;
        }
        if (this.rand > 0.3 && this.rand < 0.6) {
            return ModSounds.WADJET_AMBIENT_2;
        }
        return ModSounds.WADJET_AMBIENT_3;
    }

    protected class_3414 method_6002() {
        return ModSounds.WADJET_DEATH_1;
    }

    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.WADJET_HURT_1;
        }
        return ModSounds.WADJET_HURT_2;
    }

    @Override
    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, 0.35f, 1.0f);
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        WadjetVariant variant = (WadjetVariant)((Object)class_156.method_27173((Object[])WadjetVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return entityData;
    }

    public WadjetVariant getVariant() {
        return WadjetVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(WadjetVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void performJump(class_243 direction) {
        this.method_18799(direction);
        this.field_6007 = true;
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1429> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        boolean isSandyGround;
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        long time = world.method_8401().method_217();
        if (time % 24000L >= 13000L) {
            return false;
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockBelow = world.method_8320(blockPos);
        boolean bl = isSandyGround = blockBelow.method_27852(class_2246.field_10102) || blockBelow.method_27852(class_2246.field_10534);
        if (!isSandyGround) {
            return false;
        }
        if (world.method_22339(pos) < 9) {
            return false;
        }
        if (!world.method_8311(pos)) {
            return false;
        }
        int randomValue = random.method_43048(10);
        return randomValue < ModSpawnRateConfig.wadjetSpawnRate;
    }
}

