/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.greek;

import java.util.Random;
import net.mebahel.antiquebeasts.entity.ai.CentaurLookAtTargetGoal;
import net.mebahel.antiquebeasts.entity.ai.CentaurMeleeAttackGoal;
import net.mebahel.antiquebeasts.entity.ai.CentaurShootingGoal;
import net.mebahel.antiquebeasts.entity.ai.util.ModPatrolGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.custom.patrol.ModPatrolEntity;
import net.mebahel.antiquebeasts.entity.variant.CentaurVariant;
import net.mebahel.antiquebeasts.item.custom.ModItems;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class CentaurEntity
extends GreekEntity
implements GeoEntity {
    private int blinkTimer = 0;
    private int nextBlink = 0;
    double rand;
    public static final class_2940<Boolean> IS_ARCHER = class_2945.method_12791(CentaurEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public CentaurEntity(class_1299<? extends ModPatrolEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
        this.scheduleNextBlink();
    }

    @Override
    public float getCooldown() {
        return ((Float)this.field_6011.method_12789(COOLDOWN)).floatValue();
    }

    @Override
    public void setCooldown(float cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    public boolean isArcher() {
        return (Boolean)this.field_6011.method_12789(IS_ARCHER);
    }

    public void setIsArcher(boolean swinging) {
        this.field_6011.method_12778(IS_ARCHER, (Object)swinging);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.blinkTimer > 0) {
            --this.blinkTimer;
        } else if (this.nextBlink > 0) {
            --this.nextBlink;
        } else {
            this.blinkTimer = 5;
            this.scheduleNextBlink();
        }
        if (!(this.getVariant() != CentaurVariant.ARCHER && this.getVariant() != CentaurVariant.ARCHER_2 || this.isArcher())) {
            this.setIsArcher(true);
        }
    }

    private void scheduleNextBlink() {
        this.nextBlink = 80 + this.field_5974.method_43048(81);
    }

    public boolean isBlinking() {
        return this.blinkTimer > 0;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(IS_ARCHER, (Object)false);
        this.field_6011.method_12784(COOLDOWN, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack");
        this.field_6011.method_12784(PATROL_UUID, (Object)"");
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 34.0 + (double)ModBonusHealthConfig.centaurBonusHealth).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23718, (double)0.6f).method_26868(class_5134.field_23722, 0.5);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new ModPatrolGoal(this, 0.37f, 0.4f));
        this.field_6201.method_6277(3, (class_1352)new CentaurShootingGoal(this, 80.0f));
        this.field_6201.method_6277(4, (class_1352)new CentaurLookAtTargetGoal(this));
        this.field_6201.method_6277(5, (class_1352)new CentaurMeleeAttackGoal(this, 0.52f, 8.0, 1, 7));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.35f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{GreekEntity.class}).method_6318(new Class[]{GreekEntity.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DraugrEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, EgyptianEntity.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.isSwinging() && !this.isShooting() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(this.getAttackName(), Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState shootingPredicate(AnimationState state) {
        if (this.isShooting() && !this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("ranged_attack", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.SWING, this.method_5634(), 0.5f, 0.6f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shooting", 0, this::shootingPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.SWING, this.method_5634(), 0.5f, 0.6f);
            }
        })});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.HOPLITE_HURT1;
        }
        return ModSounds.HOPLITE_HURT2;
    }

    @Override
    protected class_3414 method_6002() {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.HOPLITE_DEATH1;
        }
        return ModSounds.HOPLITE_DEATH2;
    }

    @Override
    public int method_5970() {
        return 180;
    }

    @Override
    protected class_3414 method_5994() {
        class_1309 target = this.method_5968();
        this.rand = Math.random();
        if (target != null) {
            if (this.rand < 0.5) {
                return ModSounds.HOPLITE_ATTACKING1;
            }
            return ModSounds.HOPLITE_ATTACKING2;
        }
        if (this.rand < 0.3) {
            return ModSounds.HOPLITE_AMBIENT1;
        }
        if (this.rand > 0.3 && this.rand < 0.6) {
            return ModSounds.HOPLITE_AMBIENT2;
        }
        return ModSounds.HOPLITE_AMBIENT3;
    }

    @Override
    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, 0.35f, 0.92f);
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        CentaurVariant variant = (CentaurVariant)((Object)class_156.method_27173((Object[])CentaurVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        this.method_5980(null);
        return entityData;
    }

    public CentaurVariant getVariant() {
        return CentaurVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(CentaurVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void performJump(class_243 direction) {
        this.method_18799(direction);
        this.field_6007 = true;
    }

    protected void method_16078() {
        super.method_16078();
        if (!this.method_37908().field_9236) {
            Random random = new Random();
            if (random.nextInt(30) == 0 && this.isArcher()) {
                this.method_5706((class_1935)ModItems.GREEK_COMPOSITE_BOW);
            } else if (random.nextInt(30) == 0 && !this.isArcher()) {
                this.method_5706((class_1935)ModItems.IRON_CENTAUR_SWORD);
            }
        }
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1429> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        long time = world.method_8401().method_217();
        if (time % 24000L >= 13000L) {
            return false;
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockBelow = world.method_8320(blockPos);
        boolean isGrassyGround = blockBelow.method_27852(class_2246.field_10479);
        if (!isGrassyGround) {
            return false;
        }
        if (world.method_22339(pos) < 9) {
            return false;
        }
        if (!world.method_8311(pos)) {
            return false;
        }
        int randomValue = random.method_43048(10);
        return randomValue < ModSpawnRateConfig.centaurSpawnRate;
    }
}

