/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.norse;

import net.mebahel.antiquebeasts.entity.ai.ValkyrieHealingGoal;
import net.mebahel.antiquebeasts.entity.ai.ValkyrieMeleeAttackGoal;
import net.mebahel.antiquebeasts.entity.ai.util.GroupRevengeGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.variant.ValkyrieVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class ValkyrieEntity
extends NorseEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final class_2940<Boolean> HEALING = class_2945.method_12791(ValkyrieEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<String> ATTACK_NAME = class_2945.method_12791(ValkyrieEntity.class, (class_2941)class_2943.field_13326);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setHealing(boolean healing) {
        this.field_6011.method_12778(HEALING, (Object)healing);
    }

    public boolean isHealing() {
        return (Boolean)this.field_6011.method_12789(HEALING);
    }

    @Override
    public void setAttackName(String attackName) {
        this.field_6011.method_12778(ATTACK_NAME, (Object)attackName);
    }

    @Override
    public String getAttackName() {
        return (String)this.field_6011.method_12789(ATTACK_NAME);
    }

    public ValkyrieEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(HEALING, (Object)false);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(PATROL_UUID, (Object)"");
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack");
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.76f).method_26868(class_5134.field_23716, 34.0 + (double)ModBonusHealthConfig.valkyrieBonusHealth).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23718, (double)0.35f).method_26868(class_5134.field_23722, 0.5);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new ValkyrieHealingGoal(this, 16.0));
        this.field_6201.method_6277(3, (class_1352)new ValkyrieMeleeAttackGoal(this, 0.53f));
        if (!this.isHealing()) {
            this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, (double)0.35f, 1.0f));
            this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        }
        this.field_6185.method_6277(1, (class_1352)new GroupRevengeGoal((class_1314)this, NorseEntity.class).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DraugrEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, EgyptianEntity.class, true));
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle_to_walk", Animation.LoopType.PLAY_ONCE).then("walk2", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(this.getAttackName(), Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState healingPredicate(AnimationState state) {
        if (this.isHealing() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("heal", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14947, this.method_5634(), 0.8f, 0.8f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.SWING, this.method_5634(), 0.8f, 1.0f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "healing", 0, this::healingPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.HEAL, this.method_5634(), 1.0f, 1.0f);
            }
        })});
    }

    public boolean method_5643(class_1282 source, float amount) {
        return super.method_5643(source, amount);
    }

    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.VALKYRIE_HURT1;
        }
        return ModSounds.VALKYRIE_HURT2;
    }

    protected class_3414 method_6002() {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.VALKYRIE_DEATH1;
        }
        return ModSounds.VALKYRIE_DEATH2;
    }

    protected class_3414 method_5994() {
        class_1309 target = this.method_5968();
        this.rand = Math.random();
        if (target != null) {
            if (this.rand < 0.3) {
                return ModSounds.VALKYRIE_ATTACK1;
            }
            if (this.rand > 0.3 && this.rand < 0.6) {
                return ModSounds.VALKYRIE_ATTACK2;
            }
            return ModSounds.VALKYRIE_ATTACK3;
        }
        if (this.rand < 0.3) {
            return ModSounds.VALKYRIE_AMBIENT1;
        }
        if (this.rand > 0.3 && this.rand < 0.6) {
            return ModSounds.VALKYRIE_AMBIENT2;
        }
        return ModSounds.VALKYRIE_AMBIENT3;
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, 0.35f, 1.0f);
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        ValkyrieVariant variant = (ValkyrieVariant)((Object)class_156.method_27173((Object[])ValkyrieVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return entityData;
    }

    public ValkyrieVariant getVariant() {
        return ValkyrieVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(ValkyrieVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1429> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        boolean isSnowyGround;
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        long time = world.method_8401().method_217();
        if (time % 24000L >= 13000L) {
            return false;
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockBelow = world.method_8320(blockPos);
        boolean bl = isSnowyGround = blockBelow.method_27852(class_2246.field_10491) || blockBelow.method_27852(class_2246.field_27879) || blockBelow.method_27852(class_2246.field_10219) || blockBelow.method_27852(class_2246.field_10566) || blockBelow.method_27852(class_2246.field_10477);
        if (!isSnowyGround) {
            return false;
        }
        if (world.method_22339(pos) < 9) {
            return false;
        }
        if (!world.method_8311(pos.method_10084())) {
            return false;
        }
        int randomValue = random.method_43048(10);
        return randomValue < ModSpawnRateConfig.valkyrieSpawnRate;
    }
}

