/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.other;

import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.mebahel.antiquebeasts.entity.ai.CustomRevengeGoal;
import net.mebahel.antiquebeasts.entity.ai.other.DraugrArcherShootingGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.variant.DraugrArcherVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class DraugrArcherEntity
extends DraugrEntity
implements GeoEntity {
    public static final class_2940<Float> COOLDOWN = class_2945.method_12791(DraugrArcherEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(DraugrArcherEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    double rand;
    public static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(DraugrArcherEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SWINGING = class_2945.method_12791(DraugrArcherEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<String> ATTACK_NAME = class_2945.method_12791(DraugrArcherEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Boolean> HAS_SPAWNED = class_2945.method_12791(DraugrArcherEntity.class, (class_2941)class_2943.field_13323);

    public DraugrArcherEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    public float getCooldown() {
        return ((Float)this.field_6011.method_12789(COOLDOWN)).floatValue();
    }

    public void setCooldown(float cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public boolean getHasSpawned() {
        return (Boolean)this.field_6011.method_12789(HAS_SPAWNED);
    }

    @Override
    public void setHasSpawned(boolean bool) {
        this.field_6011.method_12778(HAS_SPAWNED, (Object)bool);
    }

    @Override
    public void setSwinging(boolean swinging) {
        this.field_6011.method_12778(SWINGING, (Object)swinging);
    }

    @Override
    public boolean isSwinging() {
        return (Boolean)this.field_6011.method_12789(SWINGING);
    }

    @Override
    public void setAttackName(String attackName) {
        this.field_6011.method_12778(ATTACK_NAME, (Object)attackName);
    }

    @Override
    public String getAttackName() {
        return (String)this.field_6011.method_12789(ATTACK_NAME);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack");
        this.field_6011.method_12784(COOLDOWN, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(HAS_SPAWNED, (Object)true);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DraugrArcherShootingGoal(this));
        this.field_6185.method_6277(1, (class_1352)new CustomRevengeGoal((class_1314)this, DraugrEntity.class));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, EgyptianEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23716, 30.0 + (double)ModBonusHealthConfig.draugrArcherBonusHealth).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23718, (double)0.2f).method_26868(class_5134.field_23722, 0.5);
    }

    private PlayState predicate(AnimationState animationState) {
        if (!this.getHasSpawned()) {
            return PlayState.STOP;
        }
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!animationState.isMoving() && !this.method_6510()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::shootingPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spawning", 0, this::spawnPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_SPAWN, this.method_5634(), 0.65f, 1.0f);
            }
        })});
    }

    private PlayState shootingPredicate(AnimationState state) {
        if (this.isShooting() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("shoot", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private PlayState spawnPredicate(AnimationState state) {
        if (!this.getHasSpawned()) {
            state.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE));
            if (state.getController().getAnimationState() != AnimationController.State.STOPPED) {
                this.spawnHoveringParticles();
            } else {
                this.setHasSpawned(true);
            }
        }
        return PlayState.CONTINUE;
    }

    public DraugrArcherVariant getArcherVariant() {
        return DraugrArcherVariant.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(DraugrArcherVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_6880 biome = world.method_23753(this.method_24515());
        DraugrArcherVariant variant = biome.method_40220(ConventionalBiomeTags.DESERT) || biome.method_40220(ConventionalBiomeTags.BADLANDS) ? DraugrArcherVariant.HOT : (biome.method_40220(ConventionalBiomeTags.CLIMATE_COLD) || biome.method_40220(ConventionalBiomeTags.SNOWY) || biome.method_40220(ConventionalBiomeTags.ICY) || biome.method_40220(ConventionalBiomeTags.AQUATIC_ICY) || biome.method_40220(ConventionalBiomeTags.TAIGA) ? DraugrArcherVariant.COLD : DraugrArcherVariant.TEMPERATE);
        this.setVariant(variant);
        this.method_5980(null);
        return entityData;
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random, Boolean draugrCanSpawnInDark) {
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        if (draugrCanSpawnInDark.booleanValue()) {
            class_2338 blockPos = pos.method_10074();
            if (!world.method_8320(blockPos).method_26170((class_1922)world, blockPos, type)) {
                return false;
            }
            int randomValue = random.method_43048(10);
            return randomValue < ModSpawnRateConfig.draugrArcherSpawnRate;
        }
        return false;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.DRAUGR_HURT_1;
        }
        return ModSounds.DRAUGR_HURT_2;
    }

    @Override
    protected class_3414 method_6002() {
        return ModSounds.DRAUGR_DEATH_1;
    }

    @Override
    protected class_3414 method_5994() {
        this.rand = Math.random();
        if (this.rand < 0.3) {
            return ModSounds.DRAUGR_AMBIENT_1;
        }
        if (this.rand > 0.3 && this.rand < 0.6) {
            return ModSounds.DRAUGR_AMBIENT_2;
        }
        return ModSounds.DRAUGR_AMBIENT_3;
    }

    @Override
    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, 0.8f, 1.0f);
        }
    }

    @Override
    public int method_5970() {
        return 200;
    }

    public void performJump(class_243 direction) {
        this.method_18799(direction);
        this.field_6007 = true;
    }
}

