/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.other;

import java.util.Objects;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.mebahel.antiquebeasts.entity.ai.CustomRevengeGoal;
import net.mebahel.antiquebeasts.entity.ai.other.DraugrMeleeAttackGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrOverlordEntity;
import net.mebahel.antiquebeasts.entity.variant.DraugrVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class DraugrEntity
extends class_1588
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    double rand;
    public static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SWINGING = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_PART_OF_RAID = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<String> ATTACK_NAME = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Boolean> HAS_SPAWNED = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public double speed;

    public DraugrEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
        this.speed = Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6194();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean shouldDespawnInPeaceful() {
        return this.method_37908().method_8407() == class_1267.field_5801;
    }

    public boolean getHasSpawned() {
        return (Boolean)this.field_6011.method_12789(HAS_SPAWNED);
    }

    public void setHasSpawned(boolean bool) {
        this.field_6011.method_12778(HAS_SPAWNED, (Object)bool);
    }

    public boolean isPartOfRaid() {
        return (Boolean)this.field_6011.method_12789(IS_PART_OF_RAID);
    }

    public void setPartOfRaid(Boolean isPartOfRaid) {
        this.field_6011.method_12778(IS_PART_OF_RAID, (Object)isPartOfRaid);
    }

    public void setSwinging(boolean swinging) {
        this.field_6011.method_12778(SWINGING, (Object)swinging);
    }

    public boolean isSwinging() {
        return (Boolean)this.field_6011.method_12789(SWINGING);
    }

    public void setAttackName(String attackName) {
        this.field_6011.method_12778(ATTACK_NAME, (Object)attackName);
    }

    public String getAttackName() {
        return (String)this.field_6011.method_12789(ATTACK_NAME);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(IS_PART_OF_RAID, (Object)false);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack");
        this.field_6011.method_12784(HAS_SPAWNED, (Object)true);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DraugrMeleeAttackGoal(this, 1.0, 25, 15, 10));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.85f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new CustomRevengeGoal((class_1314)this, DraugrEntity.class));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, EgyptianEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23716, 30.0 + (double)ModBonusHealthConfig.draugrBonusHealth).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23718, (double)0.2f).method_26868(class_5134.field_23722, 0.5);
    }

    private PlayState predicate(AnimationState animationState) {
        if (!this.getHasSpawned()) {
            return PlayState.STOP;
        }
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("transition_walk", Animation.LoopType.PLAY_ONCE).then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!animationState.isMoving() && !this.method_6510()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(this.getAttackName(), Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.SWING, this.method_5634(), 0.7f, 1.1f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spawning", 0, this::spawnPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_SPAWN, this.method_5634(), 0.65f, 1.0f);
            }
        })});
    }

    public DraugrVariant getVariant() {
        return DraugrVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(DraugrVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_6880 biome = world.method_23753(this.method_24515());
        boolean useAxeVariant = this.field_5974.method_43056();
        DraugrVariant variant = biome.method_40220(ConventionalBiomeTags.DESERT) || biome.method_40220(ConventionalBiomeTags.BADLANDS) ? (useAxeVariant ? DraugrVariant.HOT_AXE : DraugrVariant.HOT) : (biome.method_40220(ConventionalBiomeTags.CLIMATE_COLD) || biome.method_40220(ConventionalBiomeTags.SNOWY) || biome.method_40220(ConventionalBiomeTags.ICY) || biome.method_40220(ConventionalBiomeTags.AQUATIC_ICY) || biome.method_40220(ConventionalBiomeTags.TAIGA) ? (useAxeVariant ? DraugrVariant.COLD_AXE : DraugrVariant.COLD) : (useAxeVariant ? DraugrVariant.TEMPERATE_AXE : DraugrVariant.TEMPERATE));
        this.setVariant(variant);
        this.method_5980(null);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected class_3414 method_6011(class_1282 source) {
        double rand = Math.random();
        if (rand < 0.25) {
            return ModSounds.DRAUGR_HURT_1;
        }
        if (rand < 0.5) {
            return ModSounds.DRAUGR_HURT_2;
        }
        if (rand < 0.75) {
            return ModSounds.DRAUGR_HURT_3;
        }
        return ModSounds.DRAUGR_HURT_4;
    }

    protected class_3414 method_6002() {
        return ModSounds.DRAUGR_DEATH_1;
    }

    protected class_3414 method_5994() {
        double rand = Math.random();
        if (rand < 0.2) {
            return ModSounds.DRAUGR_AMBIENT_1;
        }
        if (rand < 0.4) {
            return ModSounds.DRAUGR_AMBIENT_2;
        }
        if (rand < 0.6) {
            return ModSounds.DRAUGR_AMBIENT_3;
        }
        if (rand < 0.8) {
            return ModSounds.DRAUGR_AMBIENT_4;
        }
        return ModSounds.DRAUGR_AMBIENT_5;
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, 0.8f, 1.0f);
        }
    }

    public int method_5970() {
        return 160 + this.method_6051().method_43048(60);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) {
            return super.method_5643(source, amount * 2.0f);
        }
        if (source.method_49708(class_8111.field_42354)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.isPartOfRaid() && this.field_6012 >= 1000 && !this.method_5851()) {
            this.method_5834(true);
        }
        if (this instanceof DraugrOverlordEntity) {
            if (this.field_6012 < 30 && this.isPartOfRaid() && !this.getHasSpawned()) {
                Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
            } else if (Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6194() == 0.0 && !((DraugrOverlordEntity)this).getSpecial() && this.isPartOfRaid()) {
                Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(this.speed);
            }
        } else if (this.field_6012 < 30 && this.isPartOfRaid() && !this.getHasSpawned()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
        } else if (Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6194() == 0.0 && this.isPartOfRaid()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(this.speed);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
        nbt.method_10556("PartOfRaid", this.isPartOfRaid());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
        this.field_6011.method_12778(IS_PART_OF_RAID, (Object)nbt.method_10577("PartOfRaid"));
        this.field_6011.method_12778(HAS_SPAWNED, (Object)true);
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
    }

    private PlayState spawnPredicate(AnimationState state) {
        if (!this.getHasSpawned()) {
            state.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE));
            if (state.getController().getAnimationState() != AnimationController.State.STOPPED) {
                this.spawnHoveringParticles();
            } else {
                this.setHasSpawned(true);
            }
        }
        return PlayState.CONTINUE;
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random, Boolean draugrCanSpawnInDark) {
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        if (draugrCanSpawnInDark.booleanValue()) {
            class_2338 blockPos = pos.method_10074();
            if (!world.method_8320(blockPos).method_26170((class_1922)world, blockPos, type)) {
                return false;
            }
            int randomValue = random.method_43048(10);
            return randomValue < ModSpawnRateConfig.draugrSpawnRate;
        }
        return false;
    }

    void spawnHoveringParticles() {
        double posX = this.method_23317();
        double posY = this.method_23318() - 0.1;
        double posZ = this.method_23321();
        class_2338 blockPos = new class_2338((int)posX, (int)(this.method_23318() - 0.5), (int)posZ);
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (!blockState.method_26215()) {
            for (int i = 0; i < 3; ++i) {
                double offsetX = (this.field_5974.method_43058() - 0.5) * 0.1;
                double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.1;
                double velocityY = 0.1;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), posX + offsetX, posY, posZ + offsetZ, 0.0, velocityY, 0.0);
            }
        }
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }
}

