/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.other;

import java.util.Objects;
import net.mebahel.antiquebeasts.entity.ai.CustomRevengeGoal;
import net.mebahel.antiquebeasts.entity.ai.other.HarpyFlyGoal;
import net.mebahel.antiquebeasts.entity.ai.other.HarpyRangedAttackGoal;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.variant.HarpyVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class HarpyEntity
extends class_1429
implements GeoEntity {
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(HarpyEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SWINGING = class_2945.method_12791(HarpyEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> COOLDOWN = class_2945.method_12791(HarpyEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<String> ATTACK_NAME = class_2945.method_12791(HarpyEntity.class, (class_2941)class_2943.field_13326);
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(HarpyEntity.class, (class_2941)class_2943.field_13327);

    public HarpyEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
        this.method_5941(class_7.field_14, 0.0f);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_3, 0.0f);
    }

    public boolean method_5809() {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public float getFireBreathingCooldown() {
        return ((Float)this.field_6011.method_12789(COOLDOWN)).floatValue();
    }

    public void setFireBreathingCooldown(float cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    public boolean isFireBreathing() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    public void setSwinging(boolean swinging) {
        this.field_6011.method_12778(SWINGING, (Object)swinging);
    }

    public boolean isSwinging() {
        return (Boolean)this.field_6011.method_12789(SWINGING);
    }

    public void setFireBreathing(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    public void setAttackName(String attackName) {
        this.field_6011.method_12778(ATTACK_NAME, (Object)attackName);
    }

    public String getAttackName() {
        return (String)this.field_6011.method_12789(ATTACK_NAME);
    }

    private boolean shouldDespawnInPeaceful() {
        return this.method_37908().method_8407() == class_1267.field_5801;
    }

    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.getFireBreathingCooldown() < 16.0f) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
        } else if (Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6194() == 0.0 && this.getFireBreathingCooldown() >= 16.0f) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)0.65f);
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(COOLDOWN, (Object)Float.valueOf(80.0f));
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"lion_shoot");
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23716, 24.0 + (double)ModBonusHealthConfig.harpyBonusHealth).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23718, 0.2).method_26868(class_5134.field_23722, 0.4);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new HarpyRangedAttackGoal(this, 0.25, 8.0, 20, 4, 10));
        this.field_6201.method_6277(3, (class_1352)new HarpyFlyGoal((class_1314)this, 0.25, 4, 8));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new CustomRevengeGoal((class_1314)this, HarpyEntity.class));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DraugrEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, EgyptianEntity.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("transition_walk", Animation.LoopType.PLAY_ONCE).then("walking", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState shootingPredicate(AnimationState state) {
        if (this.isFireBreathing() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.PEGASUS_FLAP_1, this.method_5634(), 0.45f, 4.5f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shooting", 0, this::shootingPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.HARPY_HURT_2;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    protected class_3414 method_6002() {
        return ModSounds.HARPY_DEATH_1;
    }

    public int method_5970() {
        return 240;
    }

    protected class_3414 method_5994() {
        return ModSounds.HARPY_HURT_1;
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, 0.25f, 1.0f);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        HarpyVariant variant = (HarpyVariant)((Object)class_156.method_27173((Object[])HarpyVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return entityData;
    }

    public HarpyVariant getVariant() {
        return HarpyVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(HarpyVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1429> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        long time = world.method_8401().method_217();
        if (time % 24000L >= 13000L) {
            return false;
        }
        class_2338 blockPos = pos.method_10074();
        if (!world.method_8320(blockPos).method_26170((class_1922)world, blockPos, type)) {
            return false;
        }
        if (!world.method_8311(pos)) {
            return false;
        }
        int randomValue = random.method_43048(10);
        return randomValue < ModSpawnRateConfig.harpySpawnRate;
    }
}

