/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.mebahel.antiquebeasts.AntiqueBeasts;
import net.mebahel.antiquebeasts.entity.ModEntities;
import net.mebahel.antiquebeasts.entity.ai.util.ModPatrolGoal;
import net.mebahel.antiquebeasts.entity.custom.egyptian.AxemanEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.CamelryEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.CentaurEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.ChampionHopliteEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.EliteHopliteEntity;
import net.mebahel.antiquebeasts.entity.custom.patrol.ModPatrolEntity;
import net.mebahel.antiquebeasts.util.config.ModConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_6880;

public class PatrolManager {
    private static final int CHECK_INTERVAL = 1200 * ModConfig.patrolSpawnDelay;
    private static int patrolCheckCounter = 0;
    private static final Map<class_3218, ServerTickEvents.EndTick> registeredListeners = new HashMap<class_3218, ServerTickEvents.EndTick>();

    public static void register() {
        if (!ModConfig.patrolSpawning) {
            AntiqueBeasts.LOGGER.info("[Mebahel's Antique Beasts] Patrol spawning is disabled in config file.");
            return;
        }
        AntiqueBeasts.LOGGER.info("[Mebahel's Antique Beasts] Registering patrol spawning for antiquebeasts.");
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179) {
                ServerTickEvents.EndTick listener = serverTick -> {
                    if (serverTick.method_3847(class_1937.field_25179) == world && ++patrolCheckCounter >= CHECK_INTERVAL) {
                        patrolCheckCounter = 0;
                        PatrolManager.checkAndSpawnPatrol(world);
                    }
                };
                ServerTickEvents.END_SERVER_TICK.register((Object)listener);
                registeredListeners.put(world, listener);
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179) {
                registeredListeners.remove(world);
                AntiqueBeasts.LOGGER.info("[Mebahel's Antique Beasts] World unloaded, event listener removed.");
            }
        });
    }

    private static void checkAndSpawnPatrol(class_3218 world) {
        class_2338 spawnPos;
        Random random;
        class_1657 randomPlayer;
        List players = world.method_18456();
        if (!players.isEmpty() && (randomPlayer = (class_1657)players.get((random = new Random()).nextInt(players.size()))).method_5805() && (spawnPos = PatrolManager.findSpawnPosition(world, randomPlayer)) != null) {
            UUID patrolId = UUID.randomUUID();
            PatrolManager.spawnPatrol(world, spawnPos, patrolId, randomPlayer);
            System.out.println("Patrol spawning for antiquebeasts at : " + String.valueOf(spawnPos));
        }
    }

    private static class_2338 findSpawnPosition(class_3218 world, class_1657 player) {
        Random random = new Random();
        int signX = random.nextBoolean() ? 1 : -1;
        int signZ = random.nextBoolean() ? 1 : -1;
        int offsetX = signX * (35 + random.nextInt(11));
        int offsetZ = signZ * (35 + random.nextInt(11));
        class_2338 roughSpawnPos = player.method_24515().method_10069(offsetX, 0, offsetZ);
        return PatrolManager.findSafeSpawnPosition(world, roughSpawnPos);
    }

    private static class_2338 findSafeSpawnPosition(class_3218 world, class_2338 pos) {
        class_2338 checkPos;
        int y;
        int playerY = pos.method_10264();
        boolean foundWater = false;
        for (y = playerY; y >= world.method_31607(); --y) {
            checkPos = new class_2338(pos.method_10263(), y, pos.method_10260());
            if (world.method_8320(checkPos).method_51176()) {
                foundWater = true;
                break;
            }
            if (world.method_8320(checkPos).method_26215() || !world.method_8320(checkPos.method_10084()).method_26215()) continue;
            return checkPos.method_10084();
        }
        for (y = playerY; y <= world.method_31600(); ++y) {
            checkPos = new class_2338(pos.method_10263(), y, pos.method_10260());
            if (world.method_8320(checkPos).method_51176()) {
                foundWater = true;
                break;
            }
            if (world.method_8320(checkPos).method_26215() || !world.method_8320(checkPos.method_10084()).method_26215()) continue;
            return checkPos.method_10084();
        }
        if (foundWater) {
            class_2338 checkPos2;
            int y2;
            class_2338 mirroredPos = new class_2338(-pos.method_10263(), pos.method_10264(), -pos.method_10260());
            foundWater = false;
            for (y2 = playerY; y2 >= world.method_31607(); --y2) {
                checkPos2 = new class_2338(mirroredPos.method_10263(), y2, mirroredPos.method_10260());
                if (world.method_8320(checkPos2).method_51176()) {
                    foundWater = true;
                    break;
                }
                if (world.method_8320(checkPos2).method_26215() || !world.method_8320(checkPos2.method_10084()).method_26215()) continue;
                return checkPos2.method_10084();
            }
            for (y2 = playerY; y2 <= world.method_31600(); ++y2) {
                checkPos2 = new class_2338(mirroredPos.method_10263(), y2, mirroredPos.method_10260());
                if (world.method_8320(checkPos2).method_51176()) {
                    foundWater = true;
                    break;
                }
                if (world.method_8320(checkPos2).method_26215() || !world.method_8320(checkPos2.method_10084()).method_26215()) continue;
                return checkPos2.method_10084();
            }
            if (foundWater) {
                System.out.println("Patrol spawn canceled: Water detected twice. Adding 1 minute to spawn delay.");
                patrolCheckCounter = -1200;
                return null;
            }
        }
        return world.method_8598(class_2902.class_2903.field_13203, pos);
    }

    private static void spawnPatrol(class_3218 world, class_2338 pos, UUID patrolId, class_1657 player) {
        Random random = new Random();
        class_2338 leaderPos = PatrolManager.getOffsetPosition(pos, random);
        class_2338 distantTarget = ModPatrolGoal.setRandomPatrolTarget(world, pos);
        class_6880 biome = world.method_23753(player.method_24515());
        if (biome.method_40220(ConventionalBiomeTags.PLAINS) || biome.method_40220(ConventionalBiomeTags.FOREST)) {
            PatrolManager.spawnPatrolLeader(world, ModEntities.CHAMPION_HOPLITE, leaderPos, distantTarget, random, patrolId);
            PatrolManager.spawnPatrolMember(world, ModEntities.CENTAUR, 1, pos, distantTarget, random, patrolId);
            PatrolManager.spawnPatrolMember(world, ModEntities.ELITE_HOPLITE, 2 + random.nextInt(2), pos, distantTarget, random, patrolId);
        } else {
            PatrolManager.spawnPatrolLeader(world, ModEntities.CAMELRY, leaderPos, distantTarget, random, patrolId);
            PatrolManager.spawnPatrolMember(world, ModEntities.AXEMAN, 3 + random.nextInt(2), pos, distantTarget, random, patrolId);
        }
    }

    private static void spawnPatrolLeader(class_3218 world, class_1299 entityType, class_2338 pos, class_2338 target, Random random, UUID patrolId) {
        ModPatrolEntity leader = PatrolManager.createPatrolUnit(entityType, world);
        leader.setPatrolId(patrolId.toString());
        leader.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        leader.setPatrolLeader(true);
        leader.setPatrolTarget(target);
        world.method_8649((class_1297)leader);
    }

    private static void spawnPatrolMember(class_3218 world, class_1299 entityType, int count, class_2338 pos, class_2338 target, Random random, UUID patrolId) {
        for (int i = 0; i < count; ++i) {
            ModPatrolEntity member = PatrolManager.createPatrolUnit(entityType, world);
            class_2338 spawnPos = PatrolManager.getOffsetPosition(pos, random);
            member.setPatrolId(patrolId.toString());
            member.method_5814((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            member.setPatrolTarget(target);
            world.method_8649((class_1297)member);
        }
    }

    private static ModPatrolEntity createPatrolUnit(class_1299 entityType, class_3218 world) {
        return switch (entityType.method_5882()) {
            case "entity.antiquebeasts.champion_hoplite" -> new ChampionHopliteEntity(ModEntities.CHAMPION_HOPLITE, (class_1937)world);
            case "entity.antiquebeasts.centaur" -> new CentaurEntity((class_1299<? extends ModPatrolEntity>)ModEntities.CENTAUR, (class_1937)world);
            case "entity.antiquebeasts.axeman" -> new AxemanEntity((class_1299<? extends ModPatrolEntity>)ModEntities.AXEMAN, (class_1937)world);
            case "entity.antiquebeasts.camelry" -> new CamelryEntity((class_1299<? extends ModPatrolEntity>)ModEntities.CAMELRY, (class_1937)world);
            default -> new EliteHopliteEntity(ModEntities.ELITE_HOPLITE, (class_1937)world);
        };
    }

    private static class_2338 getOffsetPosition(class_2338 basePos, Random random) {
        return basePos.method_10069(-2 + random.nextInt(5), 0, -2 + random.nextInt(5));
    }
}

