/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.util.raid;

import java.util.HashMap;
import java.util.UUID;
import net.mebahel.antiquebeasts.AntiqueBeasts;
import net.mebahel.antiquebeasts.util.raid.DraugrRaidTest;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class PersistentRaidData
extends class_18 {
    private final HashMap<UUID, DraugrRaidTest> raids = new HashMap();
    private final class_3218 world;

    public PersistentRaidData(class_3218 world) {
        this.world = world;
    }

    public void addRaidByUuid(UUID raidUuid, DraugrRaidTest raid) {
        this.raids.put(raidUuid, raid);
        this.method_80();
    }

    public DraugrRaidTest getRaidByUuid(UUID raidUuid) {
        return this.raids.get(raidUuid);
    }

    public DraugrRaidTest getRaid(UUID playerUuid) {
        return this.raids.get(playerUuid);
    }

    public DraugrRaidTest getRaidByWorld(class_3218 world) {
        return this.raids.get(world);
    }

    public HashMap<UUID, DraugrRaidTest> getAllRaids() {
        return this.raids;
    }

    public void removeRaid(UUID playerUuid) {
        if (this.raids.containsKey(playerUuid)) {
            this.raids.remove(playerUuid);
            System.out.println("[PersistentRaidData] Raid supprim\u00e9 pour le joueur : " + String.valueOf(playerUuid));
        }
    }

    public void removeRaidByRaid(DraugrRaidTest raid) {
        this.raids.remove(raid);
        this.method_80();
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2487 raidsNbt = new class_2487();
        for (UUID uuid : this.raids.keySet()) {
            DraugrRaidTest raid = this.raids.get(uuid);
            class_2487 raidNbt = new class_2487();
            raid.writeNbt(raidNbt);
            raidsNbt.method_10566(uuid.toString(), (class_2520)raidNbt);
        }
        nbt.method_10566("Raids", (class_2520)raidsNbt);
        return nbt;
    }

    public static PersistentRaidData fromNbt(class_2487 nbt, class_3218 world) {
        PersistentRaidData data = new PersistentRaidData(world);
        class_2487 raidsNbt = nbt.method_10562("Raids");
        for (String uuidStr : raidsNbt.method_10541()) {
            UUID uuid = UUID.fromString(uuidStr);
            class_2487 raidCompound = raidsNbt.method_10562(uuidStr);
            boolean raidAlreadyExists = AntiqueBeasts.ongoingRaids.stream().anyMatch(raid -> raid.raidUuid.equals(uuid));
            if (raidAlreadyExists) {
                System.out.println("Raid avec UUID " + String.valueOf(uuid) + " d\u00e9j\u00e0 pr\u00e9sent dans ongoingRaids. Ignor\u00e9.");
                continue;
            }
            if (raidCompound.method_10545("activeMobs")) {
                class_2499 activeMobsList = raidCompound.method_10554("activeMobs", 10);
                boolean hasAliveMobs = false;
                for (int i = 0; i < activeMobsList.size(); ++i) {
                    class_2487 mobCompound = activeMobsList.method_10602(i);
                    UUID mobUuid = mobCompound.method_25926("UUID");
                    class_1297 entity = world.method_14190(mobUuid);
                    if (entity != null && entity.method_5805()) {
                        hasAliveMobs = true;
                        continue;
                    }
                    System.out.println("Entit\u00e9 introuvable ou morte : " + String.valueOf(mobUuid));
                }
                if (!hasAliveMobs) {
                    System.out.println("Aucune entit\u00e9 active trouv\u00e9e pour le raid : " + String.valueOf(uuid) + ". Ignor\u00e9.");
                    continue;
                }
            } else {
                System.out.println("Aucune activeMobs list\u00e9e pour le raid : " + String.valueOf(uuid) + ". Ignor\u00e9.");
                continue;
            }
            System.out.println("- Chargement du raid pour UUID : " + String.valueOf(uuid));
            DraugrRaidTest raid2 = DraugrRaidTest.fromNbt(raidCompound, world);
            if (raid2 != null) {
                data.raids.put(uuid, raid2);
                continue;
            }
            System.out.println("Erreur : Impossible de charger le raid pour UUID : " + String.valueOf(uuid));
        }
        return data;
    }

    public static PersistentRaidData get(class_3218 world) {
        return (PersistentRaidData)world.method_17983().method_17924(nbt -> PersistentRaidData.fromNbt(nbt, world), () -> new PersistentRaidData(world), "draugr_raids");
    }
}

