/*
 * Decompiled with CFR 0.152.
 */
package com.leisuretimedock.blasttravelreborn.client.entity;

import com.leisuretimedock.blasttravelreborn.BlastTravelReborn;
import com.leisuretimedock.blasttravelreborn.content.entity.CannonEntity;
import com.leisuretimedock.blasttravelreborn.content.entity.cannon.CannonBehavior;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class CannonEntityRenderer
extends EntityRenderer<CannonEntity> {
    public static final ModelLayerLocation MODEL = new ModelLayerLocation(BlastTravelReborn.id("cannon"), "main");
    private static final ResourceLocation[] FIRE_TEXTURES = new ResourceLocation[]{BlastTravelReborn.id("textures/entity/cannon_fire/frame_0.png"), BlastTravelReborn.id("textures/entity/cannon_fire/frame_1.png"), BlastTravelReborn.id("textures/entity/cannon_fire/frame_2.png"), BlastTravelReborn.id("textures/entity/cannon_fire/frame_3.png"), BlastTravelReborn.id("textures/entity/cannon_fire/frame_4.png")};
    private static final ResourceLocation[] DYED_FIRE_TEXTURES = new ResourceLocation[]{BlastTravelReborn.id("textures/entity/cannon_fire/dyed_frame_0.png"), BlastTravelReborn.id("textures/entity/cannon_fire/dyed_frame_1.png"), BlastTravelReborn.id("textures/entity/cannon_fire/dyed_frame_2.png"), BlastTravelReborn.id("textures/entity/cannon_fire/dyed_frame_3.png"), BlastTravelReborn.id("textures/entity/cannon_fire/dyed_frame_4.png")};
    private static final ResourceLocation[] SMOKE_TEXTURES = new ResourceLocation[]{BlastTravelReborn.id("textures/entity/cannon_smoke/frame_0.png"), BlastTravelReborn.id("textures/entity/cannon_smoke/frame_1.png"), BlastTravelReborn.id("textures/entity/cannon_smoke/frame_2.png"), BlastTravelReborn.id("textures/entity/cannon_smoke/frame_3.png"), BlastTravelReborn.id("textures/entity/cannon_smoke/frame_4.png")};
    private final ModelPart root;
    private final ModelPart leftWheel;
    private final ModelPart rightWheel;
    private final ModelPart cannon;
    private final ModelPart chains;
    private final ModelPart fuse;
    private final ModelPart playerHead;
    private final ModelPart fire;

    public CannonEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelPart = context.m_174023_(MODEL);
        this.root = modelPart.m_171324_("main");
        this.leftWheel = this.root.m_171324_("left_wheel");
        this.rightWheel = this.root.m_171324_("right_wheel");
        this.cannon = this.root.m_171324_("cannon");
        this.playerHead = this.root.m_171324_("player_head");
        this.fire = this.root.m_171324_("fire");
        this.chains = this.cannon.m_171324_("chains");
        this.fuse = this.cannon.m_171324_("fuse");
        this.resetModel();
    }

    private void resetModel() {
        this.rightWheel.f_104203_ = 0.0f;
        this.leftWheel.f_104203_ = 0.0f;
        this.cannon.f_104203_ = 0.0f;
        this.cannon.f_104207_ = true;
        this.playerHead.f_104207_ = false;
        this.fuse.f_104207_ = true;
        this.chains.f_104207_ = false;
        this.fire.f_104207_ = false;
    }

    @NotNull
    public ResourceLocation getTextureLocation(CannonEntity entity) {
        return entity.getBehavior().texture(entity.getBehaviorStack());
    }

    public void render(@NotNull CannonEntity entity, float yaw, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light) {
        boolean renderCannon;
        float wheelAngle;
        super.m_7392_((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        matrices.m_85836_();
        CannonBehavior behavior = entity.getBehavior();
        yaw = (180.0f + yaw) * ((float)Math.PI / 180);
        this.leftWheel.f_104203_ = wheelAngle = yaw * 1.2f;
        this.rightWheel.f_104203_ = -wheelAngle;
        this.cannon.f_104203_ = (entity.m_5686_(tickDelta) + 90.0f) * ((float)Math.PI / 180);
        this.cannon.f_104207_ = renderCannon = entity.m_146895_() != Minecraft.m_91087_().f_91074_ || Minecraft.m_91087_().f_91063_.m_109153_().m_90594_();
        this.chains.f_104207_ = entity.hasChains();
        this.fuse.f_104207_ = entity.hasFuse();
        matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        matrices.m_252781_(Axis.f_252436_.m_252961_(yaw));
        float anim = entity.getAnimation(tickDelta);
        matrices.m_252781_(Axis.f_252529_.m_252977_(-5.0f * (-2.0f * (anim * anim * anim * anim * anim * anim * anim * anim) + 2.0f * (anim * anim))));
        this.root.m_104301_(matrices, vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity))), light, OverlayTexture.f_118083_);
        Vector3f color = behavior.fireColor(entity);
        int tick = Math.max(0, 12 - entity.getAnimationTick() - 3);
        if (tick <= 7) {
            this.fire.f_104207_ = true;
            this.fire.f_104203_ = this.cannon.f_104203_;
        }
        if (tick <= 4) {
            if (color != null) {
                this.fire.m_104306_(matrices, vertexConsumers.m_6299_(RenderType.m_110488_((ResourceLocation)DYED_FIRE_TEXTURES[tick])), light, OverlayTexture.f_118083_, color.x, color.y, color.z, 1.0f);
            } else {
                this.fire.m_104301_(matrices, vertexConsumers.m_6299_(RenderType.m_110488_((ResourceLocation)FIRE_TEXTURES[tick])), light, OverlayTexture.f_118083_);
            }
        }
        if ((tick -= 3) >= 0 && tick <= 4) {
            this.fire.m_104306_(matrices, vertexConsumers.m_6299_(RenderType.m_110473_((ResourceLocation)SMOKE_TEXTURES[tick])), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.9f - 0.07f * (float)tick);
        }
        if (renderCannon && behavior.displayHead(entity)) {
            this.playerHead.f_104207_ = true;
            this.playerHead.f_104203_ = this.cannon.f_104203_;
            color = behavior.headColor(entity);
            this.playerHead.m_104306_(matrices, vertexConsumers.m_6299_(RenderType.m_110458_((ResourceLocation)behavior.headTexture(entity))), light, OverlayTexture.f_118083_, color.x, color.y, color.z, 1.0f);
        }
        this.resetModel();
        matrices.m_85849_();
    }
}

