/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1923;
import org.jetbrains.annotations.NotNull;
import ru.casperix.map_improvements.composite.ColumnBlock;
import ru.casperix.map_improvements.composite.MapContext;
import ru.casperix.map_improvements.composite.WorldColumn;
import ru.casperix.map_improvements.composite.collector.ColumnCollector;
import ru.casperix.map_improvements.composite.drawer.MapDrawer;
import ru.casperix.map_improvements.composite.drawer.MapDrawerContext;
import ru.casperix.math.axis_aligned.int32.Box2i;
import ru.casperix.math.vector.int32.Vector2i;
import ru.casperix.math.vector.int32.Vector3i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010$\u001a\u0004\b%\u0010&R#\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020(0'8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lru/casperix/map_improvements/composite/MapCompositor;", "", "", "Lru/casperix/math/vector/int32/Vector2i;", "tiles", "Lru/casperix/map_improvements/composite/MapContext;", "mapContext", "Lru/casperix/map_improvements/composite/collector/ColumnCollector;", "columnCollector", "Lru/casperix/map_improvements/composite/drawer/MapDrawer;", "mapDrawer", "<init>", "(Ljava/util/List;Lru/casperix/map_improvements/composite/MapContext;Lru/casperix/map_improvements/composite/collector/ColumnCollector;Lru/casperix/map_improvements/composite/drawer/MapDrawer;)V", "Lru/casperix/math/vector/int32/Vector3i;", "viewPosition3d", "", "viewRange", "", "updateVisibleArea", "(Lru/casperix/math/vector/int32/Vector3i;I)V", "updateBanners", "()V", "worldPos", "viewPosition", "", "rangeFilter", "(Lru/casperix/math/vector/int32/Vector2i;Lru/casperix/math/vector/int32/Vector2i;I)Z", "Ljava/util/List;", "getTiles", "()Ljava/util/List;", "Lru/casperix/map_improvements/composite/MapContext;", "getMapContext", "()Lru/casperix/map_improvements/composite/MapContext;", "Lru/casperix/map_improvements/composite/collector/ColumnCollector;", "getColumnCollector", "()Lru/casperix/map_improvements/composite/collector/ColumnCollector;", "Lru/casperix/map_improvements/composite/drawer/MapDrawer;", "getMapDrawer", "()Lru/casperix/map_improvements/composite/drawer/MapDrawer;", "", "Lru/casperix/map_improvements/composite/WorldColumn;", "columnMap", "Ljava/util/Map;", "getColumnMap", "()Ljava/util/Map;", "map_improvements-mc1.21.1"})
@SourceDebugExtension(value={"SMAP\nMapCompositor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapCompositor.kt\nru/casperix/map_improvements/composite/MapCompositor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,68:1\n1208#2,2:69\n1236#2,4:71\n1869#2:85\n1869#2,2:86\n1870#2:88\n1869#2,2:89\n126#3:75\n153#3,3:76\n126#3:79\n153#3,3:80\n216#3,2:83\n*S KotlinDebug\n*F\n+ 1 MapCompositor.kt\nru/casperix/map_improvements/composite/MapCompositor\n*L\n17#1:69,2\n17#1:71,4\n49#1:85\n50#1:86,2\n49#1:88\n55#1:89,2\n25#1:75\n25#1:76,3\n29#1:79\n29#1:80,3\n33#1:83,2\n*E\n"})
public final class MapCompositor {
    @NotNull
    private final List<Vector2i> tiles;
    @NotNull
    private final MapContext mapContext;
    @NotNull
    private final ColumnCollector columnCollector;
    @NotNull
    private final MapDrawer mapDrawer;
    @NotNull
    private final Map<Vector2i, WorldColumn> columnMap;

    /*
     * WARNING - void declaration
     */
    public MapCompositor(@NotNull List<Vector2i> tiles, @NotNull MapContext mapContext, @NotNull ColumnCollector columnCollector, @NotNull MapDrawer mapDrawer) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(tiles, (String)"tiles");
        Intrinsics.checkNotNullParameter((Object)mapContext, (String)"mapContext");
        Intrinsics.checkNotNullParameter((Object)columnCollector, (String)"columnCollector");
        Intrinsics.checkNotNullParameter((Object)mapDrawer, (String)"mapDrawer");
        this.tiles = tiles;
        this.mapContext = mapContext;
        this.columnCollector = columnCollector;
        this.mapDrawer = mapDrawer;
        Iterable iterable = this.columnCollector.create(this.tiles);
        MapCompositor mapCompositor = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var8_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            WorldColumn worldColumn = (WorldColumn)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getWorldPos(), element$iv$iv);
        }
        mapCompositor.columnMap = destination$iv$iv;
    }

    @NotNull
    public final List<Vector2i> getTiles() {
        return this.tiles;
    }

    @NotNull
    public final MapContext getMapContext() {
        return this.mapContext;
    }

    @NotNull
    public final ColumnCollector getColumnCollector() {
        return this.columnCollector;
    }

    @NotNull
    public final MapDrawer getMapDrawer() {
        return this.mapDrawer;
    }

    @NotNull
    public final Map<Vector2i, WorldColumn> getColumnMap() {
        return this.columnMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateVisibleArea(@NotNull Vector3i viewPosition3d, int viewRange) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)viewPosition3d, (String)"viewPosition3d");
        Vector2i viewPosition = viewPosition3d.getXZ();
        Map<Vector2i, WorldColumn> $this$map$iv = this.columnMap;
        boolean $i$f$map = false;
        Map<Vector2i, WorldColumn> map = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Vector2i pos = (Vector2i)entry2.getKey();
            WorldColumn info = (WorldColumn)entry2.getValue();
            collection.add(TuplesKt.to((Object)pos, (Object)info.getSolid().getHeight()));
        }
        Map solidHeightMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Map<Vector2i, WorldColumn> $this$map$iv2 = this.columnMap;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv3;
            Map.Entry bl = item$iv$iv3 = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Vector2i pos = (Vector2i)bl.getKey();
            WorldColumn info = (WorldColumn)bl.getValue();
            ColumnBlock columnBlock = (ColumnBlock)CollectionsKt.firstOrNull(info.getTransparentList());
            collection.add(TuplesKt.to((Object)pos, (Object)(columnBlock != null ? columnBlock.getHeight() : info.getSolid().getHeight())));
        }
        Map transparentOrSolidHeightMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        Map<Vector2i, WorldColumn> $this$forEach$iv = this.columnMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Vector2i, WorldColumn>> iterator3 = $this$forEach$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<Vector2i, WorldColumn> element$iv;
            Map.Entry<Vector2i, WorldColumn> entry = element$iv = iterator3.next();
            boolean bl = false;
            Vector2i worldPos = entry.getKey();
            WorldColumn column = entry.getValue();
            if (!this.rangeFilter(worldPos, viewPosition, viewRange)) continue;
            Vector2i mapPosLocal = this.mapContext.worldPosToMapPos(worldPos);
            int pos = mapPosLocal.getX();
            boolean bl2 = 0 <= pos ? pos < 128 : false;
            if (!bl2) continue;
            pos = mapPosLocal.getY();
            boolean bl3 = 0 <= pos ? pos < 128 : false;
            if (!bl3) continue;
            MapDrawerContext drawerContext = new MapDrawerContext(this.mapContext.getMapData(), column, solidHeightMap, transparentOrSolidHeightMap);
            this.mapDrawer.draw(drawerContext);
        }
    }

    public final void updateBanners() {
        Set chunkCoordinates = new LinkedHashSet();
        Box2i mapArea = this.mapContext.getMapArea();
        Iterable $this$forEach$iv = (Iterable)RangesKt.step((IntProgression)((IntProgression)new IntRange(mapArea.getMin().getX().intValue(), mapArea.getMax().getX().intValue())), (int)16);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int x = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.step((IntProgression)((IntProgression)new IntRange(mapArea.getMin().getY().intValue(), mapArea.getMax().getY().intValue())), (int)16);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv2;
                int y = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                chunkCoordinates.add(new class_1923(x >> 4, y >> 4));
            }
        }
        $this$forEach$iv = chunkCoordinates;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_1923 chunkPos = (class_1923)element$iv;
            boolean bl = false;
            int worldX = chunkPos.field_9181 * 16 + 8;
            int worldZ = chunkPos.field_9180 * 16 + 8;
        }
    }

    private final boolean rangeFilter(Vector2i worldPos, Vector2i viewPosition, int viewRange) {
        return worldPos.distTo(viewPosition) <= viewRange;
    }
}

