/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite.collector;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.casperix.map_improvements.MinecraftBlockAnalyze;
import ru.casperix.map_improvements.composite.CompositingCategory;
import ru.casperix.map_improvements.config.BlockRenderConfig;
import ru.casperix.map_improvements.types.TypeExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lru/casperix/map_improvements/composite/collector/CompositingCategoryCalculator;", "", "<init>", "()V", "Lnet/minecraft/class_2680;", "block", "Lru/casperix/map_improvements/config/BlockRenderConfig;", "config", "Lru/casperix/map_improvements/composite/CompositingCategory;", "getCategory", "(Lnet/minecraft/class_2680;Lru/casperix/map_improvements/config/BlockRenderConfig;)Lru/casperix/map_improvements/composite/CompositingCategory;", "getByConfig", "getExplicitly", "(Lnet/minecraft/class_2680;)Lru/casperix/map_improvements/composite/CompositingCategory;", "map_improvements-mc1.21.1"})
public final class CompositingCategoryCalculator {
    @NotNull
    public static final CompositingCategoryCalculator INSTANCE = new CompositingCategoryCalculator();

    private CompositingCategoryCalculator() {
    }

    @NotNull
    public final CompositingCategory getCategory(@NotNull class_2680 block, @NotNull BlockRenderConfig config) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (block.method_26215()) {
            return CompositingCategory.HIDDEN;
        }
        CompositingCategory categoryByName = this.getByConfig(block, config);
        if (categoryByName != null) {
            return categoryByName;
        }
        return this.getExplicitly(block);
    }

    @Nullable
    public final CompositingCategory getByConfig(@NotNull class_2680 block, @NotNull BlockRenderConfig config) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = TypeExtensionsKt.identifier(block).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String blockId = string;
        if (config.getHiddenList().contains(blockId)) {
            return CompositingCategory.HIDDEN;
        }
        Double d = config.getBlockAlphaMap().get(blockId);
        if (d == null) {
            return null;
        }
        double alpha = d;
        return alpha >= 1.0 ? CompositingCategory.SOLID : CompositingCategory.TRANSLUCENT;
    }

    private final CompositingCategory getExplicitly(class_2680 block) {
        if (!block.method_26227().method_15769() || MinecraftBlockAnalyze.INSTANCE.isLeaves(block) || !block.method_26225() || block.method_26211()) {
            return CompositingCategory.TRANSLUCENT;
        }
        return CompositingCategory.SOLID;
    }
}

