/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.mixin;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_5321;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.casperix.RGBAMapFeature;
import ru.casperix.map_improvements.LoggerKt;
import ru.casperix.map_improvements.VanillaColorConverter;
import ru.casperix.map_improvements.misc.ByteBufferExt;
import ru.casperix.map_improvements.misc.MathExtKt;
import ru.casperix.map_improvements.misc.PixelMap;
import ru.casperix.map_improvements.types.ABGRColor;
import ru.casperix.map_improvements.types.ColorFormat;
import ru.casperix.map_improvements.types.MapDTO;
import ru.casperix.map_improvements.types.MapLayerDTO;
import ru.casperix.math.array.ArrayAccessND;
import ru.casperix.math.axis_aligned.int32.Box2i;
import ru.casperix.math.vector.int32.Vector2i;

@Mixin(value={class_22.class})
public abstract class MapStateMixin
implements RGBAMapFeature {
    @Shadow
    public byte[] field_122;
    @Unique
    private Logger logger = LoggerKt.getLogger();
    @Shadow
    @Final
    public int field_116;
    @Shadow
    @Final
    public int field_115;
    @Shadow
    @Final
    public byte field_119;
    @Unique
    public long modifyCounter = 0L;
    @Unique
    private PixelMap pixelMap = new PixelMap(new Vector2i(128, 128));

    @Shadow
    protected abstract void method_103(int var1, int var2);

    @Inject(method={"<init>(IIBZZZLnet/minecraft/class_5321;)V"}, at={@At(value="RETURN")})
    public void onConstructor(int i, int j, byte b, boolean bl, boolean bl2, boolean bl3, class_5321<class_1937> resourceKey, CallbackInfo ci) {
        this.rgbaColorsFromVanillaColors();
    }

    @Override
    @Unique
    public void mi_setRGBAColor(Vector2i position, ABGRColor rgbaColor) {
        Integer index = MathExtKt.index2DOrNull(ArrayAccessND.INSTANCE, this.pixelMap.getSize(), position);
        if (index == null) {
            return;
        }
        ABGRColor lastColor = this.pixelMap.getColor(index);
        if (lastColor.equals(rgbaColor)) {
            return;
        }
        byte byteColor = VanillaColorConverter.INSTANCE.rgbaToVanillaPackedColor(rgbaColor);
        this.setColorDirectly(index, position, rgbaColor, byteColor);
    }

    @Override
    @Unique
    public ABGRColor mi_getRGBAColor(Vector2i position) {
        Integer index = MathExtKt.index2DOrNull(ArrayAccessND.INSTANCE, this.pixelMap.getSize(), position);
        if (index == null) {
            return ABGRColor.Companion.getEMPTY();
        }
        return this.pixelMap.getColor(index);
    }

    @Unique
    @Inject(method={"method_32370(IIB)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void setColor(int x, int y, byte byteColor, CallbackInfo ci) {
        Vector2i position = new Vector2i(x, y);
        Integer index = MathExtKt.index2DOrNull(ArrayAccessND.INSTANCE, this.pixelMap.getSize(), position);
        if (index == null) {
            return;
        }
        ABGRColor rgbaColor = VanillaColorConverter.INSTANCE.vanillaPackedColorToRgba(byteColor);
        ABGRColor lastColor = this.pixelMap.getColor(index);
        if (lastColor.equals(rgbaColor)) {
            return;
        }
        this.setColorDirectly(index, position, rgbaColor, byteColor);
        ci.cancel();
    }

    @Unique
    private void setColorDirectly(Integer index, Vector2i position, ABGRColor rgbaColor, byte byteColor) {
        ++this.modifyCounter;
        this.pixelMap.setColor(index, rgbaColor);
        this.field_122[index.intValue()] = byteColor;
        this.method_103(position.getX(), position.getY());
    }

    @Unique
    private void rgbaColorsFromVanillaColors() {
        class_22 self = (class_22)this;
        if (self.field_122 == null || self.field_122.length != this.pixelMap.getSize().volume()) {
            return;
        }
        VanillaColorConverter.INSTANCE.vanillaPackedColorToRgba(this.pixelMap.getIntView(), self.field_122);
    }

    @Override
    @Unique
    public long mi_getModifyCounter() {
        return this.modifyCounter;
    }

    @Override
    @Unique
    public MapDTO mi_getMapDto() {
        return new MapDTO(this.pixelMap.getSize(), new Vector2i(this.field_116, this.field_115), this.field_119, new MapLayerDTO(ColorFormat.ABGR, Box2i.Companion.byDimension(Vector2i.Companion.getZERO(), this.pixelMap.getSize()), this.pixelMap.getByteBuffer()));
    }

    @Override
    @Unique
    public void mi_setMapDto(MapDTO dto) {
        if (dto.getPrimaryLayer().getFormat() != ColorFormat.ABGR) {
            this.logger.warn("Expected color format: {} but actual is {}", (Object)ColorFormat.ABGR, (Object)dto.getPrimaryLayer().getFormat());
            return;
        }
        if (!this.pixelMap.getSize().equals((Object)dto.getSize())) {
            this.logger.warn("Incompatible size. Expected {} but actual is {}", (Object)this.pixelMap.getSize(), (Object)dto.getSize());
            return;
        }
        if (!this.pixelMap.getSize().equals((Object)dto.getPrimaryLayer().getRegion().getDimension())) {
            this.logger.warn("Incompatible region dimension. Expected {} but actual is {}", (Object)this.pixelMap.getSize(), (Object)dto.getPrimaryLayer().getRegion().getDimension());
            return;
        }
        if (!Vector2i.Companion.getZERO().equals((Object)dto.getPrimaryLayer().getRegion().getMin())) {
            this.logger.warn("Incompatible section start. Expected {} but actual is {}", (Object)Vector2i.Companion.getZERO(), (Object)dto.getPrimaryLayer().getRegion().getMin());
            return;
        }
        ++this.modifyCounter;
        ByteBuffer target = this.pixelMap.getByteBuffer();
        ByteBuffer source = dto.getPrimaryLayer().getColors();
        ByteBuffer sourceDirect = ByteBufferExt.INSTANCE.toDirectBuffer(source);
        MemoryUtil.memCopy((ByteBuffer)sourceDirect, (ByteBuffer)target);
        if (sourceDirect != source) {
            MemoryUtil.memFree((Buffer)sourceDirect);
        }
    }
}

