/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.types;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.casperix.map_improvements.types.ABGRColor;
import ru.casperix.map_improvements.types.ColorFormat;
import ru.casperix.math.array.ArrayAccessND;
import ru.casperix.math.axis_aligned.int32.Box2i;
import ru.casperix.math.vector.int32.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lru/casperix/map_improvements/types/MapLayerDTO;", "", "Lru/casperix/map_improvements/types/ColorFormat;", "format", "Lru/casperix/math/axis_aligned/int32/Box2i;", "region", "Ljava/nio/ByteBuffer;", "colors", "<init>", "(Lru/casperix/map_improvements/types/ColorFormat;Lru/casperix/math/axis_aligned/int32/Box2i;Ljava/nio/ByteBuffer;)V", "Lru/casperix/math/vector/int32/Vector2i;", "position", "Lru/casperix/map_improvements/types/ABGRColor;", "getColor", "(Lru/casperix/math/vector/int32/Vector2i;)Lru/casperix/map_improvements/types/ABGRColor;", "Lru/casperix/map_improvements/types/ColorFormat;", "getFormat", "()Lru/casperix/map_improvements/types/ColorFormat;", "Lru/casperix/math/axis_aligned/int32/Box2i;", "getRegion", "()Lru/casperix/math/axis_aligned/int32/Box2i;", "Ljava/nio/ByteBuffer;", "getColors", "()Ljava/nio/ByteBuffer;", "map_improvements-mc1.20.1"})
public final class MapLayerDTO {
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final Box2i region;
    @NotNull
    private final ByteBuffer colors;

    public MapLayerDTO(@NotNull ColorFormat format, @NotNull Box2i region, @NotNull ByteBuffer colors) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.format = format;
        this.region = region;
        this.colors = colors;
    }

    @NotNull
    public final ColorFormat getFormat() {
        return this.format;
    }

    @NotNull
    public final Box2i getRegion() {
        return this.region;
    }

    @NotNull
    public final ByteBuffer getColors() {
        return this.colors;
    }

    @NotNull
    public final ABGRColor getColor(@NotNull Vector2i position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        IntBuffer intView = this.colors.asIntBuffer();
        int raw = intView.get(ArrayAccessND.INSTANCE.index2D(this.region.getDimension(), position));
        return new ABGRColor(raw);
    }
}

